/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.math.hex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.math.hex.HexagonKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0000J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0003H\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/veiset/kgame/engine/math/hex/Hex;", "", "q", "", "r", "(II)V", "getQ", "()I", "getR", "s", "getS", "component1", "component2", "copy", "distance", "hex", "equals", "", "other", "hashCode", "length", "neightbors", "", "toString", "", "kgame2"})
public final class Hex {
    private final int q;
    private final int r;
    private final int s;

    public Hex(int q, int r) {
        this.q = q;
        this.r = r;
        this.s = -this.q - this.r;
    }

    public final int getQ() {
        return this.q;
    }

    public final int getR() {
        return this.r;
    }

    public final int getS() {
        return this.s;
    }

    public final int distance(@NotNull Hex hex) {
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        return HexagonKt.minus(this, hex).length();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Hex> neightbors() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = HexagonKt.getHexDirections();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void direction;
            Hex hex = (Hex)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Hex hex2 = HexagonKt.plus(this, (Hex)direction);
            collection.add(hex2);
        }
        return (List)destination$iv$iv;
    }

    private final int length() {
        int n = this.q;
        boolean bl = false;
        int n2 = Math.abs(n);
        n = this.r;
        bl = false;
        int n3 = n2 + Math.abs(n);
        n = this.s;
        bl = false;
        return (n3 + Math.abs(n)) / 2;
    }

    public final int component1() {
        return this.q;
    }

    public final int component2() {
        return this.r;
    }

    @NotNull
    public final Hex copy(int q, int r) {
        return new Hex(q, r);
    }

    public static /* synthetic */ Hex copy$default(Hex hex, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = hex.q;
        }
        if ((n3 & 2) != 0) {
            n2 = hex.r;
        }
        return hex.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "Hex(q=" + this.q + ", r=" + this.r + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.q);
        result = result * 31 + Integer.hashCode(this.r);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Hex)) {
            return false;
        }
        Hex hex = (Hex)other;
        if (this.q != hex.q) {
            return false;
        }
        return this.r == hex.r;
    }
}

