/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.storage;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.storage.TextureStore;
import org.veiset.kgame.engine.storage.TextureUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/veiset/kgame/engine/storage/AnimationStore;", "", "textures", "Lorg/veiset/kgame/engine/storage/TextureStore;", "(Lorg/veiset/kgame/engine/storage/TextureStore;)V", "explosion", "Lcom/badlogic/gdx/graphics/g2d/Animation;", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "getExplosion", "()Lcom/badlogic/gdx/graphics/g2d/Animation;", "fireAttack", "getFireAttack", "mouseClick", "getMouseClick", "poisonCloud", "getPoisonCloud", "slowExplosion", "getSlowExplosion", "splash", "getSplash", "worldPortal", "getWorldPortal", "kgame2"})
public final class AnimationStore {
    @NotNull
    private final Animation<TextureRegion> explosion;
    @NotNull
    private final Animation<TextureRegion> slowExplosion;
    @NotNull
    private final Animation<TextureRegion> poisonCloud;
    @NotNull
    private final Animation<TextureRegion> fireAttack;
    @NotNull
    private final Animation<TextureRegion> mouseClick;
    @NotNull
    private final Animation<TextureRegion> splash;
    @NotNull
    private final Animation<TextureRegion> worldPortal;

    public AnimationStore(@NotNull TextureStore textures) {
        Intrinsics.checkNotNullParameter((Object)textures, (String)"textures");
        this.explosion = new Animation(0.03f, TextureUtilsKt.toGdxArray(textures.getExplosion()));
        this.slowExplosion = new Animation(0.04f, TextureUtilsKt.toGdxArray(textures.getExplosion()));
        this.poisonCloud = new Animation(0.1f, TextureUtilsKt.toGdxArray(textures.getPoisonCloud()));
        this.fireAttack = new Animation(0.08f, TextureUtilsKt.toGdxArray(textures.getFireAttack()));
        this.mouseClick = new Animation(0.1f, TextureUtilsKt.toGdxArray(textures.getMouseClickSprite()));
        this.splash = new Animation(0.02f, TextureUtilsKt.toGdxArray(textures.getWaterSplashSprite()));
        this.worldPortal = new Animation(0.08f, TextureUtilsKt.toGdxArray(textures.getWorldPortal()));
    }

    @NotNull
    public final Animation<TextureRegion> getExplosion() {
        return this.explosion;
    }

    @NotNull
    public final Animation<TextureRegion> getSlowExplosion() {
        return this.slowExplosion;
    }

    @NotNull
    public final Animation<TextureRegion> getPoisonCloud() {
        return this.poisonCloud;
    }

    @NotNull
    public final Animation<TextureRegion> getFireAttack() {
        return this.fireAttack;
    }

    @NotNull
    public final Animation<TextureRegion> getMouseClick() {
        return this.mouseClick;
    }

    @NotNull
    public final Animation<TextureRegion> getSplash() {
        return this.splash;
    }

    @NotNull
    public final Animation<TextureRegion> getWorldPortal() {
        return this.worldPortal;
    }
}

