/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.tileset;

import com.badlogic.ashley.core.Engine;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.utils.ScreenUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.GameModule;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.editor.tileset.WorldgenModuleKt;
import org.veiset.kgame.engine.tools.ui.components.InputField;
import org.veiset.kgame.engine.world.Gridslot;
import org.veiset.kgame.engine.world.MixedForestTiles;
import org.veiset.kgame.engine.world.WorldMap;
import org.veiset.kgame.engine.world.WorldMapKt;
import org.veiset.kgame.engine.world.WorldMapTileThreshold;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u0001H\u0016J\b\u0010%\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020#H\u0016J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lorg/veiset/kgame/engine/tools/editor/tileset/WorldgenModule;", "Lorg/veiset/kgame/engine/GameModule;", "engine", "Lcom/badlogic/ashley/core/Engine;", "tileset", "Lorg/veiset/kgame/engine/world/WorldMapTileThreshold;", "areaRng", "", "(Lcom/badlogic/ashley/core/Engine;Lorg/veiset/kgame/engine/world/WorldMapTileThreshold;F)V", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "filenameInputField", "Lorg/veiset/kgame/engine/tools/ui/components/InputField;", "grid", "", "", "Lorg/veiset/kgame/engine/world/Gridslot;", "getGrid", "()Ljava/util/Map;", "sb", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "getSb", "()Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "size", "getSize", "()F", "sr", "Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "getSr", "()Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "worldmap", "Lorg/veiset/kgame/engine/world/WorldMap;", "getWorldmap", "()Lorg/veiset/kgame/engine/world/WorldMap;", "keybindings", "", "nextState", "setup", "teardown", "update", "delta", "kgame2"})
public final class WorldgenModule
implements GameModule {
    @NotNull
    private final Engine engine;
    private final float size;
    @NotNull
    private final WorldMap worldmap;
    @NotNull
    private final Map<String, Gridslot> grid;
    @NotNull
    private final ShapeRenderer sr;
    @NotNull
    private final SpriteBatch sb;
    @NotNull
    private final InputField filenameInputField;

    public WorldgenModule(@NotNull Engine engine, @NotNull WorldMapTileThreshold tileset, float areaRng) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)tileset, (String)"tileset");
        this.engine = engine;
        float f = 1920.0f / ((Number)tileset.getAreaSize().getFirst()).floatValue();
        float f2 = 1080.0f / ((Number)tileset.getAreaSize().getSecond()).floatValue();
        boolean bl = false;
        this.size = Math.min(f, f2);
        this.worldmap = (WorldMap)LoggerKt.logTimed$default("map generation", null, (Function0)new Function0<WorldMap>(tileset, areaRng){
            final /* synthetic */ WorldMapTileThreshold $tileset;
            final /* synthetic */ float $areaRng;
            {
                this.$tileset = $tileset;
                this.$areaRng = $areaRng;
                super(0);
            }

            @NotNull
            public final WorldMap invoke() {
                return new WorldMap(this.$tileset, this.$areaRng, 0L, 4, null);
            }
        }, 2, null);
        this.grid = this.worldmap.getGrid();
        this.sr = TBEngineKt.getGlobals().getDrawUi().getShapeRenderer();
        this.sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        this.filenameInputField = new InputField(Vector2Kt.x(13.7f, 8.61f), Vector2Kt.x(2.2f, 0.3f), "");
    }

    public /* synthetic */ WorldgenModule(Engine engine, WorldMapTileThreshold worldMapTileThreshold, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            worldMapTileThreshold = new MixedForestTiles(null, null, 3, null);
        }
        if ((n & 4) != 0) {
            f = 3.0f;
        }
        this(engine, worldMapTileThreshold, f);
    }

    @Override
    @NotNull
    public Engine getEngine() {
        return this.engine;
    }

    public final float getSize() {
        return this.size;
    }

    @NotNull
    public final WorldMap getWorldmap() {
        return this.worldmap;
    }

    @NotNull
    public final Map<String, Gridslot> getGrid() {
        return this.grid;
    }

    @NotNull
    public final ShapeRenderer getSr() {
        return this.sr;
    }

    @NotNull
    public final SpriteBatch getSb() {
        return this.sb;
    }

    @Override
    public void setup() {
    }

    @Override
    public void teardown() {
    }

    private final void keybindings() {
        if (Gdx.input.isKeyJustPressed(31)) {
            WorldgenModuleKt.setColorScaling(!WorldgenModuleKt.getColorScaling());
        }
        if (Gdx.input.isKeyJustPressed(48)) {
            WorldgenModuleKt.setShowTiles(!WorldgenModuleKt.getShowTiles());
        }
        if (Gdx.input.isKeyJustPressed(29)) {
            LoggerKt.logTimed$default("add 10x10 area", null, (Function0)new Function0<Pair<? extends Integer, ? extends Integer>>(this){
                final /* synthetic */ WorldgenModule this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Pair<Integer, Integer> invoke() {
                    return WorldMapKt.addAreaToGrid$default(this.this$0.getGrid(), 10, 10, null, 4, null);
                }
            }, 2, null);
        }
        if (Gdx.input.isKeyJustPressed(32)) {
            LoggerKt.logTimed$default("add 2x2 area", null, (Function0)new Function0<Pair<? extends Integer, ? extends Integer>>(this){
                final /* synthetic */ WorldgenModule this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Pair<Integer, Integer> invoke() {
                    return WorldMapKt.addAreaToGrid$default(this.this$0.getGrid(), 2, 2, null, 4, null);
                }
            }, 2, null);
        }
        if (Gdx.input.isKeyJustPressed(51)) {
            WorldgenModuleKt.setShowOccupied(!WorldgenModuleKt.getShowOccupied());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(float delta) {
        int y;
        int x;
        Pair<Integer, Integer> pair;
        void blue$iv;
        void green$iv;
        void red$iv;
        this.keybindings();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float alpha$iv = 1.0f;
        boolean clearDepth$iv = true;
        boolean $i$f$clearScreen = false;
        ScreenUtils.clear((float)red$iv, (float)green$iv, (float)blue$iv, (float)alpha$iv, (boolean)clearDepth$iv);
        if (WorldgenModuleKt.getShowTiles()) {
            this.sb.begin();
            Iterable $this$forEach$iv = this.grid.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Gridslot gridslot = (Gridslot)element$iv;
                boolean bl = false;
                pair = gridslot.getPosition();
                x = ((Number)pair.component1()).intValue();
                y = ((Number)pair.component2()).intValue();
                this.getSb().draw(gridslot.getTexture(), (float)x * this.getSize(), (float)y * this.getSize(), this.getSize(), this.getSize());
            }
            this.sb.end();
        }
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        Iterable $this$forEach$iv = this.grid.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Gridslot gridslot = (Gridslot)element$iv;
            boolean bl = false;
            pair = gridslot.getPosition();
            x = ((Number)pair.component1()).intValue();
            y = ((Number)pair.component2()).intValue();
            if (WorldgenModuleKt.getColorScaling()) {
                this.getSr().setColor(ColorKt.color((float)gridslot.getNoise(), (float)gridslot.getNoise(), (float)gridslot.getNoise(), (float)(gridslot.getNoise() * 0.9f)));
                this.getSr().rect((float)x * this.getSize(), (float)y * this.getSize(), this.getSize(), this.getSize());
            }
            if (!gridslot.getOccupied() || !WorldgenModuleKt.getShowOccupied()) continue;
            this.getSr().setColor(ColorKt.color((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6f));
            this.getSr().rect((float)x * this.getSize(), (float)y * this.getSize(), this.getSize(), this.getSize());
        }
        this.sr.end();
        Gdx.gl.glDisable(3042);
        this.filenameInputField.draw();
        this.filenameInputField.update();
    }

    @Override
    @NotNull
    public GameModule nextState() {
        if (Gdx.input.isKeyJustPressed(46)) {
            return new WorldgenModule(new Engine(), null, 0.0f, 6, null);
        }
        return this;
    }
}

