/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.util;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.ecs.system.graphics.DrawSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0082\u0001\u0003\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lorg/veiset/kgame/engine/util/TargetType;", "", "()V", "inRange", "", "pos", "Lcom/badlogic/gdx/math/Vector2;", "target", "camera", "Lcom/badlogic/gdx/graphics/Camera;", "Distance", "OnScreen", "XYDistance", "Lorg/veiset/kgame/engine/util/TargetType$OnScreen;", "Lorg/veiset/kgame/engine/util/TargetType$Distance;", "Lorg/veiset/kgame/engine/util/TargetType$XYDistance;", "kgame2"})
public abstract class TargetType {
    private TargetType() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean inRange(@NotNull Vector2 pos, @NotNull Vector2 target, @Nullable Camera camera) {
        boolean bl;
        Camera camera2;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        TargetType targetType = this;
        if (Intrinsics.areEqual((Object)targetType, (Object)OnScreen.INSTANCE)) {
            camera2 = camera;
            if (camera2 == null) {
                return false;
            }
        } else {
            if (targetType instanceof Distance) {
                if (!(target.dst(pos) <= ((Distance)this).getDistance())) return false;
                return true;
            }
            if (!(targetType instanceof XYDistance)) throw new NoWhenBranchMatchedException();
            Vector2 vector2 = ((XYDistance)this).getDistance();
            float x = Vector2Kt.component1(vector2);
            float y = Vector2Kt.component2(vector2);
            Vector2 vector22 = target;
            float tx = Vector2Kt.component1(vector22);
            float ty = Vector2Kt.component2(vector22);
            Vector2 vector23 = pos;
            float cx = Vector2Kt.component1(vector23);
            float cy = Vector2Kt.component2(vector23);
            float f = tx - cx;
            boolean bl2 = false;
            if (!(Math.abs(f) <= x)) return false;
            f = ty - cy;
            bl2 = false;
            if (!(Math.abs(f) <= y)) return false;
            return true;
        }
        boolean bl3 = bl = DrawSystemKt.shouldRender(camera2, target, Vector2Kt.x(0.0f, 0.0f));
        return bl3;
    }

    public static /* synthetic */ boolean inRange$default(TargetType targetType, Vector2 vector2, Vector2 vector22, Camera camera, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: inRange");
        }
        if ((n & 4) != 0) {
            camera = null;
        }
        return targetType.inRange(vector2, vector22, camera);
    }

    public /* synthetic */ TargetType(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/veiset/kgame/engine/util/TargetType$OnScreen;", "Lorg/veiset/kgame/engine/util/TargetType;", "()V", "kgame2"})
    public static final class OnScreen
    extends TargetType {
        @NotNull
        public static final OnScreen INSTANCE = new OnScreen();

        private OnScreen() {
            super(null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/veiset/kgame/engine/util/TargetType$Distance;", "Lorg/veiset/kgame/engine/util/TargetType;", "distance", "", "(F)V", "getDistance", "()F", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kgame2"})
    public static final class Distance
    extends TargetType {
        private final float distance;

        public Distance(float distance) {
            super(null);
            this.distance = distance;
        }

        public final float getDistance() {
            return this.distance;
        }

        public final float component1() {
            return this.distance;
        }

        @NotNull
        public final Distance copy(float distance) {
            return new Distance(distance);
        }

        public static /* synthetic */ Distance copy$default(Distance distance, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = distance.distance;
            }
            return distance.copy(f);
        }

        @NotNull
        public String toString() {
            return "Distance(distance=" + this.distance + ')';
        }

        public int hashCode() {
            return Float.hashCode(this.distance);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Distance)) {
                return false;
            }
            Distance distance = (Distance)other;
            return Intrinsics.areEqual((Object)Float.valueOf(this.distance), (Object)Float.valueOf(distance.distance));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/veiset/kgame/engine/util/TargetType$XYDistance;", "Lorg/veiset/kgame/engine/util/TargetType;", "distance", "Lcom/badlogic/gdx/math/Vector2;", "(Lcom/badlogic/gdx/math/Vector2;)V", "getDistance", "()Lcom/badlogic/gdx/math/Vector2;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kgame2"})
    public static final class XYDistance
    extends TargetType {
        @NotNull
        private final Vector2 distance;

        public XYDistance(@NotNull Vector2 distance) {
            Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
            super(null);
            this.distance = distance;
        }

        @NotNull
        public final Vector2 getDistance() {
            return this.distance;
        }

        @NotNull
        public final Vector2 component1() {
            return this.distance;
        }

        @NotNull
        public final XYDistance copy(@NotNull Vector2 distance) {
            Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
            return new XYDistance(distance);
        }

        public static /* synthetic */ XYDistance copy$default(XYDistance xYDistance, Vector2 vector2, int n, Object object) {
            if ((n & 1) != 0) {
                vector2 = xYDistance.distance;
            }
            return xYDistance.copy(vector2);
        }

        @NotNull
        public String toString() {
            return "XYDistance(distance=" + this.distance + ')';
        }

        public int hashCode() {
            return this.distance.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof XYDistance)) {
                return false;
            }
            XYDistance xYDistance = (XYDistance)other;
            return Intrinsics.areEqual((Object)this.distance, (Object)xYDistance.distance);
        }
    }
}

