/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.world;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.world.Gridslot;
import org.veiset.kgame.engine.world.WorldMapKt;
import org.veiset.kgame.engine.world.WorldMapTileThreshold;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J'\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\u0016H\u00d6\u0001J\t\u0010%\u001a\u00020\u000bH\u00d6\u0001R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"Lorg/veiset/kgame/engine/world/WorldMap;", "", "tileThreshold", "Lorg/veiset/kgame/engine/world/WorldMapTileThreshold;", "randomness", "", "seed", "", "(Lorg/veiset/kgame/engine/world/WorldMapTileThreshold;FJ)V", "grid", "", "", "Lorg/veiset/kgame/engine/world/Gridslot;", "getGrid", "()Ljava/util/Map;", "getRandomness", "()F", "rng", "Lkotlin/random/Random;", "getSeed", "()J", "sizeX", "", "getSizeX", "()I", "sizeY", "getSizeY", "getTileThreshold", "()Lorg/veiset/kgame/engine/world/WorldMapTileThreshold;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "kgame2"})
public final class WorldMap {
    @NotNull
    private final WorldMapTileThreshold tileThreshold;
    private final float randomness;
    private final long seed;
    @NotNull
    private final Random rng;
    private final int sizeX;
    private final int sizeY;
    @NotNull
    private final Map<String, Gridslot> grid;

    public WorldMap(@NotNull WorldMapTileThreshold tileThreshold, float randomness, long seed) {
        Intrinsics.checkNotNullParameter((Object)tileThreshold, (String)"tileThreshold");
        this.tileThreshold = tileThreshold;
        this.randomness = randomness;
        this.seed = seed;
        this.rng = RandomKt.Random((long)this.seed);
        this.sizeX = ((Number)this.tileThreshold.getAreaSize().getFirst()).intValue();
        this.sizeY = ((Number)this.tileThreshold.getAreaSize().getSecond()).intValue();
        int n = this.sizeX;
        int n2 = this.sizeY;
        float f = this.randomness;
        WorldMapTileThreshold worldMapTileThreshold = this.tileThreshold;
        double d = this.rng.nextDouble();
        float f2 = this.rng.nextFloat() * 100.0f;
        this.grid = WorldMapKt.generateEmptyGrid(n, n2, f, d, f2, worldMapTileThreshold);
    }

    public /* synthetic */ WorldMap(WorldMapTileThreshold worldMapTileThreshold, float f, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 3.0f * (float)(((Number)worldMapTileThreshold.getAreaSize().getFirst()).intValue() * ((Number)worldMapTileThreshold.getAreaSize().getSecond()).intValue()) / 2000.0f;
        }
        if ((n & 4) != 0) {
            l = Random.Default.nextLong();
        }
        this(worldMapTileThreshold, f, l);
    }

    @NotNull
    public final WorldMapTileThreshold getTileThreshold() {
        return this.tileThreshold;
    }

    public final float getRandomness() {
        return this.randomness;
    }

    public final long getSeed() {
        return this.seed;
    }

    public final int getSizeX() {
        return this.sizeX;
    }

    public final int getSizeY() {
        return this.sizeY;
    }

    @NotNull
    public final Map<String, Gridslot> getGrid() {
        return this.grid;
    }

    @NotNull
    public final WorldMapTileThreshold component1() {
        return this.tileThreshold;
    }

    public final float component2() {
        return this.randomness;
    }

    public final long component3() {
        return this.seed;
    }

    @NotNull
    public final WorldMap copy(@NotNull WorldMapTileThreshold tileThreshold, float randomness, long seed) {
        Intrinsics.checkNotNullParameter((Object)tileThreshold, (String)"tileThreshold");
        return new WorldMap(tileThreshold, randomness, seed);
    }

    public static /* synthetic */ WorldMap copy$default(WorldMap worldMap2, WorldMapTileThreshold worldMapTileThreshold, float f, long l, int n, Object object) {
        if ((n & 1) != 0) {
            worldMapTileThreshold = worldMap2.tileThreshold;
        }
        if ((n & 2) != 0) {
            f = worldMap2.randomness;
        }
        if ((n & 4) != 0) {
            l = worldMap2.seed;
        }
        return worldMap2.copy(worldMapTileThreshold, f, l);
    }

    @NotNull
    public String toString() {
        return "WorldMap(tileThreshold=" + this.tileThreshold + ", randomness=" + this.randomness + ", seed=" + this.seed + ')';
    }

    public int hashCode() {
        int result = this.tileThreshold.hashCode();
        result = result * 31 + Float.hashCode(this.randomness);
        result = result * 31 + Long.hashCode(this.seed);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WorldMap)) {
            return false;
        }
        WorldMap worldMap2 = (WorldMap)other;
        if (!Intrinsics.areEqual((Object)this.tileThreshold, (Object)worldMap2.tileThreshold)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.randomness), (Object)Float.valueOf(worldMap2.randomness))) {
            return false;
        }
        return this.seed == worldMap2.seed;
    }
}

