/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.module;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.ScreenUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.box2d.WorldsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.GameModule;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.component.enemy.ModifiersComponent;
import org.veiset.kgame.engine.ecs.component.enemy.ModifiersComponentEvent;
import org.veiset.kgame.engine.ecs.component.loot.LootTableComponent;
import org.veiset.kgame.engine.ecs.entity.ItemDropEntity;
import org.veiset.kgame.engine.ecs.entity.PlayerEntity;
import org.veiset.kgame.engine.ecs.system.DeathSystem;
import org.veiset.kgame.engine.ecs.system.DelayAddEntitySystem;
import org.veiset.kgame.engine.ecs.system.FixedDurationSystem;
import org.veiset.kgame.engine.ecs.system.GamePauseSystem;
import org.veiset.kgame.engine.ecs.system.ai.AStarPathfindingSystem;
import org.veiset.kgame.engine.ecs.system.ai.LinearMovementAISystem;
import org.veiset.kgame.engine.ecs.system.attack.AttackPlayerSystem;
import org.veiset.kgame.engine.ecs.system.attack.PlayerAttackSystem;
import org.veiset.kgame.engine.ecs.system.debug.CameraDebugSystem;
import org.veiset.kgame.engine.ecs.system.debug.ControllerSchemeSystem;
import org.veiset.kgame.engine.ecs.system.debug.DebugControlSystem;
import org.veiset.kgame.engine.ecs.system.debug.ProfilerSystem;
import org.veiset.kgame.engine.ecs.system.debug.ProfilerSystemKt;
import org.veiset.kgame.engine.ecs.system.enemy.BossHealthBarSystem;
import org.veiset.kgame.engine.ecs.system.enemy.EnemySpawnSystem;
import org.veiset.kgame.engine.ecs.system.enemy.PointToEnemySystem;
import org.veiset.kgame.engine.ecs.system.graphics.AnimationSystem;
import org.veiset.kgame.engine.ecs.system.graphics.BackgroundTilesSystem;
import org.veiset.kgame.engine.ecs.system.graphics.CameraSystem;
import org.veiset.kgame.engine.ecs.system.graphics.DrawSystem;
import org.veiset.kgame.engine.ecs.system.graphics.DynamicShadowSystem;
import org.veiset.kgame.engine.ecs.system.graphics.UpdateAnimationStateSystem;
import org.veiset.kgame.engine.ecs.system.graphics.effect.WeatherSystem;
import org.veiset.kgame.engine.ecs.system.loot.AutoPickupLootSystem;
import org.veiset.kgame.engine.ecs.system.loot.BlindSystem;
import org.veiset.kgame.engine.ecs.system.loot.ItemSpawnLocationSystem;
import org.veiset.kgame.engine.ecs.system.loot.PickupLootSystem;
import org.veiset.kgame.engine.ecs.system.physics.Box2dSystem;
import org.veiset.kgame.engine.ecs.system.physics.CollisionResolveSystem;
import org.veiset.kgame.engine.ecs.system.physics.SensorCollisionResolveSystem;
import org.veiset.kgame.engine.ecs.system.physics.VelocityPositionSystem;
import org.veiset.kgame.engine.ecs.system.player.InventorySystem;
import org.veiset.kgame.engine.ecs.system.player.PlayerInputSystem;
import org.veiset.kgame.engine.ecs.system.player.PlayerPositionBoundSystem;
import org.veiset.kgame.engine.ecs.system.scenario.ScenarioBossSystem;
import org.veiset.kgame.engine.item.Equipment;
import org.veiset.kgame.engine.item.EquipmentSlot;
import org.veiset.kgame.engine.item.Item;
import org.veiset.kgame.engine.item.Loot;
import org.veiset.kgame.engine.item.LootTable;
import org.veiset.kgame.engine.item.LootTablesKt;
import org.veiset.kgame.engine.item.SimpleLootSystem;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.modifier.ItemModifier;
import org.veiset.kgame.engine.modifier.ItemModifiers;
import org.veiset.kgame.engine.modifier.Modifier;
import org.veiset.kgame.engine.state.GameState;
import org.veiset.kgame.engine.storage.Tag;
import org.veiset.kgame.engine.tools.editor.area.AreaData;
import org.veiset.kgame.engine.tools.editor.area.AreaResource;
import org.veiset.kgame.engine.values.ProfilerName;
import org.veiset.kgame.engine.world.WorldMap;
import org.veiset.kgame.engine.world.WorldMapBounds;
import org.veiset.kgame.engine.world.WorldMapKt;
import org.veiset.kgame.module.LevelSelectModule;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0001H\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u0019R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/veiset/kgame/module/GameWorldModule;", "Lorg/veiset/kgame/engine/GameModule;", "engine", "Lcom/badlogic/ashley/core/Engine;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "gameState", "Lorg/veiset/kgame/engine/state/GameState;", "(Lcom/badlogic/ashley/core/Engine;Lcom/badlogic/gdx/physics/box2d/World;Lorg/veiset/kgame/engine/state/GameState;)V", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "addEntities", "", "addEventListeners", "generateMap", "worldMap", "Lorg/veiset/kgame/engine/world/WorldMap;", "nextState", "setup", "teardown", "update", "delta", "", "strToTag", "Lorg/veiset/kgame/engine/storage/Tag;", "", "kgame2"})
public final class GameWorldModule
implements GameModule {
    @NotNull
    private final Engine engine;
    @NotNull
    private final World world;
    @NotNull
    private final GameState gameState;

    public GameWorldModule(@NotNull Engine engine, @NotNull World world, @NotNull GameState gameState) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)gameState, (String)"gameState");
        this.engine = engine;
        this.world = world;
        this.gameState = gameState;
    }

    public /* synthetic */ GameWorldModule(Engine engine, World world, GameState gameState, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            engine = new Engine();
        }
        if ((n & 2) != 0) {
            World world2 = WorldsKt.createWorld$default(null, (boolean)false, (int)3, null);
            boolean bl = false;
            boolean bl2 = false;
            World it = world2;
            boolean bl3 = false;
            Log.INSTANCE.debug("GameWorldModule Loaded World");
            world = world2;
        }
        if ((n & 4) != 0) {
            gameState = new GameState(null, null, null, null, 15, null);
        }
        this(engine, world, gameState);
    }

    @Override
    @NotNull
    public Engine getEngine() {
        return this.engine;
    }

    @Override
    public void setup() {
        this.gameState.getSelectedLevel().getArea();
        TBEngineKt.getGlobals().getDrawGfx().getCamera().zoom = 1.0f;
        Log.INSTANCE.info(Intrinsics.stringPlus((String)"Engine entities at start: ", (Object)this.getEngine().getEntities().size()));
        WorldMap worldMap2 = (WorldMap)LoggerKt.logTimed$default("generating world", null, (Function0)new Function0<WorldMap>(this){
            final /* synthetic */ GameWorldModule this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final WorldMap invoke() {
                return new WorldMap(GameWorldModule.access$getGameState$p(this.this$0).getSelectedLevel().getArea(), 3.0f, 0L, 4, null);
            }
        }, 2, null);
        if (EngineConfig.Debug.INSTANCE.getZOOM_OUT_DEBUG()) {
            TBEngineKt.getGlobals().getDrawGfx().getCamera().zoom = EngineConfig.Debug.INSTANCE.getDEBUG_CAMERA_ZOOM();
        }
        EngineConfig.Game.INSTANCE.setPlayerStartPos(Vector2Kt.x(3.0f, 3.0f));
        GamePauseSystem gamePauseSystem = new GamePauseSystem();
        WorldMapBounds worldMapBounds = WorldMapKt.bounds(this.gameState.getSelectedLevel().getArea());
        Log.INSTANCE.info("Adding event listeners");
        this.addEventListeners();
        Log.INSTANCE.info("Done adding listeners");
        this.getEngine().addSystem((EntitySystem)gamePauseSystem);
        this.getEngine().addSystem((EntitySystem)new Box2dSystem(this.world));
        this.getEngine().addSystem((EntitySystem)new SensorCollisionResolveSystem());
        this.getEngine().addSystem((EntitySystem)new CollisionResolveSystem());
        this.getEngine().addSystem((EntitySystem)new FixedDurationSystem());
        this.getEngine().addSystem((EntitySystem)new BackgroundTilesSystem(worldMap2));
        this.getEngine().addSystem((EntitySystem)new DrawSystem(gamePauseSystem));
        this.getEngine().addSystem((EntitySystem)new VelocityPositionSystem());
        this.getEngine().addSystem((EntitySystem)new PlayerInputSystem(this.world));
        this.getEngine().addSystem((EntitySystem)new DeathSystem(this.world));
        this.getEngine().addSystem((EntitySystem)new CameraSystem(EngineConfig.Game.INSTANCE.getPlayerStartPos(), worldMapBounds));
        this.getEngine().addSystem((EntitySystem)new AnimationSystem());
        this.getEngine().addSystem((EntitySystem)new DynamicShadowSystem());
        this.getEngine().addSystem((EntitySystem)new UpdateAnimationStateSystem());
        this.getEngine().addSystem((EntitySystem)new EnemySpawnSystem(this.world, this.gameState.getSelectedLevel(), worldMapBounds));
        this.getEngine().addSystem((EntitySystem)new ScenarioBossSystem(worldMapBounds));
        this.getEngine().addSystem((EntitySystem)new LinearMovementAISystem());
        this.getEngine().addSystem((EntitySystem)new DelayAddEntitySystem());
        this.getEngine().addSystem((EntitySystem)new InventorySystem());
        this.getEngine().addSystem((EntitySystem)new AutoPickupLootSystem());
        this.getEngine().addSystem((EntitySystem)new PickupLootSystem());
        this.getEngine().addSystem((EntitySystem)new ItemSpawnLocationSystem());
        this.getEngine().addSystem((EntitySystem)new BlindSystem());
        this.getEngine().addSystem((EntitySystem)new AttackPlayerSystem(this.world));
        this.getEngine().addSystem((EntitySystem)new PlayerAttackSystem(this.world));
        this.getEngine().addSystem((EntitySystem)new ControllerSchemeSystem());
        this.getEngine().addSystem((EntitySystem)new PlayerPositionBoundSystem(worldMapBounds));
        this.getEngine().addSystem((EntitySystem)new WeatherSystem());
        this.getEngine().addSystem((EntitySystem)new PointToEnemySystem());
        this.getEngine().addSystem((EntitySystem)new CameraDebugSystem());
        this.getEngine().addSystem((EntitySystem)new BossHealthBarSystem());
        Log.INSTANCE.info(Intrinsics.stringPlus((String)"Engine entities after systems added: ", (Object)this.getEngine().getEntities().size()));
        this.getEngine().addEntity((Entity)new PlayerEntity(this.world, EngineConfig.Game.INSTANCE.getPlayerStartPos(), this.getEngine()));
        Log.INSTANCE.debug("GameWorldModule Systems loaded");
        LoggerKt.logTimed$default("Add areas to world", null, (Function0)new Function0<Unit>(this, worldMap2){
            final /* synthetic */ GameWorldModule this$0;
            final /* synthetic */ WorldMap $worldMap;
            {
                this.this$0 = $receiver;
                this.$worldMap = $worldMap;
                super(0);
            }

            public final void invoke() {
                this.this$0.generateMap(this.$worldMap);
            }
        }, 2, null);
        this.addEntities();
        Log.INSTANCE.debug("GameWorldModule Entities added");
        this.getEngine().addSystem((EntitySystem)new AStarPathfindingSystem(this.world, this.gameState.getSelectedLevel().getArea().getAreaSize(), null, null, 12, null));
        this.getEngine().addSystem((EntitySystem)new DebugControlSystem(this.world));
        this.getEngine().addSystem((EntitySystem)new ProfilerSystem());
    }

    private final void addEventListeners() {
        Class[] classArray = new Class[]{ModifiersComponent.class};
        this.getEngine().addEntityListener(Family.all((Class[])classArray).get(), (EntityListener)new ModifiersComponentEvent());
    }

    @Override
    public void teardown() {
        this.getEngine().removeAllEntities();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Tag strToTag(@NotNull String $this$strToTag) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$strToTag, (String)"<this>");
            $this$firstOrNull$iv = Tag.values();
            $i$f$firstOrNull = false;
            var4_4 = $this$firstOrNull$iv;
            var5_6 = var4_4.length;
            for (var6_8 = 0; var6_8 < var5_6; ++var6_8) {
                block5: {
                    it = element$iv = var4_4[var6_8];
                    $i$a$-firstOrNull-GameWorldModule$strToTag$1 = false;
                    if (Intrinsics.areEqual((Object)it.getTagName(), (Object)$this$strToTag)) ** GOTO lbl-1000
                    $this$any$iv = it.getKeywords();
                    $i$f$any = false;
                    var12_14 = $this$any$iv;
                    var13_15 = var12_14.length;
                    for (var14_16 = 0; var14_16 < var13_15; ++var14_16) {
                        kw = element$iv = var12_14[var14_16];
                        $i$a$-any-GameWorldModule$strToTag$1$1 = false;
                        if (!Intrinsics.areEqual((Object)kw, (Object)$this$strToTag)) continue;
                        v0 = true;
                        break block5;
                    }
                    v0 = false;
                }
                if (v0) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = element$iv;
                break block6;
            }
            v2 = null;
        }
        var2_2 = v2;
        var3_3 = false;
        var4_5 = false;
        it = var2_2;
        $i$a$-also-GameWorldModule$strToTag$2 = false;
        if (it == null) {
            Log.INSTANCE.error("No tag for '" + $this$strToTag + "' found");
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void generateMap(@NotNull WorldMap worldMap2) {
        Intrinsics.checkNotNullParameter((Object)worldMap2, (String)"worldMap");
        float scale = 0.53333336f;
        Iterable $this$sortedByDescending$iv = new AreaResource("area").all();
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        List areas2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                AreaData it = (AreaData)b;
                boolean bl2 = false;
                it = (AreaData)a;
                Comparable comparable = Float.valueOf(it.getSize().y * it.getSize().x);
                bl2 = false;
                Float f = Float.valueOf(it.getSize().y * it.getSize().x);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)f);
            }
        });
        Iterable $this$forEachIndexed$iv = areas2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        block0: for (Object item$iv : $this$forEachIndexed$iv) {
            int n = index$iv++;
            boolean bl2 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AreaData areaData = (AreaData)item$iv;
            int index = n;
            boolean bl3 = false;
            int n2 = 3 * (index / 2 + 1);
            boolean bl4 = false;
            int n3 = 0;
            int n4 = n2;
            for (n3 = 0; n3 < n4; ++n3) {
                void $this$mapNotNullTo$iv$iv;
                void area;
                int it = n3;
                boolean bl5 = false;
                Iterable $this$mapNotNull$iv = area.getTags();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Tag tag;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl6 = false;
                    String it2 = (String)element$iv$iv;
                    boolean bl7 = false;
                    if (this.strToTag(it2) == null) continue;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    Tag it$iv$iv = tag;
                    boolean bl10 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List tags = (List)destination$iv$iv;
                Pair<Integer, Integer> f = WorldMapKt.addAreaToGrid(worldMap2.getGrid(), (int)area.getGridsize().x, (int)area.getGridsize().y, tags);
                if (f == null) continue block0;
                area.generateAt(this.getEngine(), Vector2Kt.x((float)((Number)f.getFirst()).intValue() * scale, (float)((Number)f.getSecond()).intValue() * scale), this.world, TBEngineKt.getGlobals().getTextureStore().getTextures());
            }
        }
    }

    public final void addEntities() {
        Object loot;
        List<Loot<Item>> drops = new LootTableComponent(new LootTable(new SimpleLootSystem(1.0f, 1.0f, 3), LootTablesKt.getBigTable())).getLootTable().generateItems();
        Iterable $this$forEach$iv = drops;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            loot = (Loot)element$iv;
            boolean bl = false;
            this.getEngine().addEntity((Entity)new ItemDropEntity((Item)loot.getItem(), Vector2Kt.copy(EngineConfig.Game.INSTANCE.getPlayerStartPos())));
        }
        Object[] $i$f$forEach22 = new ItemModifier[]{new ItemModifier("", "", new Modifier.Attack.AdditionalProjectile(4), 1.0f, 5), new ItemModifier("", "", new Modifier.Attack.Duration(2.9f), 1.0f, 5), new ItemModifier("", "", new Modifier.Attack.AttackSpeed(1.5f), 1.0f, 5), new ItemModifier("", "", new Modifier.Damage.Flat(30.0f), 1.0f, 5), new ItemModifier("", "", new Modifier.Attack.Spread(3.0f), 1.0f, 5), new ItemModifier("", "", new Modifier.Attack.ParallelSpacing(0.02f), 1.0f, 5)};
        ItemModifiers weaponModifiers = new ItemModifiers(1.0f, 99, CollectionsKt.listOf((Object[])$i$f$forEach22));
        Object[] objectArray = new ItemModifier[]{new ItemModifier("", "", new Modifier.Attack.AdditionalProjectile(24), 1.0f, 5), new ItemModifier("", "", new Modifier.Attack.Duration(1.5f), 1.0f, 5), new ItemModifier("", "", new Modifier.Attack.AttackSpeed(3.0f), 1.0f, 5), new ItemModifier("", "", new Modifier.Damage.Flat(20.0f), 1.0f, 5), new ItemModifier("", "", new Modifier.Attack.Spread(7.0f), 1.0f, 5), new ItemModifier("", "", new Modifier.Attack.ParallelSpacing(0.02f), 1.0f, 5), new ItemModifier("", "", new Modifier.Speed.Flat(-0.5f), 1.0f, 1)};
        ItemModifiers weaponModifiers2 = new ItemModifiers(1.0f, 99, CollectionsKt.listOf((Object[])objectArray));
        ItemModifiers bootsModifiers = new ItemModifiers(1.0f, 99, CollectionsKt.listOf((Object)new ItemModifier("", "", new Modifier.Speed.Increase(2.0f), 1.0f, 5)));
        loot = EquipmentSlot.WEAPON;
        Object bl = TBEngineKt.getGlobals().getIcons().getWeapon5();
        Equipment debugWeapon = new Equipment((TextureRegion)bl, (EquipmentSlot)((Object)loot), weaponModifiers, "Debug Weapon");
        bl = EquipmentSlot.WEAPON;
        Object object = TBEngineKt.getGlobals().getIcons().getWeapon10();
        Equipment debugWeapon2 = new Equipment((TextureRegion)object, (EquipmentSlot)((Object)bl), weaponModifiers2, "Debug Weapon");
        object = EquipmentSlot.BOOTS;
        TextureRegion textureRegion = TBEngineKt.getGlobals().getIcons().getBootsOfSpeed();
        Equipment debugBoots = new Equipment(textureRegion, (EquipmentSlot)((Object)object), bootsModifiers, "Debug Boots");
        this.getEngine().addEntity((Entity)new ItemDropEntity(debugWeapon2, Vector2Kt.plus(Vector2Kt.copy(EngineConfig.Game.INSTANCE.getPlayerStartPos()), new Vector2(-2.0f, 0.0f))));
        this.getEngine().addEntity((Entity)new ItemDropEntity(debugWeapon, Vector2Kt.copy(EngineConfig.Game.INSTANCE.getPlayerStartPos())));
        this.getEngine().addEntity((Entity)new ItemDropEntity(debugBoots, Vector2Kt.plus(Vector2Kt.copy(EngineConfig.Game.INSTANCE.getPlayerStartPos()), new Vector2(0.0f, -2.0f))));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(float delta) {
        void blue$iv;
        void green$iv;
        void red$iv;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float alpha$iv = 1.0f;
        boolean clearDepth$iv = true;
        boolean $i$f$clearScreen = false;
        ScreenUtils.clear((float)red$iv, (float)green$iv, (float)blue$iv, (float)alpha$iv, (boolean)clearDepth$iv);
        ProfilerSystemKt.profile(this.getEngine(), ProfilerName.GLOBAL, (Function0)new Function0<Unit>(this, delta){
            final /* synthetic */ GameWorldModule this$0;
            final /* synthetic */ float $delta;
            {
                this.this$0 = $receiver;
                this.$delta = $delta;
                super(0);
            }

            public final void invoke() {
                this.this$0.getEngine().update(this.$delta);
            }
        });
    }

    @Override
    @NotNull
    public GameModule nextState() {
        if (Gdx.input.isKeyJustPressed(48)) {
            this.gameState.getSelectedLevel().setFinished(true);
            return new LevelSelectModule(new Engine(), this.gameState);
        }
        if (Gdx.input.isKeyJustPressed(46)) {
            return new GameWorldModule(new Engine(), null, this.gameState, 2, null);
        }
        return this;
    }

    public GameWorldModule() {
        this(null, null, null, 7, null);
    }

    public static final /* synthetic */ GameState access$getGameState$p(GameWorldModule $this) {
        return $this.gameState;
    }
}

