/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.module;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.ScreenUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.GameModule;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.draw.SpriteGfxComponent;
import org.veiset.kgame.engine.ecs.system.graphics.DrawSystem;
import org.veiset.kgame.engine.math.Bezier;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.module.GameWorldModule;
import org.veiset.kgame.module.LevelSelectModuleKt;
import org.veiset.kgame.module.SplashScreenModuleKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0001H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/veiset/kgame/module/SplashScreenModule;", "Lorg/veiset/kgame/engine/GameModule;", "engine", "Lcom/badlogic/ashley/core/Engine;", "(Lcom/badlogic/ashley/core/Engine;)V", "bezier", "Lorg/veiset/kgame/engine/math/Bezier;", "getBezier", "()Lorg/veiset/kgame/engine/math/Bezier;", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "time", "", "getTime", "()F", "setTime", "(F)V", "nextState", "setup", "", "teardown", "update", "delta", "kgame2"})
public final class SplashScreenModule
implements GameModule {
    @NotNull
    private final Engine engine;
    @NotNull
    private final Bezier bezier;
    private float time;

    public SplashScreenModule(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        this.engine = engine;
        this.bezier = new Bezier(Vector2Kt.x(0.0f, 0.0f), Vector2Kt.x(0.0f, 1.0f), Vector2Kt.x(1.2f, 0.7f), Vector2Kt.x(2.0f, 2.0f));
    }

    @Override
    @NotNull
    public Engine getEngine() {
        return this.engine;
    }

    @NotNull
    public final Bezier getBezier() {
        return this.bezier;
    }

    @Override
    public void setup() {
        SplashScreenModuleKt.access$getCamera$p().position.x = 0.0f;
        SplashScreenModuleKt.access$getCamera$p().position.y = 0.0f;
        this.getEngine().addSystem((EntitySystem)new DrawSystem(null, 1, null));
        this.getEngine().addEntity(new Entity().add((Component)new SpriteGfxComponent(TBEngineKt.getGlobals().getTextureStore().getAttackBall(), Vector2Kt.x(0.2f, 0.2f), 0, 0.0f, 0.0f, 28, null)).add((Component)new PositionComponent(Vector2Kt.x(1.0f, 1.0f))));
    }

    @Override
    public void teardown() {
    }

    public final float getTime() {
        return this.time;
    }

    public final void setTime(float f) {
        this.time = f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(float delta) {
        void $this$mapIndexedTo$iv$iv;
        Unit unit;
        Collection<Unit> collection;
        void blue$iv;
        void green$iv22;
        float red$iv;
        SplashScreenModule splashScreenModule = this;
        splashScreenModule.time += delta;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float alpha$iv = 0.0f;
        boolean clearDepth$iv = true;
        boolean $i$f$clearScreen = false;
        ScreenUtils.clear((float)red$iv, (float)green$iv22, (float)blue$iv, (float)alpha$iv, (boolean)clearDepth$iv);
        LevelSelectModuleKt.getSpriteBatch().begin();
        SplashScreenModuleKt.access$getCamera$p().update();
        LevelSelectModuleKt.getShapeRenderer().setProjectionMatrix(SplashScreenModuleKt.access$getCamera$p().combined);
        LevelSelectModuleKt.getSpriteBatch().setProjectionMatrix(SplashScreenModuleKt.access$getCamera$p().combined);
        red$iv = this.time * 1.0f;
        boolean green$iv22 = false;
        TBEngineKt.getGlobals().getDrawGfx().getCamera().position.x = (float)Math.sin(red$iv) * 50.0f;
        TBEngineKt.getGlobals().getFonts().getJbt110().draw((Batch)LevelSelectModuleKt.getSpriteBatch(), (CharSequence)"Bleak Aether", -600.0f, 100.0f);
        TBEngineKt.getGlobals().getFonts().getJbt12().draw((Batch)LevelSelectModuleKt.getSpriteBatch(), (CharSequence)"v0.0.1", 100.0f, 10.0f);
        LevelSelectModuleKt.getSpriteBatch().end();
        this.getEngine().update(delta);
        Vector2 pos = this.bezier.point(this.time - 1.0f);
        List debug = Bezier.debugline$default(this.bezier, 0, 1, null);
        LevelSelectModuleKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Line);
        LevelSelectModuleKt.getShapeRenderer().setColor(Color.WHITE);
        Iterable $this$zipWithNext$iv = debug;
        boolean $i$f$zipWithNext = false;
        Object iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            CollectionsKt.emptyList();
        } else {
            $i$f$clearScreen = false;
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p1;
                void p0;
                Object next$iv = iterator$iv.next();
                Vector2 vector2 = (Vector2)next$iv;
                Vector2 vector22 = (Vector2)current$iv;
                collection = result$iv;
                boolean bl = false;
                LevelSelectModuleKt.getShapeRenderer().line(Vector2Kt.dw((Vector2)p0), Vector2Kt.dw((Vector2)p1));
                unit = Unit.INSTANCE;
                collection.add(unit);
                current$iv = next$iv;
            }
        }
        Iterable $this$mapIndexed$iv = this.bezier.debugPoints();
        boolean $i$f$mapIndexed = false;
        iterator$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void p;
            Color color;
            void i;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Vector2 vector2 = (Vector2)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            void var17_33 = i;
            switch (var17_33) {
                case 0: {
                    color = Color.RED;
                    break;
                }
                case 1: {
                    color = Color.BLUE;
                    break;
                }
                case 2: {
                    color = Color.GREEN;
                    break;
                }
                case 3: {
                    color = Color.YELLOW;
                    break;
                }
                default: {
                    color = Color.WHITE;
                }
            }
            Color color2 = color;
            LevelSelectModuleKt.getShapeRenderer().setColor(color2);
            Vector2 vector23 = Vector2Kt.dw((Vector2)p);
            float x = Vector2Kt.component1(vector23);
            float y = Vector2Kt.component2(vector23);
            LevelSelectModuleKt.getShapeRenderer().circle(x, y, 5.0f);
            unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Vector2 vector2 = Vector2Kt.dw(pos);
        float px = Vector2Kt.component1(vector2);
        float py = Vector2Kt.component2(vector2);
        LevelSelectModuleKt.getShapeRenderer().setColor(Color.ORANGE);
        LevelSelectModuleKt.getShapeRenderer().end();
        LevelSelectModuleKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Filled);
        LevelSelectModuleKt.getShapeRenderer().circle(px, py, 5.0f);
        LevelSelectModuleKt.getShapeRenderer().end();
    }

    @Override
    @NotNull
    public GameModule nextState() {
        if (Gdx.input.isKeyJustPressed(46)) {
            return new SplashScreenModule(new Engine());
        }
        if (Gdx.input.isKeyJustPressed(-1) || Gdx.input.isButtonJustPressed(0)) {
            return new GameWorldModule(null, null, null, 7, null);
        }
        return this;
    }
}

