#ifdef GL_ES
precision mediump float;
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;
uniform vec2 u_resolution;
uniform float u_blindness;
uniform float u_amount;

void main() {
  vec2 st = gl_FragCoord.xy/u_resolution;
  float pct = distance(vec2(0.5), st) + u_blindness - 0.1;
  gl_FragColor = vec4(0.0, 0.0, 0.0, (pct * u_blindness));
}