/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.CLICol;
import org.veiset.kgame.engine.CLIStyle;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.LogLevel;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a;\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u000f\u00a2\u0006\u0002\u0010\u0010\u001a\u0012\u0010\u0011\u001a\u00020\f*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f\u001a\u0012\u0010\u0014\u001a\u00020\f*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f\u001a\u0012\u0010\u0015\u001a\u00020\f*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"formatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "log", "", "msg", "", "level", "Lorg/veiset/kgame/engine/LogLevel;", "logTimed", "T", "key", "", "splitKey", "f", "Lkotlin/Function0;", "(Ljava/lang/String;Lorg/veiset/kgame/engine/LogLevel;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "c", "Lorg/veiset/kgame/engine/CLICol;", "s", "cb", "cu", "kgame2"})
public final class LoggerKt {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSSS");

    public static final void log(@NotNull Object msg, @NotNull LogLevel level) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        if (EngineConfig.Debug.INSTANCE.getLOG_LEVEL().getLevel() > level.getLevel() || !EngineConfig.Debug.INSTANCE.getPRINT()) {
            return;
        }
        String timestamp = LocalDateTime.now().format(formatter);
        LogLevel logLevel = level;
        int n = WhenMappings.$EnumSwitchMapping$0[logLevel.ordinal()];
        switch (n) {
            case 1: {
                String string = Intrinsics.stringPlus((String)LoggerKt.c(CLICol.GREEN, '[' + timestamp + "] "), (Object)msg);
                boolean bl = false;
                System.out.println((Object)string);
                break;
            }
            case 2: {
                String string = Intrinsics.stringPlus((String)LoggerKt.c(CLICol.GREEN, '[' + timestamp + "] "), (Object)msg);
                boolean bl = false;
                System.out.println((Object)string);
                break;
            }
            case 3: {
                String string = Intrinsics.stringPlus((String)LoggerKt.c(CLICol.YELLOW, '[' + timestamp + "] "), (Object)msg);
                boolean bl = false;
                System.out.println((Object)string);
                break;
            }
            case 4: {
                String string = Intrinsics.stringPlus((String)LoggerKt.c(CLICol.RED, '[' + timestamp + "] "), (Object)msg);
                boolean bl = false;
                System.out.println((Object)string);
            }
        }
    }

    public static /* synthetic */ void log$default(Object object, LogLevel logLevel, int n, Object object2) {
        if ((n & 2) != 0) {
            logLevel = LogLevel.DEBUG;
        }
        LoggerKt.log(object, logLevel);
    }

    @NotNull
    public static final String c(@NotNull CLICol $this$c, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$c), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return $this$c.getColorCode() + s + CLIStyle.RESET.getCode();
    }

    @NotNull
    public static final String cb(@NotNull CLICol $this$cb, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$cb), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return Intrinsics.stringPlus((String)CLIStyle.BOLD.getCode(), (Object)LoggerKt.c($this$cb, s));
    }

    @NotNull
    public static final String cu(@NotNull CLICol $this$cu, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$cu), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return Intrinsics.stringPlus((String)CLIStyle.UNDERLINE.getCode(), (Object)LoggerKt.c($this$cu, s));
    }

    public static final <T> T logTimed(@NotNull String key, @NotNull LogLevel level, @NotNull String splitKey, @NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)splitKey, (String)"splitKey");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (EngineConfig.Debug.INSTANCE.getLOG_LEVEL().getLevel() > level.getLevel()) {
            f.invoke();
        }
        boolean $i$f$measureTimedValue = false;
        boolean bl = false;
        TimeSource $this$measureTimedValue$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        boolean bl2 = false;
        TimeMark mark$iv$iv = $this$measureTimedValue$iv$iv.markNow();
        Object result$iv$iv = f.invoke();
        TimedValue timed = new TimedValue(result$iv$iv, mark$iv$iv.elapsedNow-UwyO8pc(), null);
        float ms = (float)Duration.getInWholeNanoseconds-impl((long)timed.getDuration-UwyO8pc()) / 1000000.0f;
        CLICol color = ms <= 16.0f ? CLICol.BLUE : (ms < 500.0f ? CLICol.YELLOW : CLICol.RED);
        String string = "%.4f";
        Object[] objectArray = new Object[]{Float.valueOf(ms)};
        boolean bl3 = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        String formattedNumber = StringsKt.padStart$default((String)string2, (int)8, (char)'\u0000', (int)2, null);
        LoggerKt.log(LoggerKt.cb(color, "\u23f2") + ' ' + formattedNumber + "ms " + splitKey + ' ' + key, level);
        return (T)timed.getValue();
    }

    public static /* synthetic */ Object logTimed$default(String string, LogLevel logLevel, String string2, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            logLevel = LogLevel.DEBUG;
        }
        if ((n & 4) != 0) {
            string2 = "-";
        }
        return LoggerKt.logTimed(string, logLevel, string2, function0);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            nArray[LogLevel.DEBUG.ordinal()] = 1;
            nArray[LogLevel.INFO.ordinal()] = 2;
            nArray[LogLevel.WARN.ordinal()] = 3;
            nArray[LogLevel.ERROR.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

