/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine;

import com.badlogic.ashley.core.Engine;
import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.ScreenUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.GlobalVars;
import org.veiset.kgame.engine.Drawing;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.GameModule;
import org.veiset.kgame.engine.Globals;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.StartupConfig;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.component.levelselect.GameLevelComponent;
import org.veiset.kgame.engine.math.MathUtilsKt;
import org.veiset.kgame.engine.sound.Music;
import org.veiset.kgame.engine.sound.SoundPlayer;
import org.veiset.kgame.engine.state.GameState;
import org.veiset.kgame.engine.state.LevelMonsters;
import org.veiset.kgame.engine.storage.AnimationStore;
import org.veiset.kgame.engine.storage.FontStore;
import org.veiset.kgame.engine.storage.IconStore;
import org.veiset.kgame.engine.storage.TextureStore;
import org.veiset.kgame.engine.tools.editor.area.AreaEditor;
import org.veiset.kgame.engine.tools.editor.tileset.WorldgenModule;
import org.veiset.kgame.engine.world.FireBossTiles;
import org.veiset.kgame.module.GameWorldModule;
import org.veiset.kgame.module.LevelSelectModule;
import org.veiset.kgame.module.SplashScreenModule;
import org.veiset.kgame.module.presentation.FagdagPresentationModule;
import org.veiset.kgame.module.presentation.PilsOgProgPresentationModule;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010*\u001a\u00020+H\u0016J#\u0010,\u001a\u00020+2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u00020+H\u0016J\u0018\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000bH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0011X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0018\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\r\"\u0004\b\u001a\u0010\u000fR\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010#\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\r\"\u0004\b%\u0010\u000fR\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u00062"}, d2={"Lorg/veiset/kgame/engine/TBEngine;", "Lcom/badlogic/gdx/ApplicationAdapter;", "args", "", "", "startupConfig", "Lorg/veiset/kgame/engine/StartupConfig;", "(Ljava/util/List;Lorg/veiset/kgame/engine/StartupConfig;)V", "getArgs", "()Ljava/util/List;", "fps", "", "getFps", "()I", "setFps", "(I)V", "fpsCounter", "", "getFpsCounter", "()F", "setFpsCounter", "(F)V", "fpsSampleSize", "getFpsSampleSize", "frame", "getFrame", "setFrame", "frameTimes", "", "", "getFrameTimes", "()[Ljava/lang/Long;", "setFrameTimes", "([Ljava/lang/Long;)V", "[Ljava/lang/Long;", "frames", "getFrames", "setFrames", "gameModule", "Lorg/veiset/kgame/engine/GameModule;", "getStartupConfig", "()Lorg/veiset/kgame/engine/StartupConfig;", "create", "", "drawFrames", "([Ljava/lang/Long;I)V", "render", "resize", "width", "height", "kgame2"})
public final class TBEngine
extends ApplicationAdapter {
    @NotNull
    private final List<String> args;
    @NotNull
    private final StartupConfig startupConfig;
    @NotNull
    private Long[] frameTimes;
    private int frame;
    private float fpsCounter;
    private int frames;
    private int fps;
    private final float fpsSampleSize;
    private GameModule gameModule;

    public TBEngine(@NotNull List<String> args, @NotNull StartupConfig startupConfig) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)startupConfig, (String)"startupConfig");
        this.args = args;
        this.startupConfig = startupConfig;
        int n = 0;
        Long[] longArray = new Long[10];
        TBEngine tBEngine = this;
        while (n < 10) {
            int n2 = n++;
            longArray[n2] = 0L;
        }
        tBEngine.frameTimes = longArray;
        this.fpsSampleSize = 0.1f;
    }

    public /* synthetic */ TBEngine(List list, StartupConfig startupConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            startupConfig = new StartupConfig(false, null, null, 0L, 15, null);
        }
        this(list, startupConfig);
    }

    @NotNull
    public final List<String> getArgs() {
        return this.args;
    }

    @NotNull
    public final StartupConfig getStartupConfig() {
        return this.startupConfig;
    }

    @NotNull
    public final Long[] getFrameTimes() {
        return this.frameTimes;
    }

    public final void setFrameTimes(@NotNull Long[] longArray) {
        Intrinsics.checkNotNullParameter((Object)longArray, (String)"<set-?>");
        this.frameTimes = longArray;
    }

    public final int getFrame() {
        return this.frame;
    }

    public final void setFrame(int n) {
        this.frame = n;
    }

    public final float getFpsCounter() {
        return this.fpsCounter;
    }

    public final void setFpsCounter(float f) {
        this.fpsCounter = f;
    }

    public final int getFrames() {
        return this.frames;
    }

    public final void setFrames(int n) {
        this.frames = n;
    }

    public final int getFps() {
        return this.fps;
    }

    public final void setFps(int n) {
        this.fps = n;
    }

    public final float getFpsSampleSize() {
        return this.fpsSampleSize;
    }

    /*
     * Unable to fully structure code
     */
    public void create() {
        this.startupConfig.getPreSetup().invoke();
        Log.INSTANCE.debug(Intrinsics.stringPlus((String)"Arguments: ", this.args));
        Log.INSTANCE.debug("Booting ...");
        Log.INSTANCE.debug(" - LibGdx: " + (System.currentTimeMillis() - this.startupConfig.getStartupTime()) + " ms");
        startTimeModule = System.currentTimeMillis();
        textureStore = new TextureStore();
        TBEngineKt.setGlobals(new Globals(new Drawing(), new Drawing(), textureStore, new AnimationStore(textureStore), new FontStore(), new IconStore(), new SoundPlayer(this.startupConfig.getPreloadSounds())));
        engine = new Engine();
        Log.INSTANCE.debug(" - Bootstrap (LibGdx, Resources, Engine): " + (System.currentTimeMillis() - startTimeModule) + " ms");
        Log.INSTANCE.debug(" + Total boot time: " + (System.currentTimeMillis() - GlobalVars.INSTANCE.getStartTime()) + " ms");
        startTimeModule = System.currentTimeMillis();
        Log.INSTANCE.debug("Loading start module ...");
        var5_4 = (String)CollectionsKt.firstOrNull(this.args);
        if (var5_4 == null) {
            v0 = null;
        } else {
            var6_5 = var5_4;
            var7_6 = false;
            v1 = var6_5.toLowerCase(Locale.ROOT);
            v0 = v1;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        }
        if (Intrinsics.areEqual(v0, (Object)"production")) {
            EngineConfig.Engine.INSTANCE.setPRODUCTION_MODE(true);
        }
        v2 = this;
        var6_5 = (String)CollectionsKt.firstOrNull(this.args);
        if (var6_5 == null) {
            v3 = null;
        } else {
            var7_7 = var6_5;
            var8_8 = false;
            v4 = var7_7.toLowerCase(Locale.ROOT);
            v3 = v4;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        }
        var5_4 = v3;
        if (var5_4 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var5_4.hashCode()) {
            case 3029869: {
                if (var5_4.equals("boss")) {
                    tmp = 1;
                }
                break;
            }
            case 36237950: {
                if (var5_4.equals("worldgen")) {
                    tmp = 2;
                }
                break;
            }
            case -1611195008: {
                if (var5_4.equals("levelselect")) {
                    tmp = 3;
                }
                break;
            }
            case -189078958: {
                if (var5_4.equals("presentation.fagdag")) {
                    tmp = 4;
                }
                break;
            }
            case -1038695314: {
                if (var5_4.equals("editor.area")) {
                    tmp = 5;
                }
                break;
            }
            case -1885916804: {
                if (var5_4.equals("presentation.pogp")) {
                    tmp = 6;
                }
                break;
            }
            case 1023178464: {
                if (var5_4.equals("gameworld")) {
                    tmp = 7;
                }
                break;
            }
        }
        switch (tmp) {
            case 6: {
                var6_5 = new PilsOgProgPresentationModule(engine);
                var7_6 = false;
                var8_8 = false;
                var9_9 = var6_5;
                var11_17 = v2;
                $i$a$-also-TBEngine$create$1 = false;
                it.setup();
                var12_33 = Unit.INSTANCE;
                v5 = var11_17;
                v6 = (GameModule)var6_5;
                break;
            }
            case 4: {
                var6_5 = new FagdagPresentationModule(engine);
                var7_6 = false;
                var8_8 = false;
                it = var6_5;
                var11_18 = v2;
                $i$a$-also-TBEngine$create$2 = false;
                it.setup();
                var12_34 = Unit.INSTANCE;
                v5 = var11_18;
                v6 = (GameModule)var6_5;
                break;
            }
            case 5: {
                var6_5 = new AreaEditor(engine, null, null, 6, null);
                var7_6 = false;
                var8_8 = false;
                it = var6_5;
                var11_19 = v2;
                $i$a$-also-TBEngine$create$3 = false;
                it.setup();
                var12_35 = Unit.INSTANCE;
                v5 = var11_19;
                v6 = (GameModule)var6_5;
                break;
            }
            case 2: {
                var6_5 = new WorldgenModule(engine, null, 0.0f, 6, null);
                var7_6 = false;
                var8_8 = false;
                it = var6_5;
                var11_20 = v2;
                $i$a$-also-TBEngine$create$4 = false;
                it.setup();
                var12_36 = Unit.INSTANCE;
                v5 = var11_20;
                v6 = (GameModule)var6_5;
                break;
            }
            case 3: {
                var6_5 = new LevelSelectModule(engine, new GameState(null, null, null, null, 15, null));
                var7_6 = false;
                var8_8 = false;
                it = var6_5;
                var11_21 = v2;
                $i$a$-also-TBEngine$create$5 = false;
                it.setup();
                var12_37 = Unit.INSTANCE;
                v5 = var11_21;
                v6 = (GameModule)var6_5;
                break;
            }
            case 1: {
                var6_5 = new GameState(null, null, null, null, 15, null);
                var7_6 = false;
                var8_8 = false;
                it = var6_5;
                var15_41 = null;
                var14_42 = engine;
                var11_22 = v2;
                $i$a$-let-TBEngine$create$6 = false;
                var16_43 = GameState.copy$default((GameState)it, null, null, null, GameLevelComponent.copy$default(it.getSelectedLevel(), null, null, new FireBossTiles(null, null, 3, null), false, new LevelMonsters(0, 0, 1), 0, 0L, 107, null), 7, null);
                var17_44 = null;
                var18_45 = 2;
                var19_46 = var16_43;
                var20_47 = var15_41;
                var21_48 = var14_42;
                var6_5 = new GameWorldModule(var21_48, var20_47, var19_46, var18_45, var17_44);
                var7_6 = false;
                var8_8 = false;
                it = var6_5;
                $i$a$-also-TBEngine$create$7 = false;
                it.setup();
                var12_38 = Unit.INSTANCE;
                v5 = var11_22;
                v6 = (GameModule)var6_5;
                break;
            }
            case 7: {
                var6_5 = new GameWorldModule(engine, null, new GameState(null, null, null, null, 15, null), 2, null);
                var7_6 = false;
                var8_8 = false;
                it = var6_5;
                var11_23 = v2;
                $i$a$-also-TBEngine$create$8 = false;
                it.setup();
                var12_39 = Unit.INSTANCE;
                v5 = var11_23;
                v6 = (GameModule)var6_5;
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                var6_5 = new SplashScreenModule(engine);
                var7_6 = false;
                var8_8 = false;
                it = var6_5;
                var11_24 = v2;
                $i$a$-also-TBEngine$create$9 = false;
                it.setup();
                var12_40 = Unit.INSTANCE;
                v5 = var11_24;
                v6 = (GameModule)var6_5;
            }
        }
        v5.gameModule = v6;
        Log.INSTANCE.debug(" + Start module loaded: " + (System.currentTimeMillis() - startTimeModule) + " ms");
        TBEngineKt.getGlobals().getSoundPlayer().playTrack(Music.INSTANCE.getActionTheme());
        this.startupConfig.getPostSetup().invoke();
    }

    public void resize(int width, int height) {
        EngineConfig.Window.INSTANCE.setScreenWidth(width);
        EngineConfig.Window.INSTANCE.setScreenHeight(height);
        TBEngineKt.getGlobals().getDrawGfx().getViewport().update(width, height);
        TBEngineKt.getGlobals().getDrawUi().getViewport().update(width, height);
        EngineConfig.Window.INSTANCE.setGutterHeight(TBEngineKt.getGlobals().getDrawGfx().getViewport().getTopGutterHeight() + TBEngineKt.getGlobals().getDrawGfx().getViewport().getBottomGutterHeight());
        EngineConfig.Window.INSTANCE.setGutterWidth(TBEngineKt.getGlobals().getDrawGfx().getViewport().getLeftGutterWidth() + TBEngineKt.getGlobals().getDrawGfx().getViewport().getRightGutterWidth());
    }

    /*
     * WARNING - void declaration
     */
    public void render() {
        void blue$iv;
        void green$iv;
        void red$iv22;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float alpha$iv = 1.0f;
        boolean clearDepth$iv = true;
        boolean $i$f$clearScreen = false;
        ScreenUtils.clear((float)red$iv22, (float)green$iv, (float)blue$iv, (float)alpha$iv, (boolean)clearDepth$iv);
        TBEngine red$iv22 = this;
        red$iv22.fpsCounter += Gdx.graphics.getDeltaTime();
        red$iv22 = this;
        ++red$iv22.frames;
        if (this.fpsCounter >= this.fpsSampleSize) {
            this.fps = (int)((float)this.frames / this.fpsSampleSize);
            this.frames = 0;
            red$iv22 = this;
            red$iv22.fpsCounter -= this.fpsSampleSize;
        }
        boolean $i$f$measureNanoTime = false;
        boolean bl = false;
        long start$iv = System.nanoTime();
        boolean bl2 = false;
        GameModule gameModule = this.gameModule;
        if (gameModule == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gameModule");
            throw null;
        }
        GameModule state = gameModule;
        GameModule gameModule2 = this.gameModule;
        if (gameModule2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gameModule");
            throw null;
        }
        GameModule nextState2 = gameModule2.nextState();
        if (!Intrinsics.areEqual((Object)state, (Object)nextState2)) {
            Log.INSTANCE.debug("Next module: " + state + " -> " + nextState2);
            state.teardown();
            nextState2.setup();
            this.gameModule = nextState2;
        }
        if ((gameModule2 = this.gameModule) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gameModule");
            throw null;
        }
        gameModule2.update(Gdx.graphics.getDeltaTime());
        if (EngineConfig.Debug.INSTANCE.getPROFILER()) {
            this.drawFrames(this.getFrameTimes(), this.getFps());
        }
        long time = System.nanoTime() - start$iv;
        TBEngine tBEngine = this;
        ++tBEngine.frame;
        tBEngine = this;
        tBEngine.frame %= 10;
        this.frameTimes[this.frame] = time;
    }

    private final void drawFrames(Long[] frameTimes, int fps) {
        BitmapFont font18 = TBEngineKt.getGlobals().getFonts().getFont18();
        SpriteBatch uiSpriteBatch = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        double avgFrame = ArraysKt.averageOfLong((Long[])frameTimes);
        font18.setColor(Color.WHITE);
        uiSpriteBatch.begin();
        float frameTime = (float)avgFrame / (float)1000000;
        String string = "%.3f";
        Object[] objectArray = new Object[]{Float.valueOf(MathUtilsKt.round(frameTime, 3))};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        String dt = string2;
        TBEngineKt.getGlobals().getFonts().getJbr16().draw((Batch)uiSpriteBatch, (CharSequence)(dt + " dt - " + fps + " fps"), 3.6f, 1076.4f);
        uiSpriteBatch.end();
    }
}

