/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.behaviour;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.storage.TextureUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J7\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0006H\u00c6\u0001J\u0006\u0010\u001a\u001a\u00020\bJ\u0013\u0010\u001b\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u001d\u001a\u00020\u0004J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u0006\u0010 \u001a\u00020\u0000J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"J\t\u0010#\u001a\u00020$H\u00d6\u0001J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006)"}, d2={"Lorg/veiset/kgame/engine/behaviour/Animation;", "", "frames", "", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "baseDuration", "", "looping", "", "currentTime", "(Ljava/util/List;FZF)V", "getBaseDuration", "()F", "setBaseDuration", "(F)V", "getCurrentTime", "setCurrentTime", "getFrames", "()Ljava/util/List;", "getLooping", "()Z", "component1", "component2", "component3", "component4", "copy", "done", "equals", "other", "frame", "hashCode", "", "reset", "toGdxAnimation", "Lcom/badlogic/gdx/graphics/g2d/Animation;", "toString", "", "update", "", "delta", "speed", "kgame2"})
public final class Animation {
    @NotNull
    private final List<TextureRegion> frames;
    private float baseDuration;
    private final boolean looping;
    private float currentTime;

    public Animation(@NotNull List<? extends TextureRegion> frames, float baseDuration, boolean looping, float currentTime) {
        Intrinsics.checkNotNullParameter(frames, (String)"frames");
        this.frames = frames;
        this.baseDuration = baseDuration;
        this.looping = looping;
        this.currentTime = currentTime;
    }

    public /* synthetic */ Animation(List list, float f, boolean bl, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            f2 = 0.0f;
        }
        this(list, f, bl, f2);
    }

    @NotNull
    public final List<TextureRegion> getFrames() {
        return this.frames;
    }

    public final float getBaseDuration() {
        return this.baseDuration;
    }

    public final void setBaseDuration(float f) {
        this.baseDuration = f;
    }

    public final boolean getLooping() {
        return this.looping;
    }

    public final float getCurrentTime() {
        return this.currentTime;
    }

    public final void setCurrentTime(float f) {
        this.currentTime = f;
    }

    @NotNull
    public final TextureRegion frame() {
        int currentFrame = (int)(this.currentTime / this.baseDuration * (float)this.frames.size());
        int n = this.frames.size() - 1;
        boolean bl = false;
        return this.frames.get(Math.min(currentFrame, n));
    }

    public final void update(float delta, float speed) {
        Animation animation = this;
        animation.currentTime += delta * speed;
        if (this.looping) {
            animation = this;
            animation.currentTime %= this.baseDuration;
        }
    }

    public final boolean done() {
        return this.currentTime > this.baseDuration;
    }

    @NotNull
    public final Animation reset() {
        this.currentTime = 0.0f;
        return this;
    }

    @NotNull
    public final com.badlogic.gdx.graphics.g2d.Animation<TextureRegion> toGdxAnimation() {
        return new com.badlogic.gdx.graphics.g2d.Animation(this.baseDuration / (float)this.frames.size(), TextureUtilsKt.toGdxArray(this.frames));
    }

    @NotNull
    public final List<TextureRegion> component1() {
        return this.frames;
    }

    public final float component2() {
        return this.baseDuration;
    }

    public final boolean component3() {
        return this.looping;
    }

    public final float component4() {
        return this.currentTime;
    }

    @NotNull
    public final Animation copy(@NotNull List<? extends TextureRegion> frames, float baseDuration, boolean looping, float currentTime) {
        Intrinsics.checkNotNullParameter(frames, (String)"frames");
        return new Animation(frames, baseDuration, looping, currentTime);
    }

    public static /* synthetic */ Animation copy$default(Animation animation, List list, float f, boolean bl, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            list = animation.frames;
        }
        if ((n & 2) != 0) {
            f = animation.baseDuration;
        }
        if ((n & 4) != 0) {
            bl = animation.looping;
        }
        if ((n & 8) != 0) {
            f2 = animation.currentTime;
        }
        return animation.copy(list, f, bl, f2);
    }

    @NotNull
    public String toString() {
        return "Animation(frames=" + this.frames + ", baseDuration=" + this.baseDuration + ", looping=" + this.looping + ", currentTime=" + this.currentTime + ')';
    }

    public int hashCode() {
        int result = ((Object)this.frames).hashCode();
        result = result * 31 + Float.hashCode(this.baseDuration);
        int n = this.looping ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + Float.hashCode(this.currentTime);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Animation)) {
            return false;
        }
        Animation animation = (Animation)other;
        if (!Intrinsics.areEqual(this.frames, animation.frames)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.baseDuration), (Object)Float.valueOf(animation.baseDuration))) {
            return false;
        }
        if (this.looping != animation.looping) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.currentTime), (Object)Float.valueOf(animation.currentTime));
    }
}

