/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.behaviour;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.behaviour.ActionType;
import org.veiset.kgame.engine.behaviour.AnimationSpeedModifier;
import org.veiset.kgame.engine.behaviour.BehaviourStateChange;
import org.veiset.kgame.engine.behaviour.DynamicAnimation;
import org.veiset.kgame.engine.behaviour.DynamicAnimationKt;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponentKt;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.component.player.InventoryComponent;
import org.veiset.kgame.engine.ecs.entity.PlayerEntity;
import org.veiset.kgame.engine.ecs.entity.attack.PlayerAttackEntity;
import org.veiset.kgame.engine.ecs.entity.effect.PermaEffectAnimationEntity;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.physics.CollisionGroup;
import org.veiset.kgame.engine.input.InputKey;
import org.veiset.kgame.engine.input.InputKeyKt;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020.2\u0006\u00102\u001a\u000200H\u0016J \u00103\u001a\u00020.2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\bH\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010#\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0019\u0010(\u001a\n **\u0004\u0018\u00010)0)\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u00068"}, d2={"Lorg/veiset/kgame/engine/behaviour/PlayerBehaviour;", "Lorg/veiset/kgame/engine/behaviour/BehaviourStateChange;", "engine", "Lcom/badlogic/ashley/core/Engine;", "player", "Lorg/veiset/kgame/engine/ecs/entity/PlayerEntity;", "(Lcom/badlogic/ashley/core/Engine;Lorg/veiset/kgame/engine/ecs/entity/PlayerEntity;)V", "_speed", "Lorg/veiset/kgame/engine/behaviour/AnimationSpeedModifier;", "get_speed", "()Lorg/veiset/kgame/engine/behaviour/AnimationSpeedModifier;", "set_speed", "(Lorg/veiset/kgame/engine/behaviour/AnimationSpeedModifier;)V", "currentDodgeCooldown", "", "getCurrentDodgeCooldown", "()F", "setCurrentDodgeCooldown", "(F)V", "dodgeCooldown", "getDodgeCooldown", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "getPlayer", "()Lorg/veiset/kgame/engine/ecs/entity/PlayerEntity;", "runningSound", "Lcom/badlogic/gdx/audio/Sound;", "getRunningSound", "()Lcom/badlogic/gdx/audio/Sound;", "runningSoundId", "", "getRunningSoundId", "()Ljava/lang/Long;", "setRunningSoundId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "targetEntity", "Lorg/veiset/kgame/engine/ecs/entity/effect/PermaEffectAnimationEntity;", "getTargetEntity", "()Lorg/veiset/kgame/engine/ecs/entity/effect/PermaEffectAnimationEntity;", "targetEntityPos", "Lorg/veiset/kgame/engine/ecs/component/PositionComponent;", "kotlin.jvm.PlatformType", "getTargetEntityPos", "()Lorg/veiset/kgame/engine/ecs/component/PositionComponent;", "completedState", "", "completedAction", "Lorg/veiset/kgame/engine/behaviour/ActionType;", "newState", "newAction", "update", "dynamicAnimation", "Lorg/veiset/kgame/engine/behaviour/DynamicAnimation;", "delta", "speed", "kgame2"})
public final class PlayerBehaviour
implements BehaviourStateChange {
    @NotNull
    private final Engine engine;
    @NotNull
    private final PlayerEntity player;
    @NotNull
    private final Sound runningSound;
    @Nullable
    private Long runningSoundId;
    @NotNull
    private final PermaEffectAnimationEntity targetEntity;
    private final PositionComponent targetEntityPos;
    private final float dodgeCooldown;
    private float currentDodgeCooldown;
    @Nullable
    private AnimationSpeedModifier _speed;

    public PlayerBehaviour(@NotNull Engine engine, @NotNull PlayerEntity player) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)((Object)player), (String)"player");
        this.engine = engine;
        this.player = player;
        this.runningSound = org.veiset.kgame.engine.sound.Sound.INSTANCE.getRunning().get();
        this.targetEntity = new PermaEffectAnimationEntity(DynamicAnimationKt.getAnimations().getMouseClick(), MouseKt.scaledPointer(), Vector2Kt.x(0.18f, 0.18f), null, 10, 8, null);
        this.targetEntityPos = (PositionComponent)Mapper.INSTANCE.getPosition().get((Entity)this.targetEntity);
        this.dodgeCooldown = 0.5f;
        this.engine.addEntity((Entity)this.targetEntity);
    }

    @NotNull
    public final Engine getEngine() {
        return this.engine;
    }

    @NotNull
    public final PlayerEntity getPlayer() {
        return this.player;
    }

    @NotNull
    public final Sound getRunningSound() {
        return this.runningSound;
    }

    @Nullable
    public final Long getRunningSoundId() {
        return this.runningSoundId;
    }

    public final void setRunningSoundId(@Nullable Long l) {
        this.runningSoundId = l;
    }

    @NotNull
    public final PermaEffectAnimationEntity getTargetEntity() {
        return this.targetEntity;
    }

    public final PositionComponent getTargetEntityPos() {
        return this.targetEntityPos;
    }

    public final float getDodgeCooldown() {
        return this.dodgeCooldown;
    }

    public final float getCurrentDodgeCooldown() {
        return this.currentDodgeCooldown;
    }

    public final void setCurrentDodgeCooldown(float f) {
        this.currentDodgeCooldown = f;
    }

    @Nullable
    public final AnimationSpeedModifier get_speed() {
        return this._speed;
    }

    public final void set_speed(@Nullable AnimationSpeedModifier animationSpeedModifier) {
        this._speed = animationSpeedModifier;
    }

    @Override
    public void update(@NotNull DynamicAnimation dynamicAnimation, float delta, @NotNull AnimationSpeedModifier speed) {
        Vector2 vector2;
        Vector2 targetPos;
        Intrinsics.checkNotNullParameter((Object)dynamicAnimation, (String)"dynamicAnimation");
        Intrinsics.checkNotNullParameter((Object)speed, (String)"speed");
        this._speed = speed;
        ActionType currentAction = dynamicAnimation.action();
        Vector2 position = ((PositionComponent)Mapper.INSTANCE.getPosition().get((Entity)this.player)).getPos();
        VelocityComponent velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get((Entity)this.player);
        PlayerBehaviour playerBehaviour = this;
        playerBehaviour.currentDodgeCooldown -= delta;
        if (velocity.getSpeed().x == 0.0f && velocity.getSpeed().y == 0.0f) {
            dynamicAnimation.queueAction(ActionType.Idle.INSTANCE);
        }
        if (InputKeyKt.clicked(InputKey.DODGE) && this.currentDodgeCooldown <= 0.0f) {
            this.currentDodgeCooldown = this.dodgeCooldown;
            velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            dynamicAnimation.queueAction(new ActionType.Dodge(MouseKt.scaledPointer()));
        } else if (InputKeyKt.pressed(InputKey.ATTACK)) {
            velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            dynamicAnimation.queueAction(new ActionType.Attack(MouseKt.scaledPointer()));
        } else if (InputKeyKt.pressed(InputKey.MOVE)) {
            Vector2 target = MouseKt.scaledPointer();
            this.targetEntityPos.setPos(Vector2Kt.copy(target));
            if (target.dst(position) >= 0.2f) {
                dynamicAnimation.queueAction(new ActionType.Moving(target));
            }
        }
        currentAction = dynamicAnimation.action();
        if (currentAction instanceof ActionType.Dodge) {
            targetPos = ((ActionType.Dodge)currentAction).getTarget();
            vector2 = Vector2Kt.minus(targetPos, position).nor().scl(5.0f);
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"targetPos - position).nor().scl(5f)");
            velocity.setSpeed(vector2);
            if (targetPos.dst(position) <= 0.2f) {
                dynamicAnimation.queueAction(ActionType.Idle.INSTANCE);
                velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            }
        }
        if (currentAction instanceof ActionType.Moving) {
            targetPos = ((ActionType.Moving)currentAction).getTarget();
            this.targetEntityPos.setPos(Vector2Kt.copy(targetPos));
            vector2 = Vector2Kt.minus(targetPos, position).nor().scl(speed.getMove());
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"targetPos - position).nor().scl(speed.move)");
            velocity.setSpeed(vector2);
            if (targetPos.dst(position) <= 0.2f) {
                dynamicAnimation.queueAction(ActionType.Idle.INSTANCE);
                velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            }
        }
    }

    @Override
    public void completedState(@NotNull ActionType completedAction) {
        Body body;
        Intrinsics.checkNotNullParameter((Object)completedAction, (String)"completedAction");
        Object object = (DynamicBodyComponent)Mapper.INSTANCE.getDynamicBody().get((Entity)this.player);
        Body body2 = body = object == null ? null : ((DynamicBodyComponent)object).getBody();
        if (body == null) {
            throw new IllegalStateException("No body");
        }
        Body body3 = body;
        object = (InventoryComponent)Mapper.INSTANCE.getInventory().get((Entity)this.player);
        if (object == null) {
            throw new IllegalStateException("No inventory");
        }
        Object inventory = object;
        Vector2 position = ((PositionComponent)Mapper.INSTANCE.getPosition().get((Entity)this.player)).getPos();
        VelocityComponent velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get((Entity)this.player);
        ActionType actionType = completedAction;
        if (actionType instanceof ActionType.Attack) {
            velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            this.engine.addEntity((Entity)new PlayerAttackEntity(((InventoryComponent)inventory).allMods(), position, ((ActionType.Attack)completedAction).getTarget()));
        } else if (actionType instanceof ActionType.Moving) {
            if (this.runningSoundId != null) {
                this.runningSound.stop();
                this.runningSoundId = null;
            }
            this.targetEntity.disable();
        } else if (actionType instanceof ActionType.Dodge) {
            DynamicBodyComponentKt.updateCollision(body3, CollisionGroup.INSTANCE.getPLAYER());
        }
        Log.INSTANCE.debug(Intrinsics.stringPlus((String)"Completed state: ", (Object)completedAction));
    }

    @Override
    public void newState(@NotNull ActionType newAction) {
        Intrinsics.checkNotNullParameter((Object)newAction, (String)"newAction");
        DynamicBodyComponent dynamicBodyComponent = (DynamicBodyComponent)Mapper.INSTANCE.getDynamicBody().get((Entity)this.player);
        Body body = dynamicBodyComponent == null ? null : dynamicBodyComponent.getBody();
        VelocityComponent velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get((Entity)this.player);
        ActionType actionType = newAction;
        if (actionType instanceof ActionType.Moving) {
            float f;
            AnimationSpeedModifier animationSpeedModifier = this._speed;
            float pitch = animationSpeedModifier == null ? 1.5f : (f = animationSpeedModifier.getMove());
            float f2 = pitch / 3.0f;
            f = 1.6f;
            boolean bl = false;
            this.runningSoundId = this.runningSound.loop(EngineConfig.Volume.INSTANCE.getEFFECTS() * 1.0f * EngineConfig.Volume.INSTANCE.getMASTER(), Math.min(f2, f), 0.0f);
            this.targetEntity.enable();
        } else if (actionType instanceof ActionType.Attack) {
            org.veiset.kgame.engine.sound.Sound.INSTANCE.getAttack1().get().play(EngineConfig.Volume.INSTANCE.getEFFECTS() * EngineConfig.Volume.INSTANCE.getMASTER(), Vector2Kt.lerp(Random.Default.nextFloat(), 0.8f, 1.2f), 0.0f);
        } else if (actionType instanceof ActionType.Dodge) {
            org.veiset.kgame.engine.sound.Sound.INSTANCE.getDodge().get().play(EngineConfig.Volume.INSTANCE.getEFFECTS() * EngineConfig.Volume.INSTANCE.getMASTER(), Vector2Kt.lerp(Random.Default.nextFloat(), 0.7f, 0.8f), 0.0f);
            Body body2 = body;
            if (body2 != null) {
                DynamicBodyComponentKt.updateCollision(body2, CollisionGroup.INSTANCE.getPLAYER_DODGE());
            }
        } else if (actionType instanceof ActionType.Idle) {
            velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
        }
        Log.INSTANCE.debug(Intrinsics.stringPlus((String)"New State: ", (Object)newAction));
    }
}

