/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.component.player;

import com.badlogic.ashley.core.Component;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.item.Equipment;
import org.veiset.kgame.engine.item.EquipmentSlot;
import org.veiset.kgame.engine.modifier.ItemModifier;
import org.veiset.kgame.engine.modifier.ItemModifiers;
import org.veiset.kgame.engine.modifier.Modifier;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\f\u00a8\u0006\u001d"}, d2={"Lorg/veiset/kgame/engine/ecs/component/player/InventoryComponent;", "Lcom/badlogic/ashley/core/Component;", "currency", "", "weapon", "Lorg/veiset/kgame/engine/item/Equipment;", "ring", "boots", "(ILorg/veiset/kgame/engine/item/Equipment;Lorg/veiset/kgame/engine/item/Equipment;Lorg/veiset/kgame/engine/item/Equipment;)V", "getBoots", "()Lorg/veiset/kgame/engine/item/Equipment;", "setBoots", "(Lorg/veiset/kgame/engine/item/Equipment;)V", "getCurrency", "()I", "setCurrency", "(I)V", "getRing", "setRing", "getWeapon", "setWeapon", "allMods", "", "Lorg/veiset/kgame/engine/modifier/Modifier;", "getItemInSlot", "slot", "Lorg/veiset/kgame/engine/item/EquipmentSlot;", "swap", "equipment", "kgame2"})
public final class InventoryComponent
implements Component {
    private int currency;
    @NotNull
    private Equipment weapon;
    @NotNull
    private Equipment ring;
    @NotNull
    private Equipment boots;

    public InventoryComponent(int currency, @NotNull Equipment weapon, @NotNull Equipment ring, @NotNull Equipment boots) {
        Intrinsics.checkNotNullParameter((Object)weapon, (String)"weapon");
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        Intrinsics.checkNotNullParameter((Object)boots, (String)"boots");
        this.currency = currency;
        this.weapon = weapon;
        this.ring = ring;
        this.boots = boots;
    }

    public /* synthetic */ InventoryComponent(int n, Equipment equipment, Equipment equipment2, Equipment equipment3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            Object[] objectArray = new ItemModifier[]{new ItemModifier("p", "s", new Modifier.Attack.Duration(0.5f), 1.0f, 5), new ItemModifier("p", "s", new Modifier.Attack.AttackSpeed(0.8f), 1.0f, 5), new ItemModifier("p", "s", new Modifier.Damage.Flat(10.0f), 1.0f, 5)};
            equipment = new Equipment(TBEngineKt.getGlobals().getIcons().getWeapon1(), EquipmentSlot.WEAPON, new ItemModifiers(0.0f, 0, CollectionsKt.listOf((Object[])objectArray)), "Basic Weapon");
        }
        if ((n2 & 4) != 0) {
            equipment2 = new Equipment(TBEngineKt.getGlobals().getIcons().getRing1(), EquipmentSlot.RING, new ItemModifiers(0.0f, 0, CollectionsKt.emptyList()), "Ring of No talents");
        }
        if ((n2 & 8) != 0) {
            equipment3 = new Equipment(TBEngineKt.getGlobals().getIcons().getBootsStarter(), EquipmentSlot.BOOTS, new ItemModifiers(0.0f, 0, CollectionsKt.emptyList()), "Useless Boots of the Starter");
        }
        this(n, equipment, equipment2, equipment3);
    }

    public final int getCurrency() {
        return this.currency;
    }

    public final void setCurrency(int n) {
        this.currency = n;
    }

    @NotNull
    public final Equipment getWeapon() {
        return this.weapon;
    }

    public final void setWeapon(@NotNull Equipment equipment) {
        Intrinsics.checkNotNullParameter((Object)equipment, (String)"<set-?>");
        this.weapon = equipment;
    }

    @NotNull
    public final Equipment getRing() {
        return this.ring;
    }

    public final void setRing(@NotNull Equipment equipment) {
        Intrinsics.checkNotNullParameter((Object)equipment, (String)"<set-?>");
        this.ring = equipment;
    }

    @NotNull
    public final Equipment getBoots() {
        return this.boots;
    }

    public final void setBoots(@NotNull Equipment equipment) {
        Intrinsics.checkNotNullParameter((Object)equipment, (String)"<set-?>");
        this.boots = equipment;
    }

    @NotNull
    public final List<Modifier> allMods() {
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.weapon.getMods(), (Iterable)this.ring.getMods()), (Iterable)this.boots.getMods());
    }

    @NotNull
    public final Equipment getItemInSlot(@NotNull EquipmentSlot slot) {
        Equipment equipment;
        Intrinsics.checkNotNullParameter((Object)((Object)slot), (String)"slot");
        EquipmentSlot equipmentSlot = slot;
        int n = WhenMappings.$EnumSwitchMapping$0[equipmentSlot.ordinal()];
        switch (n) {
            case 1: {
                equipment = this.weapon;
                break;
            }
            case 2: {
                equipment = this.ring;
                break;
            }
            case 3: {
                equipment = this.boots;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return equipment;
    }

    @NotNull
    public final Equipment swap(@NotNull Equipment equipment) {
        Equipment equipment2;
        Intrinsics.checkNotNullParameter((Object)equipment, (String)"equipment");
        EquipmentSlot equipmentSlot = equipment.getSlot();
        int n = WhenMappings.$EnumSwitchMapping$0[equipmentSlot.ordinal()];
        switch (n) {
            case 1: {
                Equipment old = this.weapon;
                this.weapon = equipment;
                equipment2 = old;
                break;
            }
            case 2: {
                Equipment old = this.ring;
                this.ring = equipment;
                equipment2 = old;
                break;
            }
            case 3: {
                Equipment old = this.boots;
                this.boots = equipment;
                equipment2 = old;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return equipment2;
    }

    public InventoryComponent() {
        this(0, null, null, null, 15, null);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EquipmentSlot.values().length];
            nArray[EquipmentSlot.WEAPON.ordinal()] = 1;
            nArray[EquipmentSlot.RING.ordinal()] = 2;
            nArray[EquipmentSlot.BOOTS.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

