/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.entity.attack;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.ecs.component.FixedDurationComponent;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.attack.DamageComponent;
import org.veiset.kgame.engine.ecs.component.attack.ProjectileComponent;
import org.veiset.kgame.engine.ecs.component.draw.ShadowComponent;
import org.veiset.kgame.engine.ecs.component.draw.SpriteGfxComponent;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.entity.attack.SimpleAttackEntityKt;
import org.veiset.kgame.engine.ecs.system.physics.CollisionGroup;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/veiset/kgame/engine/ecs/entity/attack/SimpleAttackEntity;", "Lcom/badlogic/ashley/core/Entity;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "startPosition", "Lcom/badlogic/gdx/math/Vector2;", "targetPosition", "duration", "", "damage", "speed", "(Lcom/badlogic/gdx/physics/box2d/World;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;FFF)V", "size", "getSize", "()Lcom/badlogic/gdx/math/Vector2;", "kgame2"})
public final class SimpleAttackEntity
extends Entity {
    @NotNull
    private final Vector2 size;

    public SimpleAttackEntity(@NotNull World world, @NotNull Vector2 startPosition, @NotNull Vector2 targetPosition, float duration2, float damage, float speed) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
        Intrinsics.checkNotNullParameter((Object)targetPosition, (String)"targetPosition");
        this.size = Vector2Kt.x(0.1f, 0.1f);
        this.add(new DynamicBodyComponent(world, this, this.size, startPosition, CollisionGroup.INSTANCE.getNO_PLAYER_COLLISION(), 0.0f, 32, null));
        this.add(new PositionComponent(startPosition));
        Vector2 vector2 = Vector2Kt.minus(targetPosition, startPosition).nor().scl(speed);
        Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"targetPosition - startPosition).nor().scl(speed)");
        this.add(new VelocityComponent(vector2));
        this.add(new ProjectileComponent());
        this.add(new FixedDurationComponent(duration2));
        this.add(new SpriteGfxComponent(SimpleAttackEntityKt.access$getTextureStore$p().getAttackBall(), Vector2Kt.x(0.1f, 0.1f), 0, 0.0f, 0.0f, 28, null));
        vector2 = Vector2Kt.x(0.0f, -0.2f);
        this.add(new ShadowComponent(0.1f, vector2, null, 0.0f, true, 12, null));
        this.add(new DamageComponent(damage));
    }

    public /* synthetic */ SimpleAttackEntity(World world, Vector2 vector2, Vector2 vector22, float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            f2 = 35.0f;
        }
        if ((n & 0x20) != 0) {
            f3 = 5.0f;
        }
        this(world, vector2, vector22, f, f2, f3);
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }
}

