/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.entity.enemy;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.behaviour.DynamicAnimation;
import org.veiset.kgame.engine.behaviour.ZombieBehaviour;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.ai.LinearMoveAIComponent;
import org.veiset.kgame.engine.ecs.component.attack.AttackPlayerComponent;
import org.veiset.kgame.engine.ecs.component.attack.AttackType;
import org.veiset.kgame.engine.ecs.component.attack.AttackTypeComponent;
import org.veiset.kgame.engine.ecs.component.draw.DynamicAnimationComponent;
import org.veiset.kgame.engine.ecs.component.draw.ShadowComponent;
import org.veiset.kgame.engine.ecs.component.draw.TextLabelComponent;
import org.veiset.kgame.engine.ecs.component.enemy.DebrisComponent;
import org.veiset.kgame.engine.ecs.component.enemy.MonsterComponent;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.component.stats.HealthBarComponent;
import org.veiset.kgame.engine.ecs.component.stats.HealthComponent;
import org.veiset.kgame.engine.ecs.system.physics.CollisionGroup;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.storage.AnimationStoreKt;
import org.veiset.kgame.engine.util.TargetType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/veiset/kgame/engine/ecs/entity/enemy/SpeedyDumbZombie;", "Lcom/badlogic/ashley/core/Entity;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "startPos", "Lcom/badlogic/gdx/math/Vector2;", "(Lcom/badlogic/gdx/physics/box2d/World;Lcom/badlogic/gdx/math/Vector2;)V", "kgame2"})
public final class SpeedyDumbZombie
extends Entity {
    public SpeedyDumbZombie(@NotNull World world, @NotNull Vector2 startPos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
        this.add(new MonsterComponent());
        Collection collection = TBEngineKt.getGlobals().getTextureStore().getZombieDebris();
        boolean bl = false;
        this.add(new DebrisComponent((TextureRegion)CollectionsKt.random((Collection)collection, (Random)((Random)Random.Default))));
        this.add(new DynamicBodyComponent(world, this, Vector2Kt.x(0.3f, 0.4f), startPos, CollisionGroup.INSTANCE.getMONSTER(), 0.0f, 32, null));
        this.add(new PositionComponent(startPos));
        this.add(new VelocityComponent(Vector2Kt.x(0.0f, 0.0f)));
        this.add(new HealthComponent(25.0f));
        this.add(new HealthBarComponent(Vector2Kt.x(0.4f, 0.08f), Vector2Kt.x(-0.2f, 0.5f)));
        Vector2 vector2 = Vector2Kt.x(-0.4f, 0.45f);
        collection = Color.LIGHT_GRAY;
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"LIGHT_GRAY");
        this.add(new TextLabelComponent("Exploder", vector2, (Color)collection, null, 0, 24, null));
        this.add(new ShadowComponent(0.2f, null, null, 0.0f, false, 30, null));
        this.add(new AttackPlayerComponent(0.7f, 1.0f));
        this.add(new AttackTypeComponent(new AttackType.SelfExplode(1.0f)));
        this.add(new LinearMoveAIComponent(new TargetType.Distance(6.0f), 3.0f, false, 4, null));
        this.add(new DynamicAnimationComponent(new DynamicAnimation(AnimationStoreKt.generateZomieAnimationSet(), new ZombieBehaviour(this)), Vector2Kt.x(0.3f, 0.3f), null, 0, 0.0f, 0.0f, null, 124, null));
    }
}

