/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.attack;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.ecs.component.attack.PlayerAttackComponent;
import org.veiset.kgame.engine.ecs.entity.attack.SimpleAttackEntity;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.modifier.Modifier;
import org.veiset.kgame.engine.modifier.ModifierEngine;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/veiset/kgame/engine/ecs/system/attack/PlayerAttackSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "attacks", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class PlayerAttackSystem
extends EntitySystem {
    @NotNull
    private final World world;
    private ImmutableArray<Entity> attacks;

    public PlayerAttackSystem(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
    }

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{PlayerAttackComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(PlayerAttackComponent::class.java).get())");
        this.attacks = immutableArray;
    }

    /*
     * WARNING - void declaration
     */
    public void update(float deltaTime) {
        ImmutableArray<Entity> immutableArray = this.attacks;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attacks");
            throw null;
        }
        Iterable $this$forEach$iv = (Iterable)immutableArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            PlayerAttackComponent attack = (PlayerAttackComponent)Mapper.INSTANCE.getPlayerAttack().get(entity);
            List<Modifier> mods = attack.getMods();
            int projectiles2 = ModifierEngine.Attack.INSTANCE.projectiles(mods);
            float duration2 = ModifierEngine.Attack.INSTANCE.duration(mods);
            float damage = ModifierEngine.Attack.INSTANCE.damage(mods, 10.0f);
            Vector2 direction = Vector2Kt.minus(attack.getTargetPos(), attack.getPlayerPos()).nor();
            float spacing2 = ModifierEngine.Attack.INSTANCE.spacing(attack.getMods());
            float spread2 = ModifierEngine.Attack.INSTANCE.spread(attack.getMods());
            Iterable $this$map$iv = (Iterable)new IntRange(-projectiles2 / 2, projectiles2 / 2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void i;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Vector2 target = attack.getTargetPos();
                Vector2 startPos = attack.getPlayerPos();
                Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"direction");
                Vector2 vector2 = Vector2Kt.copy(direction).nor();
                Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"direction.copy().nor()");
                Vector2 offset = Vector2Kt.perpendicular(vector2).scl(spacing2 * (float)i);
                Engine engine = this.getEngine();
                Intrinsics.checkNotNullExpressionValue((Object)offset, (String)"offset");
                Vector2 vector22 = Vector2Kt.plus(startPos, offset);
                vector2 = Vector2Kt.copy(offset).scl(spread2);
                Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"offset.copy().scl(spread)");
                engine.addEntity((Entity)new SimpleAttackEntity(this.world, vector22, Vector2Kt.plus(target, vector2), duration2, damage, 4.0f + Random.Default.nextFloat() * 2.0f));
                Unit unit = Unit.INSTANCE;
                collection.add(unit);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            this.getEngine().removeEntity(entity);
        }
    }
}

