/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.enemy;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.component.enemy.BossComponent;
import org.veiset.kgame.engine.ecs.component.stats.HealthComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.FontUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/veiset/kgame/engine/ecs/system/enemy/BossHealthBarSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "boss", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "draw", "name", "", "health", "Lorg/veiset/kgame/engine/ecs/component/stats/HealthComponent;", "update", "deltaTime", "", "kgame2"})
public final class BossHealthBarSystem
extends EntitySystem {
    private ImmutableArray<Entity> boss;

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{BossComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(BossComponent::class.java).get())");
        this.boss = immutableArray;
    }

    public void update(float deltaTime) {
        ImmutableArray<Entity> immutableArray = this.boss;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"boss");
            throw null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableArray));
        if (entity == null) {
            return;
        }
        Entity boss = entity;
        BossComponent bossComponent = (BossComponent)boss.getComponent(BossComponent.class);
        HealthComponent health = (HealthComponent)Mapper.INSTANCE.getHealth().get(boss);
        String string = bossComponent.getName();
        Intrinsics.checkNotNullExpressionValue((Object)health, (String)"health");
        this.draw(string, health);
    }

    public final void draw(@NotNull String name, @NotNull HealthComponent health) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)health, (String)"health");
        BitmapFont font = TBEngineKt.getGlobals().getFonts().getJbb32();
        SpriteBatch sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        ShapeRenderer sr = TBEngineKt.getGlobals().getDrawUi().getShapeRenderer();
        String text = String.valueOf(name);
        float remindingHealthP = health.getCurrentHealth() / health.getMaxHealth();
        float healthLength = Vector2Kt.lerp(remindingHealthP, 0.0f, 16.0f);
        Vector2 textpos = FontUtilsKt.middle(font, text);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        sr.begin(ShapeRenderer.ShapeType.Filled);
        sr.setColor(ColorKt.color((float)1.0f, (float)0.0f, (float)0.0f, (float)0.6f));
        ShapeRendererKt.rect((ShapeRenderer)sr, (Vector2)Vector2Kt.dw(Vector2Kt.x(0.0f, 8.7f)), (Vector2)Vector2Kt.dw(Vector2Kt.x(healthLength, 9.0f)));
        sr.setColor(ColorKt.color((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6f));
        ShapeRendererKt.rect((ShapeRenderer)sr, (Vector2)Vector2Kt.dw(Vector2Kt.x(healthLength, 8.7f)), (Vector2)Vector2Kt.dw(Vector2Kt.x(16.0f, 9.0f)));
        sr.end();
        sb.begin();
        font.draw((Batch)sb, (CharSequence)text, textpos.x * 120.0f, 1074.0f);
        sb.end();
        Gdx.gl.glDisable(3042);
    }
}

