/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.enemy;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.enemy.ArrowMarkerComponent;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.MapperNullable;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.storage.TextureStore;
import org.veiset.kgame.engine.util.GdxUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/veiset/kgame/engine/ecs/system/enemy/PointToEnemySystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "arrowSize", "", "markers", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "playerCharacter", "spriteBatch", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "textures", "Lorg/veiset/kgame/engine/storage/TextureStore;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "draw", "position", "Lcom/badlogic/gdx/math/Vector2;", "angle", "color", "Lcom/badlogic/gdx/graphics/Color;", "opacity", "getPosition", "monsterPos", "playerPos", "update", "deltaTime", "kgame2"})
public final class PointToEnemySystem
extends EntitySystem {
    private ImmutableArray<Entity> playerCharacter;
    private ImmutableArray<Entity> markers;
    private final float arrowSize;
    @NotNull
    private final SpriteBatch spriteBatch = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
    @NotNull
    private final TextureStore textures = TBEngineKt.getGlobals().getTextureStore();

    public PointToEnemySystem() {
        this.arrowSize = 0.3f;
    }

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{PlayerCharacterComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(PlayerCharacterComponent::class.java).get())");
        this.playerCharacter = immutableArray;
        classArray = new Class[]{ArrowMarkerComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(ArrowMarkerComponent::class.java, PositionComponent::class.java).get())");
        this.markers = immutableArray;
    }

    public void update(float deltaTime) {
        ImmutableArray<Entity> immutableArray = this.playerCharacter;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playerCharacter");
            throw null;
        }
        if (immutableArray.size() == 0) {
            return;
        }
        ImmutableArray<Entity> immutableArray2 = TBEngineKt.getGlobals().getDrawGfx().getCamera().position;
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray2, (String)"globals.drawGfx.camera.position");
        Vector2 playerPos = Vector2Kt.gfxToWorld(Vector2Kt.v2((Vector3)immutableArray2));
        immutableArray2 = this.markers;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"markers");
            throw null;
        }
        Iterable $this$forEach$iv = (Iterable)immutableArray2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            Vector2 monsterPos = ((PositionComponent)Mapper.INSTANCE.getPosition().get(it)).getPos();
            Vector2 position = this.getPosition(monsterPos, playerPos);
            if (position == null) continue;
            float angle = Vector2Kt.minus(playerPos, monsterPos).angleDeg();
            Component component = MapperNullable.INSTANCE.getArrowMarker().get(it);
            Intrinsics.checkNotNull((Object)component);
            ArrowMarkerComponent marker = (ArrowMarkerComponent)component;
            this.draw(position, angle, marker.getColor(), marker.getOpacity());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Vector2 getPosition(@NotNull Vector2 monsterPos, @NotNull Vector2 playerPos) {
        Vector2 vector2;
        Intrinsics.checkNotNullParameter((Object)monsterPos, (String)"monsterPos");
        Intrinsics.checkNotNullParameter((Object)playerPos, (String)"playerPos");
        float xdiff = monsterPos.x - playerPos.x;
        float ydiff = monsterPos.y - playerPos.y;
        float yt = 4.3f;
        float xt = 7.5f;
        if (ydiff <= yt && ydiff > -yt && xdiff > 8.0f) {
            vector2 = Vector2Kt.x(16.0f - this.arrowSize, ydiff + 4.5f);
            return vector2;
        }
        if (ydiff <= yt && ydiff > -yt && xdiff < -8.0f) {
            vector2 = Vector2Kt.x(0.0f, ydiff + 4.5f);
            return vector2;
        }
        if (xdiff <= xt && xdiff > -xt && ydiff > 4.5f) {
            vector2 = Vector2Kt.x(xdiff + 8.0f, 9.0f - this.arrowSize);
            return vector2;
        }
        if (xdiff <= xt && xdiff > -xt && ydiff < -4.5f) {
            vector2 = Vector2Kt.x(xdiff + 8.0f, 0.0f);
            return vector2;
        }
        float f = xdiff;
        boolean bl = false;
        if (Math.abs(f) > xt) {
            f = ydiff;
            bl = false;
            if (Math.abs(f) > yt) {
                if (xdiff >= 0.0f && ydiff >= 0.0f) {
                    vector2 = Vector2Kt.x(16.0f - this.arrowSize, 9.0f - this.arrowSize);
                    return vector2;
                }
                if (xdiff >= 0.0f && ydiff <= 0.0f) {
                    vector2 = Vector2Kt.x(16.0f - this.arrowSize, 0.0f);
                    return vector2;
                }
                if (xdiff <= 0.0f && ydiff >= 0.0f) {
                    vector2 = Vector2Kt.x(0.0f, 9.0f - this.arrowSize);
                    return vector2;
                }
                if (xdiff <= 0.0f && ydiff <= 0.0f) {
                    vector2 = Vector2Kt.x(0.0f, 0.0f);
                    return vector2;
                }
                vector2 = null;
                return vector2;
            }
        }
        vector2 = null;
        return vector2;
    }

    public final void draw(@NotNull Vector2 position, float angle, @NotNull Color color, float opacity) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.spriteBatch.begin();
        Color color2 = this.spriteBatch.getColor();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"spriteBatch.color");
        Color c = ColorKt.copy$default((Color)color2, null, null, null, null, (int)15, null);
        this.spriteBatch.setColor(ColorKt.color((float)color.r, (float)color.g, (float)color.b, (float)opacity));
        GdxUtilsKt.draw(this.spriteBatch, this.textures.getArrow(), Vector2Kt.dw(position), Vector2Kt.dw(Vector2Kt.x(this.arrowSize, this.arrowSize)), angle);
        this.spriteBatch.end();
        this.spriteBatch.setColor(c);
    }
}

