/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.graphics;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.camera.CameraEffectComponent;
import org.veiset.kgame.engine.ecs.component.camera.CameraFollowComponent;
import org.veiset.kgame.engine.ecs.component.camera.CameraManipulation;
import org.veiset.kgame.engine.ecs.component.camera.CameraMovementI;
import org.veiset.kgame.engine.ecs.component.camera.CameraShake;
import org.veiset.kgame.engine.ecs.component.camera.CameraZoomI;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.MapperNullable;
import org.veiset.kgame.engine.ecs.system.graphics.CameraSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.world.WorldMapBounds;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/veiset/kgame/engine/ecs/system/graphics/CameraSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "initPos", "Lcom/badlogic/gdx/math/Vector2;", "worldMapBounds", "Lorg/veiset/kgame/engine/world/WorldMapBounds;", "(Lcom/badlogic/gdx/math/Vector2;Lorg/veiset/kgame/engine/world/WorldMapBounds;)V", "camera", "Lcom/badlogic/gdx/graphics/OrthographicCamera;", "cameraFollowEntities", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "cameraHandler", "Lorg/veiset/kgame/engine/ecs/system/graphics/CameraSystem$CameraHandler;", "cameraMovements", "playerCharacter", "virtualCamera", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "delta", "", "CameraHandler", "kgame2"})
public final class CameraSystem
extends EntitySystem {
    @NotNull
    private final WorldMapBounds worldMapBounds;
    @NotNull
    private final CameraHandler cameraHandler;
    @NotNull
    private final OrthographicCamera virtualCamera;
    @NotNull
    private final OrthographicCamera camera;
    private ImmutableArray<Entity> cameraFollowEntities;
    private ImmutableArray<Entity> cameraMovements;
    private ImmutableArray<Entity> playerCharacter;

    /*
     * WARNING - void declaration
     */
    public CameraSystem(@NotNull Vector2 initPos, @NotNull WorldMapBounds worldMapBounds) {
        void it;
        Intrinsics.checkNotNullParameter((Object)initPos, (String)"initPos");
        Intrinsics.checkNotNullParameter((Object)worldMapBounds, (String)"worldMapBounds");
        this.worldMapBounds = worldMapBounds;
        this.cameraHandler = new CameraHandler();
        OrthographicCamera orthographicCamera = new OrthographicCamera(1920.0f, 1080.0f);
        boolean bl = false;
        boolean bl2 = false;
        OrthographicCamera orthographicCamera2 = orthographicCamera;
        CameraSystem cameraSystem = this;
        boolean bl3 = false;
        it.setToOrtho(false, 1920.0f, 1080.0f);
        Unit unit = Unit.INSTANCE;
        cameraSystem.virtualCamera = orthographicCamera;
        this.camera = TBEngineKt.getGlobals().getDrawGfx().getCamera();
        this.virtualCamera.position.set(Vector2Kt.dw(initPos), 0.0f);
        Log.INSTANCE.warn(initPos);
        orthographicCamera = this.virtualCamera.position;
        Intrinsics.checkNotNullExpressionValue((Object)orthographicCamera, (String)"virtualCamera.position");
        Log.INSTANCE.warn(Vector2Kt.v2((Vector3)orthographicCamera));
        CameraSystemKt.access$updateDrawMatrix();
    }

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{PositionComponent.class, CameraFollowComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(PositionComponent::class.java, CameraFollowComponent::class.java).get())");
        this.cameraFollowEntities = immutableArray;
        classArray = new Class[]{CameraEffectComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(CameraEffectComponent::class.java).get())");
        this.cameraMovements = immutableArray;
        classArray = new Class[]{PlayerCharacterComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(PlayerCharacterComponent::class.java).get())");
        this.playerCharacter = immutableArray;
    }

    /*
     * WARNING - void declaration
     */
    public void update(float delta) {
        Entity entity;
        void $this$mapTo$iv$iv;
        ImmutableArray<Entity> immutableArray = this.cameraFollowEntities;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraFollowEntities");
            throw null;
        }
        Entity cameraFollowEntity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableArray));
        if (cameraFollowEntity == null) {
            ImmutableArray<Entity> immutableArray2 = this.playerCharacter;
            if (immutableArray2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playerCharacter");
                throw null;
            }
            Entity entity2 = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableArray2));
            ImmutableArray<Entity> immutableArray3 = immutableArray = entity2 == null ? null : entity2.add((Component)new CameraFollowComponent(0.0f, 0.0f, 0.0f, 0.0f, 15, null));
            if (immutableArray == null) {
                return;
            }
            return;
        }
        Vector2 targetPos = ((PositionComponent)Mapper.INSTANCE.getPosition().get(cameraFollowEntity)).getPos();
        CameraFollowComponent cameraFollow = (CameraFollowComponent)Mapper.INSTANCE.getCameraFollow().get(cameraFollowEntity);
        Vector3 vector3 = this.virtualCamera.position;
        Intrinsics.checkNotNullExpressionValue((Object)vector3, (String)"virtualCamera.position");
        Vector2 cameraPos = Vector2Kt.gfxToWorld(Vector2Kt.v2(vector3));
        Vector2 dstVector = Vector2Kt.minus(targetPos, cameraPos);
        ImmutableArray<Entity> immutableArray4 = this.cameraMovements;
        if (immutableArray4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraMovements");
            throw null;
        }
        Iterable $this$map$iv = (Iterable)immutableArray4;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entity3;
            entity = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Component component = Mapper.INSTANCE.getCameraEffect().get((Entity)entity3);
            boolean bl2 = false;
            boolean bl3 = false;
            CameraEffectComponent it = (CameraEffectComponent)component;
            boolean bl4 = false;
            CameraManipulation cameraManipulation = it.getCameraMovement();
            cameraManipulation.setElapsed(cameraManipulation.getElapsed() + delta);
            if (it.getCameraMovement().getElapsed() >= it.getCameraMovement().getDuration()) {
                this.getEngine().removeEntity((Entity)entity3);
            }
            CameraEffectComponent cameraEffectComponent = (CameraEffectComponent)component;
            collection.add(cameraEffectComponent);
        }
        List cameraEffectComponents = (List)destination$iv$iv;
        float dst = dstVector.len();
        if (dst > cameraFollow.getMaxDistance() * 1.01f) {
            Vector2 maxTarget = Vector2Kt.minus(targetPos, cameraPos).nor().scl(cameraFollow.getMaxDistance());
            Intrinsics.checkNotNullExpressionValue((Object)maxTarget, (String)"maxTarget");
            Vector2 newTarget = Vector2Kt.minus(targetPos, maxTarget);
            this.virtualCamera.position.set(Vector2Kt.dw(newTarget), 0.0f);
        } else if (dst >= cameraFollow.getSoftMaxDistance()) {
            iterable = dstVector.nor().scl(cameraFollow.getMaxSpeed() * 3.0f * delta * (float)60);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"dstVector.nor().scl(cameraFollow.maxSpeed * 3f * delta * 60)");
            Vector2 dw = Vector2Kt.dw((Vector2)iterable);
            this.virtualCamera.translate(dw);
        } else if (dst >= cameraFollow.getNoFollow()) {
            iterable = dstVector.nor().scl(cameraFollow.getMaxSpeed() * delta * (float)60);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"dstVector.nor().scl(cameraFollow.maxSpeed * delta * 60)");
            Vector2 dw = Vector2Kt.dw((Vector2)iterable);
            this.virtualCamera.translate(dw);
        }
        iterable = this.virtualCamera.position;
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"virtualCamera.position");
        Vector2 campos = Vector2Kt.gfxToWorld(Vector2Kt.v2((Vector3)iterable));
        iterable = this.worldMapBounds.keepBound(campos);
        float camx = Vector2Kt.component1((Vector2)iterable);
        float camy = Vector2Kt.component2((Vector2)iterable);
        this.virtualCamera.position.x = camx * 120.0f;
        this.virtualCamera.position.y = camy * 120.0f;
        if (MapperNullable.INSTANCE.getPlayer().get(cameraFollowEntity) != null && EngineConfig.Engine.INSTANCE.getCAMERA_FOLLOW_INFRONT()) {
            Vector2 posDiff = Vector2Kt.minus(cameraPos, targetPos);
            Vector2 cameraPosNew = Vector2Kt.minus(cameraPos, Vector2Kt.times(posDiff, 2.0f));
            entity = this.worldMapBounds.keepBound(cameraPosNew);
            float camx2 = Vector2Kt.component1((Vector2)entity);
            float camy2 = Vector2Kt.component2((Vector2)entity);
            this.camera.position.x = camx2 * 120.0f;
            this.camera.position.y = camy2 * 120.0f;
        } else {
            this.camera.position.set(this.virtualCamera.position);
        }
        this.cameraHandler.update(delta, cameraEffectComponents);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/veiset/kgame/engine/ecs/system/graphics/CameraSystem$CameraHandler;", "", "()V", "camera", "Lcom/badlogic/gdx/graphics/OrthographicCamera;", "update", "", "delta", "", "targets", "", "Lorg/veiset/kgame/engine/ecs/component/camera/CameraEffectComponent;", "kgame2"})
    public static final class CameraHandler {
        @NotNull
        private final OrthographicCamera camera = TBEngineKt.getGlobals().getDrawGfx().getCamera();

        /*
         * WARNING - void declaration
         */
        public final void update(float delta, @NotNull List<CameraEffectComponent> targets) {
            Vector3 vector3;
            void $this$filterIsInstanceTo$iv$iv3;
            Collection $this$filterIsInstance$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$fold$iv;
            void $this$filterIsInstanceTo$iv$iv2;
            Iterable $this$filterIsInstance$iv2;
            CameraManipulation cameraManipulation;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            List list;
            Collection destination$iv$iv;
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            if (!EngineConfig.Effects.INSTANCE.getSCREEN_SHAKE()) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = targets;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    CameraEffectComponent it = (CameraEffectComponent)element$iv$iv;
                    boolean bl = false;
                    if (!(!(it.getCameraMovement() instanceof CameraShake))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = targets;
            }
            List effects = list;
            Iterable $i$f$filter = effects;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                CameraEffectComponent bl = (CameraEffectComponent)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                cameraManipulation = it.getCameraMovement();
                collection.add(cameraManipulation);
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv2 = $this$filterIsInstance$iv2;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof CameraMovementI)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
            Object initial$iv = new Vector2(0.0f, 0.0f);
            boolean $i$f$fold = false;
            Vector2 accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void vm;
                Object element$iv$iv;
                element$iv$iv = (CameraMovementI)element$iv;
                Vector2 acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = Vector2Kt.plus(acc, vm.offset(delta));
            }
            Vector2 movements = accumulator$iv;
            initial$iv = effects;
            boolean $i$f$map2 = false;
            accumulator$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CameraEffectComponent bl = (CameraEffectComponent)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl3 = false;
                cameraManipulation = it.getCameraMovement();
                collection.add(cameraManipulation);
            }
            $this$map$iv = (List)destination$iv$iv3;
            boolean $i$f$filterIsInstance22 = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                if (!(element$iv$iv instanceof CameraZoomI)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List zooms = (List)destination$iv$iv3;
            $this$filterIsInstance$iv = zooms;
            $i$f$filterIsInstance22 = false;
            if (!$this$filterIsInstance$iv.isEmpty()) {
                float zoom;
                void $this$fold$iv2;
                void initial$iv2;
                Iterable $i$f$filterIsInstance22 = zooms;
                float $this$filterIsInstanceTo$iv$iv3 = 0.0f;
                float f = 1.0f;
                boolean $i$f$fold2 = false;
                void accumulator$iv2 = initial$iv2;
                for (Object element$iv : $this$fold$iv2) {
                    void cameraZoom;
                    CameraZoomI it = (CameraZoomI)element$iv;
                    void acc = accumulator$iv2;
                    boolean bl = false;
                    accumulator$iv2 = acc + cameraZoom.zoom(delta);
                }
                void var17_38 = accumulator$iv2;
                this.camera.zoom = zoom = f + var17_38;
            }
            Vector3 vector32 = vector3 = this.camera.position;
            Intrinsics.checkNotNullExpressionValue((Object)vector3, (String)"camera.position");
            vector32.set(Vector2Kt.plus(Vector2Kt.v2(vector3), Vector2Kt.dw(movements)), 0.0f);
            CameraSystemKt.access$updateDrawMatrix();
        }
    }
}

