/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.graphics;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.ecs.component.draw.AnimationGfxComponent;
import org.veiset.kgame.engine.ecs.component.draw.Direction;
import org.veiset.kgame.engine.ecs.system.graphics.DrawInstruction;
import org.veiset.kgame.engine.ecs.system.graphics.DrawSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/veiset/kgame/engine/ecs/system/graphics/DrawAnimation;", "Lorg/veiset/kgame/engine/ecs/system/graphics/DrawInstruction;", "y", "", "layer", "", "animationGfx", "Lorg/veiset/kgame/engine/ecs/component/draw/AnimationGfxComponent;", "position", "Lcom/badlogic/gdx/math/Vector2;", "(FILorg/veiset/kgame/engine/ecs/component/draw/AnimationGfxComponent;Lcom/badlogic/gdx/math/Vector2;)V", "getAnimationGfx", "()Lorg/veiset/kgame/engine/ecs/component/draw/AnimationGfxComponent;", "getLayer", "()I", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "getY", "()F", "component1", "component2", "component3", "component4", "copy", "draw", "", "delta", "equals", "", "other", "", "hashCode", "toString", "", "kgame2"})
public final class DrawAnimation
implements DrawInstruction {
    private final float y;
    private final int layer;
    @NotNull
    private final AnimationGfxComponent animationGfx;
    @NotNull
    private final Vector2 position;

    public DrawAnimation(float y, int layer, @NotNull AnimationGfxComponent animationGfx, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter((Object)animationGfx, (String)"animationGfx");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.y = y;
        this.layer = layer;
        this.animationGfx = animationGfx;
        this.position = position;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public int getLayer() {
        return this.layer;
    }

    @NotNull
    public final AnimationGfxComponent getAnimationGfx() {
        return this.animationGfx;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    @Override
    public void draw(float delta) {
        float keyFrameTime = this.animationGfx.getTime();
        TextureRegion gfx = (TextureRegion)this.animationGfx.getAnimation().getKeyFrame(keyFrameTime, this.animationGfx.getRepeat());
        Vector2 vector2 = this.position;
        float x = Vector2Kt.component1(vector2);
        float y = Vector2Kt.component2(vector2);
        Vector2 vector22 = this.animationGfx.getSize();
        float sx = Vector2Kt.component1(vector22);
        float sy = Vector2Kt.component2(vector22);
        Vector2 vector23 = this.animationGfx.getOffset();
        float ox = Vector2Kt.component1(vector23);
        float oy = Vector2Kt.component2(vector23);
        if (this.animationGfx.getDirection() == Direction.RIGHT) {
            DrawSystemKt.access$getSpriteBatch$p().draw(gfx, (x + ox - sx / 2.0f) * 120.0f, (y + oy - sy / 2.0f) * 120.0f, sx * 120.0f, sy * 120.0f);
        } else {
            DrawSystemKt.access$getSpriteBatch$p().draw(gfx, (x + ox - sx / 2.0f + sx) * 120.0f, (y + oy - sy / 2.0f) * 120.0f, -sx * 120.0f, sy * 120.0f);
        }
    }

    public final float component1() {
        return this.getY();
    }

    public final int component2() {
        return this.getLayer();
    }

    @NotNull
    public final AnimationGfxComponent component3() {
        return this.animationGfx;
    }

    @NotNull
    public final Vector2 component4() {
        return this.position;
    }

    @NotNull
    public final DrawAnimation copy(float y, int layer, @NotNull AnimationGfxComponent animationGfx, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter((Object)animationGfx, (String)"animationGfx");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return new DrawAnimation(y, layer, animationGfx, position);
    }

    public static /* synthetic */ DrawAnimation copy$default(DrawAnimation drawAnimation, float f, int n, AnimationGfxComponent animationGfxComponent, Vector2 vector2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            f = drawAnimation.getY();
        }
        if ((n2 & 2) != 0) {
            n = drawAnimation.getLayer();
        }
        if ((n2 & 4) != 0) {
            animationGfxComponent = drawAnimation.animationGfx;
        }
        if ((n2 & 8) != 0) {
            vector2 = drawAnimation.position;
        }
        return drawAnimation.copy(f, n, animationGfxComponent, vector2);
    }

    @NotNull
    public String toString() {
        return "DrawAnimation(y=" + this.getY() + ", layer=" + this.getLayer() + ", animationGfx=" + this.animationGfx + ", position=" + this.position + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.getY());
        result = result * 31 + Integer.hashCode(this.getLayer());
        result = result * 31 + this.animationGfx.hashCode();
        result = result * 31 + this.position.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DrawAnimation)) {
            return false;
        }
        DrawAnimation drawAnimation = (DrawAnimation)other;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.getY()), (Object)Float.valueOf(drawAnimation.getY()))) {
            return false;
        }
        if (this.getLayer() != drawAnimation.getLayer()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.animationGfx, (Object)drawAnimation.animationGfx)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.position, (Object)drawAnimation.position);
    }
}

