/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.levelselect;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.levelselect.GameLevelComponent;
import org.veiset.kgame.engine.ecs.entity.levelselect.SelectedLevelComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.math.Hex;
import org.veiset.kgame.engine.math.HexLayout;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.ui.UiComponentsKt;
import org.veiset.kgame.engine.util.GdxUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/veiset/kgame/engine/ecs/system/levelselect/DrawHexSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "hexLayout", "Lorg/veiset/kgame/engine/math/HexLayout;", "(Lorg/veiset/kgame/engine/math/HexLayout;)V", "getHexLayout", "()Lorg/veiset/kgame/engine/math/HexLayout;", "hexes", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "selectState", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class DrawHexSystem
extends EntitySystem {
    @NotNull
    private final HexLayout hexLayout;
    private ImmutableArray<Entity> hexes;
    private ImmutableArray<Entity> selectState;

    public DrawHexSystem(@NotNull HexLayout hexLayout) {
        Intrinsics.checkNotNullParameter((Object)hexLayout, (String)"hexLayout");
        this.hexLayout = hexLayout;
    }

    @NotNull
    public final HexLayout getHexLayout() {
        return this.hexLayout;
    }

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{GameLevelComponent.class, PositionComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(GameLevelComponent::class.java, PositionComponent::class.java).get())");
        this.hexes = immutableArray;
        classArray = new Class[]{SelectedLevelComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(SelectedLevelComponent::class.java).get())");
        this.selectState = immutableArray;
    }

    /*
     * WARNING - void declaration
     */
    public void update(float deltaTime) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv2;
        void $this$mapTo$iv$iv;
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        UiComponentsKt.getSpriteBatch().begin();
        ImmutableArray<Entity> immutableArray = this.selectState;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectState");
            throw null;
        }
        SelectedLevelComponent selectLevel = (SelectedLevelComponent)Mapper.LevelSelect.INSTANCE.getSelectLevel().get((Entity)immutableArray.first());
        GameLevelComponent selectedLevel = selectLevel.getSelected();
        GameLevelComponent hoveredLevel = selectLevel.getHovered();
        ImmutableArray<Entity> immutableArray2 = this.hexes;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hexes");
            throw null;
        }
        Iterable $this$map$iv = (Iterable)immutableArray2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection<Object> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Entity entity = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            GameLevelComponent gameLevelComponent = (GameLevelComponent)Mapper.LevelSelect.INSTANCE.getGameLevel().get((Entity)it);
            collection.add(gameLevelComponent);
        }
        List levels = (List)destination$iv$iv;
        ImmutableArray<Entity> $this$filter$iv = (ImmutableArray<Entity>)levels;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            GameLevelComponent it = (GameLevelComponent)element$iv$iv;
            boolean bl2 = false;
            if (!it.getFinished()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        int clearedMaps = ((List)destination$iv$iv2).size();
        $this$filter$iv = this.hexes;
        if ($this$filter$iv == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hexes");
            throw null;
        }
        Iterable $this$sortedByDescending$iv = (Iterable)$this$filter$iv;
        boolean $i$f$sortedByDescending = false;
        boolean $this$filterTo$iv$iv2 = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Entity it = (Entity)b;
                boolean bl2 = false;
                it = (Entity)a;
                Comparable comparable = Float.valueOf(((PositionComponent)Mapper.INSTANCE.getPosition().get((Entity)it)).getPos().y);
                bl2 = false;
                Float f = Float.valueOf(((PositionComponent)Mapper.INSTANCE.getPosition().get((Entity)it)).getPos().y);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)f);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            Vector2 position = ((PositionComponent)Mapper.INSTANCE.getPosition().get(entity)).getPos();
            GameLevelComponent hexLevel = (GameLevelComponent)Mapper.LevelSelect.INSTANCE.getGameLevel().get(entity);
            if (hexLevel.getFinished()) {
                UiComponentsKt.getSpriteBatch().setColor(ColorKt.color((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f));
            } else if (hexLevel.getRequirement() > clearedMaps) {
                UiComponentsKt.getSpriteBatch().setColor(ColorKt.color((float)0.5f, (float)0.5f, (float)1.0f, (float)1.0f));
            } else {
                UiComponentsKt.getSpriteBatch().setColor(ColorKt.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
            }
            Vector2 bl2 = this.getHexLayout().spriteSize();
            float xs = Vector2Kt.component1(bl2);
            float ys = Vector2Kt.component2(bl2);
            Vector2 size = new Vector2(xs, ys);
            SpriteBatch spriteBatch = UiComponentsKt.getSpriteBatch();
            TextureRegion textureRegion = hexLevel.getArea().getIcon();
            Vector2 vector2 = Vector2Kt.copy(size).scl(0.5f);
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"size.copy().scl(0.5f)");
            GdxUtilsKt.draw(spriteBatch, textureRegion, Vector2Kt.dw(Vector2Kt.minus(position, vector2)), Vector2Kt.dw(size));
        }
        if (selectedLevel != null) {
            void $this$filterTo$iv$iv3;
            Object element$iv;
            Iterable $this$filter$iv2 = levels;
            boolean $i$f$filter2 = false;
            element$iv = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                GameLevelComponent it = (GameLevelComponent)element$iv$iv;
                boolean bl3 = false;
                if (!it.getFinished()) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            int cleared = ((List)destination$iv$iv3).size();
            $this$filter$iv2 = Vector2Kt.dw(Vector2Kt.x(10.0f, 7.0f));
            float tx = Vector2Kt.component1((Vector2)$this$filter$iv2);
            float ty = Vector2Kt.component2((Vector2)$this$filter$iv2);
            String text = selectedLevel.getArea().getDescription();
            int requirement = selectedLevel.getRequirement();
            TBEngineKt.getGlobals().getFonts().getFont32().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)Intrinsics.stringPlus((String)"Type: ", (Object)text), tx, ty);
            TBEngineKt.getGlobals().getFonts().getFont32().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)Intrinsics.stringPlus((String)"Monsters: ", (Object)selectedLevel.getMonsters()), tx, ty - 70.0f);
            TBEngineKt.getGlobals().getFonts().getFont32().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)"Boss: 1", tx, ty - 120.0f);
            TBEngineKt.getGlobals().getFonts().getFont32().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)" - drops 1 item with 'movement speed'", tx, ty - 170.0f);
            TBEngineKt.getGlobals().getFonts().getFont32().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)" - drops 3 currency items", tx, ty - 220.0f);
            TBEngineKt.getGlobals().getFonts().getFont32().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)(cleared >= requirement ? "[Space] to select" : "Requires " + requirement + " areas to be cleared"), tx, ty - 320.0f);
        }
        UiComponentsKt.getSpriteBatch().end();
        UiComponentsKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Filled);
        if (selectedLevel != null) {
            Hex hex = selectedLevel.getHex();
            List<Pair<Vector2, Vector2>> lines = this.hexLayout.drawPolygon(hex);
            UiComponentsKt.getShapeRenderer().setColor(Color.LIGHT_GRAY);
            Iterable $this$forEachIndexed$iv = lines;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $dstr$p1$p2;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair bl3 = (Pair)item$iv;
                int index = n;
                boolean bl4 = false;
                Vector2 p1 = (Vector2)$dstr$p1$p2.component1();
                Vector2 p2 = (Vector2)$dstr$p1$p2.component2();
                UiComponentsKt.getShapeRenderer().rectLine(Vector2Kt.dw(p1), Vector2Kt.dw(p2), 3.0f);
            }
            UiComponentsKt.getShapeRenderer().setColor(Color.WHITE);
        }
        UiComponentsKt.getShapeRenderer().end();
        Gdx.gl.glDisable(3042);
    }
}

