/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.loot;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.ai.LinearMoveAIComponent;
import org.veiset.kgame.engine.ecs.component.draw.SpriteGfxComponent;
import org.veiset.kgame.engine.ecs.component.loot.ItemComponent;
import org.veiset.kgame.engine.ecs.component.loot.PickableLootComponent;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.component.player.InventoryComponent;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.entity.ItemDropEntity;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.loot.PickupLootSystemKt;
import org.veiset.kgame.engine.ecs.system.player.ColoredMods;
import org.veiset.kgame.engine.ecs.system.player.InventorySystemKt;
import org.veiset.kgame.engine.input.InputKey;
import org.veiset.kgame.engine.input.InputKeyKt;
import org.veiset.kgame.engine.item.CompareResult;
import org.veiset.kgame.engine.item.Equipment;
import org.veiset.kgame.engine.item.Item;
import org.veiset.kgame.engine.item.ItemKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.TargetType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/veiset/kgame/engine/ecs/system/loot/PickupLootSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "inventories", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "itemDrops", "players", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "hoverOverItem", "entity", "equipped", "Lorg/veiset/kgame/engine/item/Equipment;", "update", "deltaTime", "", "kgame2"})
public final class PickupLootSystem
extends EntitySystem {
    private ImmutableArray<Entity> inventories;
    private ImmutableArray<Entity> itemDrops;
    private ImmutableArray<Entity> players;

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{InventoryComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.one((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.one(InventoryComponent::class.java).get())");
        this.inventories = immutableArray;
        classArray = new Class[]{ItemComponent.class, PickableLootComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(ItemComponent::class.java, PickableLootComponent::class.java, PositionComponent::class.java).get())");
        this.itemDrops = immutableArray;
        classArray = new Class[]{PlayerCharacterComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(PlayerCharacterComponent::class.java, PositionComponent::class.java).get())");
        this.players = immutableArray;
    }

    public void update(float deltaTime) {
        Object object = this.inventories;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inventories");
            throw null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)object));
        if (entity == null) {
            return;
        }
        Entity inventoryEntity = entity;
        object = (InventoryComponent)Mapper.INSTANCE.getInventory().get(inventoryEntity);
        if (object == null) {
            return;
        }
        Object inventory = object;
        ImmutableArray<Entity> immutableArray = this.players;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"players");
            throw null;
        }
        ImmutableArray<Entity> immutableArray2 = (ImmutableArray<Entity>)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableArray));
        if (immutableArray2 == null) {
            return;
        }
        ImmutableArray<Entity> player = immutableArray2;
        immutableArray2 = this.itemDrops;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemDrops");
            throw null;
        }
        Iterable $this$forEach$iv = (Iterable)immutableArray2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity itemEntity = (Entity)element$iv;
            boolean bl = false;
            Vector2 position = ((PositionComponent)Mapper.INSTANCE.getPosition().get(itemEntity)).getPos();
            SpriteGfxComponent gfx = (SpriteGfxComponent)Mapper.INSTANCE.getSpriteGfx().get(itemEntity);
            ItemComponent item = (ItemComponent)Mapper.INSTANCE.getItem().get(itemEntity);
            PickableLootComponent pickableLoot = (PickableLootComponent)Mapper.INSTANCE.getPickableLoot().get(itemEntity);
            if (Vector2Kt.pointerWithinSquare(Vector2Kt.minus(position, Vector2Kt.times(gfx.getSize(), 0.5f)), gfx.getSize()) && item.getItem() instanceof Equipment) {
                Intrinsics.checkNotNullExpressionValue((Object)itemEntity, (String)"itemEntity");
                this.hoverOverItem(itemEntity, ((InventoryComponent)inventory).getItemInSlot(((Equipment)item.getItem()).getSlot()));
                if (InputKeyKt.clicked(InputKey.PICKUP_ITEM)) {
                    pickableLoot.setClicked(true);
                    itemEntity.add((Component)new LinearMoveAIComponent(TargetType.OnScreen.INSTANCE, 0.1f, true));
                    itemEntity.add((Component)new VelocityComponent(Vector2Kt.x(0.0f, 0.0f)));
                }
            }
            if (!pickableLoot.getClicked() || !(((PositionComponent)Mapper.INSTANCE.getPosition().get(player)).getPos().dst(position) < 0.3f)) continue;
            this.getEngine().removeEntity(itemEntity);
            Item pickedUpItem = item.getItem();
            if (!(pickedUpItem instanceof Equipment)) continue;
            this.getEngine().addEntity((Entity)new ItemDropEntity(((InventoryComponent)inventory).swap((Equipment)pickedUpItem), position));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void hoverOverItem(Entity entity, Equipment equipped) {
        void $this$mapTo$iv$iv;
        Vector2 position = ((PositionComponent)Mapper.INSTANCE.getPosition().get(entity)).getPos();
        SpriteGfxComponent gfx = (SpriteGfxComponent)Mapper.INSTANCE.getSpriteGfx().get(entity);
        ItemComponent item = (ItemComponent)Mapper.INSTANCE.getItem().get(entity);
        if (!(item.getItem() instanceof Equipment)) {
            return;
        }
        List<CompareResult> stats = ItemKt.compare((Equipment)item.getItem(), equipped);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        PickupLootSystemKt.access$getShapeRenderer$p().begin(ShapeRenderer.ShapeType.Line);
        PickupLootSystemKt.access$getShapeRenderer$p().setColor(Color.BLACK);
        ShapeRenderer shapeRenderer = PickupLootSystemKt.access$getShapeRenderer$p();
        Vector2 vector2 = Vector2Kt.copy(gfx.getSize()).scl(0.5f);
        Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"gfx.size.copy().scl(0.5f)");
        ShapeRendererKt.rect((ShapeRenderer)shapeRenderer, (Vector2)Vector2Kt.dw(Vector2Kt.minus(position, vector2)), (Vector2)Vector2Kt.dw(gfx.getSize()));
        PickupLootSystemKt.access$getShapeRenderer$p().end();
        Gdx.gl.glDisable(3042);
        Iterable $this$map$iv = stats;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void stat;
            CompareResult compareResult = (CompareResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Color color = stat.getDiff() == null || Intrinsics.areEqual((Float)stat.getDiff(), (float)0.0f) ? Color.WHITE : (stat.getDiff().floatValue() > 0.0f ? Color.GREEN : Color.RED);
            String string = stat.text();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"color");
            ColoredMods coloredMods = new ColoredMods(string, color, stat.getDiff());
            collection.add(coloredMods);
        }
        List coloredMods = (List)destination$iv$iv;
        Iterable $this$sortedByDescending$iv = coloredMods;
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        InventorySystemKt.drawEquipment((Equipment)item.getItem(), CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ColoredMods it = (ColoredMods)b;
                boolean bl2 = false;
                Comparable comparable = it.getDiff();
                it = (ColoredMods)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Float f = it.getDiff();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)f);
            }
        }), Vector2Kt.plus(Vector2Kt.minus(position, Vector2Kt.times(gfx.getSize(), 0.5f)), new Vector2(0.0f, 0.5f)));
    }
}

