/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.physics;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.World;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.component.physics.SensorBodyComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.debug.ProfilerSystemKt;
import org.veiset.kgame.engine.ecs.system.physics.CollisionHandler;
import org.veiset.kgame.engine.values.ProfilerName;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\f\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/veiset/kgame/engine/ecs/system/physics/Box2dSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "RemoveBodies", "RemoveSensors", "kgame2"})
public final class Box2dSystem
extends EntitySystem {
    @NotNull
    private final World world;

    public Box2dSystem(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
    }

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{DynamicBodyComponent.class};
        engine.addEntityListener(Family.all((Class[])classArray).get(), (EntityListener)new RemoveBodies(this.world));
        classArray = new Class[]{SensorBodyComponent.class};
        engine.addEntityListener(Family.all((Class[])classArray).get(), (EntityListener)new RemoveSensors(this.world));
        this.world.setContactListener((ContactListener)new CollisionHandler(engine));
    }

    public void update(float deltaTime) {
        Engine engine = this.getEngine();
        Intrinsics.checkNotNullExpressionValue((Object)engine, (String)"engine");
        ProfilerSystemKt.profile(engine, ProfilerName.BOX2D, (Function0)new Function0<Unit>(this, deltaTime){
            final /* synthetic */ Box2dSystem this$0;
            final /* synthetic */ float $deltaTime;
            {
                this.this$0 = $receiver;
                this.$deltaTime = $deltaTime;
                super(0);
            }

            public final void invoke() {
                Box2dSystem.access$getWorld$p(this.this$0).step(this.$deltaTime, 8, 3);
            }
        });
    }

    public static final /* synthetic */ World access$getWorld$p(Box2dSystem $this) {
        return $this.world;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/veiset/kgame/engine/ecs/system/physics/Box2dSystem$RemoveBodies;", "Lcom/badlogic/ashley/core/EntityListener;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "entityAdded", "", "entity", "Lcom/badlogic/ashley/core/Entity;", "entityRemoved", "kgame2"})
    public static final class RemoveBodies
    implements EntityListener {
        @NotNull
        private final World world;

        public RemoveBodies(@NotNull World world) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            this.world = world;
        }

        public void entityAdded(@Nullable Entity entity) {
        }

        public void entityRemoved(@NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Component component = Mapper.INSTANCE.getDynamicBody().get(entity);
            Intrinsics.checkNotNull((Object)component);
            Body body = ((DynamicBodyComponent)component).getBody();
            this.world.destroyBody(body);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/veiset/kgame/engine/ecs/system/physics/Box2dSystem$RemoveSensors;", "Lcom/badlogic/ashley/core/EntityListener;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "entityAdded", "", "entity", "Lcom/badlogic/ashley/core/Entity;", "entityRemoved", "kgame2"})
    public static final class RemoveSensors
    implements EntityListener {
        @NotNull
        private final World world;

        public RemoveSensors(@NotNull World world) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            this.world = world;
        }

        public void entityAdded(@Nullable Entity entity) {
        }

        public void entityRemoved(@NotNull Entity entity) {
            Body body;
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            SensorBodyComponent sensorBodyComponent = (SensorBodyComponent)Mapper.INSTANCE.getSensorBody().get(entity);
            Body body2 = body = sensorBodyComponent == null ? null : sensorBodyComponent.getSensor();
            if (body != null) {
                this.world.destroyBody(body);
            }
        }
    }
}

