/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.physics;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.component.physics.SensorBodyComponent;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.debug.ProfilerSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.values.ProfilerName;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/veiset/kgame/engine/ecs/system/physics/VelocityPositionSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "entities", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "movingGraphics", "sensors", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class VelocityPositionSystem
extends EntitySystem {
    private ImmutableArray<Entity> entities;
    private ImmutableArray<Entity> movingGraphics;
    private ImmutableArray<Entity> sensors;

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{DynamicBodyComponent.class, VelocityComponent.class, PositionComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(DynamicBodyComponent::class.java, VelocityComponent::class.java, PositionComponent::class.java).get())");
        this.entities = immutableArray;
        classArray = new Class[]{VelocityComponent.class, PositionComponent.class};
        Family.Builder builder = Family.all((Class[])classArray);
        classArray = new Class[]{DynamicBodyComponent.class, SensorBodyComponent.class};
        immutableArray = engine.getEntitiesFor(builder.exclude(classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(VelocityComponent::class.java, PositionComponent::class.java).exclude(DynamicBodyComponent::class.java, SensorBodyComponent::class.java).get())");
        this.movingGraphics = immutableArray;
        classArray = new Class[]{SensorBodyComponent.class, VelocityComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(SensorBodyComponent::class.java, VelocityComponent::class.java, PositionComponent::class.java).get())");
        this.sensors = immutableArray;
    }

    public void update(float deltaTime) {
        Engine engine = this.getEngine();
        Intrinsics.checkNotNullExpressionValue((Object)engine, (String)"engine");
        ProfilerSystemKt.profile(engine, ProfilerName.PHYSICS, (Function0)new Function0<Unit>(this, deltaTime){
            final /* synthetic */ VelocityPositionSystem this$0;
            final /* synthetic */ float $deltaTime;
            {
                this.this$0 = $receiver;
                this.$deltaTime = $deltaTime;
                super(0);
            }

            public final void invoke() {
                Vector2 vector2;
                VelocityComponent velocity;
                PositionComponent position;
                Entity entity;
                ImmutableArray immutableArray = VelocityPositionSystem.access$getSensors$p(this.this$0);
                if (immutableArray == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sensors");
                    throw null;
                }
                Iterable $this$forEach$iv = (Iterable)immutableArray;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    entity = (Entity)element$iv;
                    boolean bl = false;
                    SensorBodyComponent sensor = (SensorBodyComponent)Mapper.INSTANCE.getSensorBody().get(entity);
                    if (sensor == null) continue;
                    position = (PositionComponent)Mapper.INSTANCE.getPosition().get(entity);
                    velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get(entity);
                    vector2 = sensor.getSensor().getPosition();
                    Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"sensor.sensor.position");
                    position.setPos(vector2);
                    sensor.getSensor().setLinearVelocity(velocity.getSpeed());
                }
                $this$forEach$iv = VelocityPositionSystem.access$getEntities$p(this.this$0);
                if ($this$forEach$iv == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"entities");
                    throw null;
                }
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    entity = (Entity)element$iv;
                    boolean bl = false;
                    DynamicBodyComponent dynamicBody = (DynamicBodyComponent)Mapper.INSTANCE.getDynamicBody().get(entity);
                    if (dynamicBody == null) continue;
                    position = (PositionComponent)Mapper.INSTANCE.getPosition().get(entity);
                    velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get(entity);
                    vector2 = dynamicBody.getBody().getPosition();
                    Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"dynamicBody.body.position");
                    position.setPos(vector2);
                    dynamicBody.getBody().setLinearVelocity(velocity.getSpeed());
                }
                $this$forEach$iv = VelocityPositionSystem.access$getMovingGraphics$p(this.this$0);
                if ($this$forEach$iv == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"movingGraphics");
                    throw null;
                }
                float f = this.$deltaTime;
                boolean $i$f$forEach2 = false;
                for (T element$iv : $this$forEach$iv) {
                    Entity entity2 = (Entity)element$iv;
                    boolean bl = false;
                    position = (PositionComponent)Mapper.INSTANCE.getPosition().get(entity2);
                    velocity = Vector2Kt.times(((VelocityComponent)Mapper.INSTANCE.getVelocity().get(entity2)).getSpeed(), f);
                    position.setPos(Vector2Kt.plus(position.getPos(), (Vector2)velocity));
                }
            }
        });
    }

    public static final /* synthetic */ ImmutableArray access$getSensors$p(VelocityPositionSystem $this) {
        return $this.sensors;
    }

    public static final /* synthetic */ ImmutableArray access$getEntities$p(VelocityPositionSystem $this) {
        return $this.entities;
    }

    public static final /* synthetic */ ImmutableArray access$getMovingGraphics$p(VelocityPositionSystem $this) {
        return $this.movingGraphics;
    }
}

