/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.player;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.ecs.component.player.InventoryComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.player.InventorySystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/veiset/kgame/engine/ecs/system/player/InventorySystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "inventories", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class InventorySystem
extends EntitySystem {
    private ImmutableArray<Entity> inventories;

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{InventoryComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.one((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.one(InventoryComponent::class.java).get())");
        this.inventories = immutableArray;
    }

    public void update(float deltaTime) {
        Object object = this.inventories;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inventories");
            throw null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)object));
        if (entity == null) {
            return;
        }
        Entity inventoryEntity = entity;
        object = (InventoryComponent)Mapper.INSTANCE.getInventory().get(inventoryEntity);
        if (object == null) {
            return;
        }
        Object inventory = object;
        float scale = 0.65f;
        float spacing2 = 0.05f;
        float gameWidth = 16.0f;
        Vector2 size = Vector2Kt.x(scale, scale);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        InventorySystemKt.access$getShapeRenderer$p().begin(ShapeRenderer.ShapeType.Filled);
        InventorySystemKt.access$getShapeRenderer$p().setColor(ColorKt.color((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f));
        ShapeRendererKt.rect((ShapeRenderer)InventorySystemKt.access$getShapeRenderer$p(), (Vector2)Vector2Kt.dw(InventorySystem.update$pos(gameWidth, scale, spacing2, 1)), (Vector2)Vector2Kt.dw(size));
        ShapeRendererKt.rect((ShapeRenderer)InventorySystemKt.access$getShapeRenderer$p(), (Vector2)Vector2Kt.dw(InventorySystem.update$pos(gameWidth, scale, spacing2, 2)), (Vector2)Vector2Kt.dw(size));
        ShapeRendererKt.rect((ShapeRenderer)InventorySystemKt.access$getShapeRenderer$p(), (Vector2)Vector2Kt.dw(InventorySystem.update$pos(gameWidth, scale, spacing2, 3)), (Vector2)Vector2Kt.dw(size));
        InventorySystemKt.access$getShapeRenderer$p().end();
        Gdx.gl.glDisable(3042);
        InventorySystemKt.access$getShapeRenderer$p().begin(ShapeRenderer.ShapeType.Line);
        InventorySystemKt.access$getShapeRenderer$p().setColor(Color.BLACK);
        ShapeRendererKt.rect((ShapeRenderer)InventorySystemKt.access$getShapeRenderer$p(), (Vector2)Vector2Kt.dw(InventorySystem.update$pos(gameWidth, scale, spacing2, 1)), (Vector2)Vector2Kt.dw(size));
        ShapeRendererKt.rect((ShapeRenderer)InventorySystemKt.access$getShapeRenderer$p(), (Vector2)Vector2Kt.dw(InventorySystem.update$pos(gameWidth, scale, spacing2, 2)), (Vector2)Vector2Kt.dw(size));
        ShapeRendererKt.rect((ShapeRenderer)InventorySystemKt.access$getShapeRenderer$p(), (Vector2)Vector2Kt.dw(InventorySystem.update$pos(gameWidth, scale, spacing2, 3)), (Vector2)Vector2Kt.dw(size));
        InventorySystemKt.access$getShapeRenderer$p().end();
        InventorySystemKt.access$getSpriteBatch$p().begin();
        Vector2 vector2 = InventorySystem.update$pos(gameWidth, scale, spacing2, 1);
        float x1 = Vector2Kt.component1(vector2);
        float y1 = Vector2Kt.component2(vector2);
        Vector2 vector22 = InventorySystem.update$pos(gameWidth, scale, spacing2, 2);
        float x2 = Vector2Kt.component1(vector22);
        float y2 = Vector2Kt.component2(vector22);
        Vector2 vector23 = InventorySystem.update$pos(gameWidth, scale, spacing2, 3);
        float x3 = Vector2Kt.component1(vector23);
        float y3 = Vector2Kt.component2(vector23);
        InventorySystemKt.access$getSpriteBatch$p().draw(((InventoryComponent)inventory).getBoots().getGfx(), x1 * 120.0f, y1 * 120.0f, scale * 120.0f, scale * 120.0f);
        InventorySystemKt.access$getSpriteBatch$p().draw(((InventoryComponent)inventory).getRing().getGfx(), x2 * 120.0f, y2 * 120.0f, size.x * 120.0f, size.y * 120.0f);
        InventorySystemKt.access$getSpriteBatch$p().draw(((InventoryComponent)inventory).getWeapon().getGfx(), x3 * 120.0f, y3 * 120.0f, size.x * 120.0f, size.y * 120.0f);
        InventorySystemKt.access$getSpriteBatch$p().end();
        if (Vector2Kt.uiPointerWithinSquare(InventorySystem.update$pos(gameWidth, scale, spacing2, 1), size)) {
            InventorySystemKt.access$drawInventoryItem(((InventoryComponent)inventory).getBoots());
            InventorySystemKt.drawTriangle(scale, spacing2, 0.15f, 1);
        }
        if (Vector2Kt.uiPointerWithinSquare(InventorySystem.update$pos(gameWidth, scale, spacing2, 2), size)) {
            InventorySystemKt.access$drawInventoryItem(((InventoryComponent)inventory).getRing());
            InventorySystemKt.drawTriangle(scale, spacing2, 0.15f, 2);
        }
        if (Vector2Kt.uiPointerWithinSquare(InventorySystem.update$pos(gameWidth, scale, spacing2, 3), size)) {
            InventorySystemKt.access$drawInventoryItem(((InventoryComponent)inventory).getWeapon());
            InventorySystemKt.drawTriangle(scale, spacing2, 0.15f, 3);
        }
    }

    private static final Vector2 update$pos(float gameWidth, float scale, float spacing2, int index) {
        float x = gameWidth - scale * (float)index - spacing2 * (float)index;
        return new Vector2(x, spacing2);
    }
}

