/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.player;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.behaviour.AnimationSpeedModifier;
import org.veiset.kgame.engine.behaviour.DynamicAnimation;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.draw.Direction;
import org.veiset.kgame.engine.ecs.component.draw.DynamicAnimationComponent;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.component.player.InventoryComponent;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.modifier.ModifierEngine;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0006H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/veiset/kgame/engine/ecs/system/player/PlayerInputSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "initDelay", "", "getInitDelay", "()F", "setInitDelay", "(F)V", "inventories", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "players", "target", "Lcom/badlogic/gdx/math/Vector2;", "getTarget", "()Lcom/badlogic/gdx/math/Vector2;", "setTarget", "(Lcom/badlogic/gdx/math/Vector2;)V", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "delta", "kgame2"})
public final class PlayerInputSystem
extends EntitySystem {
    @NotNull
    private final World world;
    @Nullable
    private Vector2 target;
    private float initDelay;
    private ImmutableArray<Entity> players;
    private ImmutableArray<Entity> inventories;

    public PlayerInputSystem(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.initDelay = 0.1f;
    }

    @Nullable
    public final Vector2 getTarget() {
        return this.target;
    }

    public final void setTarget(@Nullable Vector2 vector2) {
        this.target = vector2;
    }

    public final float getInitDelay() {
        return this.initDelay;
    }

    public final void setInitDelay(float f) {
        this.initDelay = f;
    }

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{PlayerCharacterComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.one((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.one(PlayerCharacterComponent::class.java).get())");
        this.players = immutableArray;
        classArray = new Class[]{InventoryComponent.class};
        immutableArray = engine.getEntitiesFor(Family.one((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.one(InventoryComponent::class.java).get())");
        this.inventories = immutableArray;
    }

    public void update(float delta) {
        if (this.initDelay >= 0.0f) {
            PlayerInputSystem playerInputSystem = this;
            playerInputSystem.initDelay -= delta;
            return;
        }
        Entity entity = this.players;
        if (entity == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"players");
            throw null;
        }
        Entity entity2 = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)entity));
        if (entity2 == null) {
            return;
        }
        Entity player = entity2;
        Object object = this.inventories;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inventories");
            throw null;
        }
        entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)object));
        if (entity == null) {
            return;
        }
        Entity inventoryEntity = entity;
        object = (InventoryComponent)Mapper.INSTANCE.getInventory().get(inventoryEntity);
        if (object == null) {
            return;
        }
        Object inventory = object;
        DynamicAnimationComponent animation = (DynamicAnimationComponent)Mapper.INSTANCE.getDynamicAnimation().get(player);
        DynamicAnimation playerState = animation.getDynamicAnimation();
        Vector2 position = ((PositionComponent)Mapper.INSTANCE.getPosition().get(player)).getPos();
        VelocityComponent velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get(player);
        playerState.update(delta, new AnimationSpeedModifier(0.0f, 1.0f + ModifierEngine.Attack.INSTANCE.attackSpeed(((InventoryComponent)inventory).getWeapon().getMods()), ModifierEngine.INSTANCE.speed(((InventoryComponent)inventory).getBoots().getMods(), 2.0f), 0.0f, 0.0f, 0.0f, 57, null));
        if (Gdx.input.isButtonPressed(1)) {
            Vector2 sp = MouseKt.scaledPointer();
            animation.setDirection(sp.x > position.x ? Direction.RIGHT : Direction.LEFT);
        }
        if (!(velocity.getSpeed().x == 0.0f)) {
            animation.setDirection(velocity.getSpeed().x > 0.0f ? Direction.RIGHT : Direction.LEFT);
        }
    }
}

