/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.player;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import com.badlogic.gdx.physics.box2d.Body;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.world.WorldMapBounds;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/veiset/kgame/engine/ecs/system/player/PlayerPositionBoundSystem;", "Lcom/badlogic/ashley/systems/IteratingSystem;", "worldMapBounds", "Lorg/veiset/kgame/engine/world/WorldMapBounds;", "(Lorg/veiset/kgame/engine/world/WorldMapBounds;)V", "processEntity", "", "entity", "Lcom/badlogic/ashley/core/Entity;", "deltaTime", "", "kgame2"})
public final class PlayerPositionBoundSystem
extends IteratingSystem {
    @NotNull
    private final WorldMapBounds worldMapBounds;

    public PlayerPositionBoundSystem(@NotNull WorldMapBounds worldMapBounds) {
        Intrinsics.checkNotNullParameter((Object)worldMapBounds, (String)"worldMapBounds");
        Class[] classArray = new Class[]{PlayerCharacterComponent.class};
        super(Family.all((Class[])classArray).get());
        this.worldMapBounds = worldMapBounds;
    }

    protected void processEntity(@NotNull Entity entity, float deltaTime) {
        Body body;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        DynamicBodyComponent dynamicBodyComponent = (DynamicBodyComponent)Mapper.INSTANCE.getDynamicBody().get(entity);
        Body body2 = body = dynamicBodyComponent == null ? null : dynamicBodyComponent.getBody();
        if (body == null) {
            return;
        }
        Body body3 = body;
        if (body3.getPosition().x < 1.0f) {
            body3.setTransform(Vector2Kt.x(1.0f, body3.getPosition().y), 0.0f);
        }
        if (body3.getPosition().x > this.worldMapBounds.getMapX()) {
            body3.setTransform(Vector2Kt.x(this.worldMapBounds.getMapX(), body3.getPosition().y), 0.0f);
        }
        if (body3.getPosition().y < 1.0f) {
            body3.setTransform(Vector2Kt.x(body3.getPosition().x, 1.0f), 0.0f);
        }
        if (body3.getPosition().y > this.worldMapBounds.getMapY()) {
            body3.setTransform(Vector2Kt.x(body3.getPosition().x, this.worldMapBounds.getMapY()), 0.0f);
        }
    }
}

