/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.scenario;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.camera.CameraFollowComponent;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.component.scenario.BossScenarioComponent;
import org.veiset.kgame.engine.ecs.entity.PauseEntity;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.scenario.DrawBossFrame;
import org.veiset.kgame.engine.ecs.system.scenario.ScenarioBossSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.sound.Sound;
import org.veiset.kgame.engine.world.WorldMapBounds;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/veiset/kgame/engine/ecs/system/scenario/ScenarioBossSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "worldMapBounds", "Lorg/veiset/kgame/engine/world/WorldMapBounds;", "(Lorg/veiset/kgame/engine/world/WorldMapBounds;)V", "cameraFollowEntities", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "drawBossFrame", "Lorg/veiset/kgame/engine/ecs/system/scenario/DrawBossFrame;", "getDrawBossFrame", "()Lorg/veiset/kgame/engine/ecs/system/scenario/DrawBossFrame;", "playerEntities", "scenarios", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class ScenarioBossSystem
extends EntitySystem {
    @NotNull
    private final WorldMapBounds worldMapBounds;
    private ImmutableArray<Entity> playerEntities;
    private ImmutableArray<Entity> cameraFollowEntities;
    private ImmutableArray<Entity> scenarios;
    @NotNull
    private final DrawBossFrame drawBossFrame;

    public ScenarioBossSystem(@NotNull WorldMapBounds worldMapBounds) {
        Intrinsics.checkNotNullParameter((Object)worldMapBounds, (String)"worldMapBounds");
        this.worldMapBounds = worldMapBounds;
        this.drawBossFrame = new DrawBossFrame(0.0f, 0.0f, 3, null);
    }

    @NotNull
    public final DrawBossFrame getDrawBossFrame() {
        return this.drawBossFrame;
    }

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{PositionComponent.class, PlayerCharacterComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(PositionComponent::class.java, PlayerCharacterComponent::class.java).get())");
        this.playerEntities = immutableArray;
        classArray = new Class[]{PositionComponent.class, CameraFollowComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(PositionComponent::class.java, CameraFollowComponent::class.java).get())");
        this.cameraFollowEntities = immutableArray;
        classArray = new Class[]{BossScenarioComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(BossScenarioComponent::class.java).get())");
        this.scenarios = immutableArray;
    }

    public void update(float deltaTime) {
        Entity entity = this.scenarios;
        if (entity == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scenarios");
            throw null;
        }
        Entity entity2 = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)entity));
        if (entity2 == null) {
            return;
        }
        Entity scenario = entity2;
        ImmutableArray<Entity> immutableArray = this.cameraFollowEntities;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraFollowEntities");
            throw null;
        }
        entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableArray));
        if (entity == null) {
            return;
        }
        Entity cameraFollowEntity = entity;
        CameraFollowComponent cameraFollow = (CameraFollowComponent)Mapper.INSTANCE.getCameraFollow().get(cameraFollowEntity);
        ImmutableArray<Entity> immutableArray2 = this.playerEntities;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playerEntities");
            throw null;
        }
        Entity player = (Entity)immutableArray2.first();
        BossScenarioComponent scenarioComponent = (BossScenarioComponent)Mapper.INSTANCE.getBossScenarioComponent().get(scenario);
        Entity boss = scenarioComponent.getTarget();
        Vector2 bossPos = ((PositionComponent)Mapper.INSTANCE.getPosition().get(boss)).getPos();
        Vector2 playerPos = ((PositionComponent)Mapper.INSTANCE.getPosition().get(player)).getPos();
        if (scenarioComponent.getStep() == 0 && scenarioComponent.getTrigger().inRange(bossPos, playerPos, (Camera)ScenarioBossSystemKt.access$getCamera$p())) {
            Log.INSTANCE.info("Scenario step 1");
            this.drawBossFrame.reset();
            scenarioComponent.setStep(1);
            Sound.INSTANCE.getZombieGroan().get().play(EngineConfig.Volume.INSTANCE.getEFFECTS() * EngineConfig.Volume.INSTANCE.getMASTER(), 0.6f, 0.0f);
        } else {
            Vector3 vector3 = ScenarioBossSystemKt.access$getCamera$p().position;
            Intrinsics.checkNotNullExpressionValue((Object)vector3, (String)"camera.position");
            Vector2 cameraPos = Vector2Kt.gfxToWorld(Vector2Kt.v2(vector3));
            if (scenarioComponent.getStep() == 1 && (cameraPos.dst(bossPos) <= cameraFollow.getNoFollow() || this.worldMapBounds.isOnBound(cameraPos))) {
                Log.INSTANCE.info("Scenario step 2");
                scenarioComponent.setStep(2);
            } else if (scenarioComponent.getStep() == 2 && Gdx.input.isKeyJustPressed(62) && this.drawBossFrame.fadeComplete()) {
                Log.INSTANCE.info("Scenario step 3");
                scenarioComponent.setStep(3);
            } else if (scenarioComponent.getStep() == 3 && (cameraPos.dst(playerPos) <= cameraFollow.getNoFollow() || this.worldMapBounds.isOnBound(cameraPos))) {
                Log.INSTANCE.info("Scenario step 4");
                scenarioComponent.setStep(4);
            }
        }
        if (scenarioComponent.getStep() == 1) {
            this.getEngine().addEntity((Entity)new PauseEntity(true));
            cameraFollowEntity.remove(CameraFollowComponent.class);
            boss.add((Component)new CameraFollowComponent(0.12f, 10.0f, 15.0f, 0.0f, 8, null));
        }
        if (scenarioComponent.getStep() == 2) {
            this.drawBossFrame.draw(deltaTime, boss, scenarioComponent.getText());
        }
        if (scenarioComponent.getStep() == 3) {
            player.add((Component)new CameraFollowComponent(0.2f, 10.0f, 15.0f, 0.0f, 8, null));
            boss.remove(CameraFollowComponent.class);
        }
        if (scenarioComponent.getStep() == 4) {
            scenario.remove(BossScenarioComponent.class);
            player.add((Component)new CameraFollowComponent(0.0f, 0.0f, 0.0f, 0.0f, 15, null));
            this.getEngine().addEntity((Entity)new PauseEntity(false));
        }
    }
}

