/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.math;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.math.Hex;
import org.veiset.kgame.engine.math.HexOrientation;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0015J\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0005J\u0006\u0010!\u001a\u00020\u0005J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006$"}, d2={"Lorg/veiset/kgame/engine/math/HexLayout;", "", "orientation", "Lorg/veiset/kgame/engine/math/HexOrientation;", "size", "Lcom/badlogic/gdx/math/Vector2;", "origin", "(Lorg/veiset/kgame/engine/math/HexOrientation;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;)V", "getOrientation", "()Lorg/veiset/kgame/engine/math/HexOrientation;", "getOrigin", "()Lcom/badlogic/gdx/math/Vector2;", "getSize", "component1", "component2", "component3", "copy", "drawPolygon", "", "Lkotlin/Pair;", "hex", "Lorg/veiset/kgame/engine/math/Hex;", "equals", "", "other", "hashCode", "", "hexCornerOffset", "corner", "hexToPixel", "h", "pixelToHex", "p", "spriteSize", "toString", "", "kgame2"})
public final class HexLayout {
    @NotNull
    private final HexOrientation orientation;
    @NotNull
    private final Vector2 size;
    @NotNull
    private final Vector2 origin;

    public HexLayout(@NotNull HexOrientation orientation, @NotNull Vector2 size, @NotNull Vector2 origin) {
        Intrinsics.checkNotNullParameter((Object)orientation, (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        this.orientation = orientation;
        this.size = size;
        this.origin = origin;
    }

    @NotNull
    public final HexOrientation getOrientation() {
        return this.orientation;
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }

    @NotNull
    public final Vector2 getOrigin() {
        return this.origin;
    }

    @NotNull
    public final Vector2 hexToPixel(@NotNull Hex h) {
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        HexOrientation m = this.orientation;
        float x = (m.getF0() * (float)h.getQ() + m.getF1() * (float)h.getR()) * this.size.x;
        float y = (m.getF2() * (float)h.getQ() + m.getF3() * (float)h.getR()) * this.size.y;
        return new Vector2(x + this.origin.x, y + this.origin.y);
    }

    @NotNull
    public final Hex pixelToHex(@NotNull Vector2 p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        HexOrientation m = this.orientation;
        Vector2 v = new Vector2((p.x - this.origin.x) / this.size.x, (p.y - this.origin.y) / this.size.y);
        float q = m.getB0() * v.x + m.getB1() * v.y;
        float r = m.getB2() * v.x + m.getB3() * v.y;
        float s = -q - r;
        boolean bl = false;
        int qi = (int)Math.rint(q);
        boolean bl2 = false;
        int ri = (int)Math.rint(r);
        boolean bl3 = false;
        int si = (int)Math.rint(s);
        float f = (float)qi - q;
        boolean bl4 = false;
        float qdiff = Math.abs(f);
        float f2 = (float)ri - r;
        boolean bl5 = false;
        float rdiff = Math.abs(f2);
        float f3 = (float)si - s;
        boolean bl6 = false;
        float sdiff = Math.abs(f3);
        return qdiff > rdiff && qdiff > sdiff ? new Hex(-ri - si, ri) : (rdiff > sdiff ? new Hex(qi, -qi - si) : new Hex(qi, ri));
    }

    @NotNull
    public final Vector2 spriteSize() {
        float x = this.hexCornerOffset((int)5).x - this.hexCornerOffset((int)1).x;
        float y = this.hexCornerOffset((int)0).y - this.hexCornerOffset((int)3).y;
        Vector2 vector2 = new Vector2(x, y).scl(2.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"Vector2(x, y).scl(2f)");
        return vector2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Vector2, Vector2>> drawPolygon(@NotNull Hex hex) {
        Vector2 vector2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        Vector2 center = this.hexToPixel(hex);
        Iterable $this$map$iv = (Iterable)new IntRange(0, 5);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            vector2 = this.hexCornerOffset((int)it);
            collection.add(vector2);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void offset;
            Vector2 it = (Vector2)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            vector2 = new Vector2(center.x + offset.x, center.y + offset.y);
            collection.add(vector2);
        }
        List points = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)CollectionsKt.zipWithNext((Iterable)points), (Iterable)CollectionsKt.listOf((Object)new Pair(points.get(5), points.get(0))));
    }

    private final Vector2 hexCornerOffset(int corner) {
        Vector2 size = this.size;
        double angle = Math.PI * 2 * (double)(this.orientation.getStartAngle() + (float)corner) / (double)6;
        boolean bl = false;
        bl = false;
        return new Vector2(size.x * (float)Math.cos(angle), size.y * (float)Math.sin(angle));
    }

    @NotNull
    public final HexOrientation component1() {
        return this.orientation;
    }

    @NotNull
    public final Vector2 component2() {
        return this.size;
    }

    @NotNull
    public final Vector2 component3() {
        return this.origin;
    }

    @NotNull
    public final HexLayout copy(@NotNull HexOrientation orientation, @NotNull Vector2 size, @NotNull Vector2 origin) {
        Intrinsics.checkNotNullParameter((Object)orientation, (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        return new HexLayout(orientation, size, origin);
    }

    public static /* synthetic */ HexLayout copy$default(HexLayout hexLayout, HexOrientation hexOrientation, Vector2 vector2, Vector2 vector22, int n, Object object) {
        if ((n & 1) != 0) {
            hexOrientation = hexLayout.orientation;
        }
        if ((n & 2) != 0) {
            vector2 = hexLayout.size;
        }
        if ((n & 4) != 0) {
            vector22 = hexLayout.origin;
        }
        return hexLayout.copy(hexOrientation, vector2, vector22);
    }

    @NotNull
    public String toString() {
        return "HexLayout(orientation=" + this.orientation + ", size=" + this.size + ", origin=" + this.origin + ')';
    }

    public int hashCode() {
        int result = this.orientation.hashCode();
        result = result * 31 + this.size.hashCode();
        result = result * 31 + this.origin.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HexLayout)) {
            return false;
        }
        HexLayout hexLayout = (HexLayout)other;
        if (!Intrinsics.areEqual((Object)this.orientation, (Object)hexLayout.orientation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.size, (Object)hexLayout.size)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.origin, (Object)hexLayout.origin);
    }
}

