/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ktx.box2d.WorldsKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.GameModule;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.system.graphics.DrawSystem;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.state.GameState;
import org.veiset.kgame.engine.storage.Tag;
import org.veiset.kgame.engine.storage.TextureStore;
import org.veiset.kgame.engine.tools.editor.area.AreaData;
import org.veiset.kgame.engine.tools.editor.area.AreaEditor;
import org.veiset.kgame.engine.tools.editor.area.AreaEditorConfig;
import org.veiset.kgame.engine.tools.editor.area.AreaEditorKt;
import org.veiset.kgame.engine.tools.editor.area.AreaEntity;
import org.veiset.kgame.engine.tools.editor.area.AreaEntityData;
import org.veiset.kgame.engine.tools.editor.area.AreaFileBrowser;
import org.veiset.kgame.engine.tools.editor.area.AreaResource;
import org.veiset.kgame.engine.tools.editor.area.BaseEntityData;
import org.veiset.kgame.engine.tools.editor.area.CollisionEntity;
import org.veiset.kgame.engine.tools.editor.area.CollisionEntityData;
import org.veiset.kgame.engine.tools.editor.area.EntityType;
import org.veiset.kgame.engine.tools.editor.area.GraphicEntity;
import org.veiset.kgame.engine.tools.editor.area.GraphicEntityData;
import org.veiset.kgame.engine.tools.editor.area.TextInputHandler;
import org.veiset.kgame.engine.tools.editor.area.components.AreaEntityEditor;
import org.veiset.kgame.engine.tools.editor.area.components.PlacementPreviewer;
import org.veiset.kgame.engine.tools.editor.area.components.SceneContainer;
import org.veiset.kgame.engine.tools.editor.area.components.SceneEntitySelector;
import org.veiset.kgame.engine.tools.runner.GamePreviewModule;
import org.veiset.kgame.engine.tools.ui.UiComponent;
import org.veiset.kgame.engine.tools.ui.UiComponentsKt;
import org.veiset.kgame.engine.tools.ui.components.Button;
import org.veiset.kgame.engine.tools.ui.components.CheckBox;
import org.veiset.kgame.engine.tools.ui.components.Dropdown;
import org.veiset.kgame.engine.tools.ui.components.IconList;
import org.veiset.kgame.engine.tools.ui.components.InputField;
import org.veiset.kgame.engine.tools.ui.components.TextSelectList;
import org.veiset.kgame.module.GameWorldModule;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001f\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u00020;H\u0002J\u0012\u0010<\u001a\u0002092\b\u0010=\u001a\u0004\u0018\u00010>H\u0002J\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020.032\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A03H\u0002J\b\u0010B\u001a\u00020;H\u0002J\b\u0010C\u001a\u000209H\u0002J\b\u0010D\u001a\u000209H\u0002J\b\u0010E\u001a\u000209H\u0002J\b\u0010F\u001a\u000209H\u0002J\u0010\u0010G\u001a\u0002092\u0006\u0010H\u001a\u00020.H\u0002J\b\u0010I\u001a\u00020;H\u0002J\b\u0010J\u001a\u00020;H\u0002J\b\u0010K\u001a\u00020;H\u0002J\u0010\u0010L\u001a\u0002092\u0006\u0010M\u001a\u00020\u000fH\u0002J\b\u0010N\u001a\u00020;H\u0002J\b\u0010O\u001a\u000209H\u0002J\b\u0010P\u001a\u00020;H\u0002J\b\u0010Q\u001a\u00020;H\u0002J\b\u0010R\u001a\u00020\u0001H\u0016J\u0010\u0010S\u001a\u0002092\u0006\u0010H\u001a\u00020.H\u0002J\b\u0010T\u001a\u00020;H\u0002J\b\u0010U\u001a\u00020;H\u0002J\b\u0010V\u001a\u00020;H\u0002J\b\u0010W\u001a\u000209H\u0016J\b\u0010X\u001a\u00020;H\u0002J\b\u0010Y\u001a\u000209H\u0016J\b\u0010Z\u001a\u00020;H\u0002J\u0010\u0010[\u001a\u0002092\u0006\u0010\\\u001a\u00020\u0013H\u0016J\u0012\u0010]\u001a\u0002092\b\u0010/\u001a\u0004\u0018\u00010.H\u0002J\f\u0010^\u001a\u00020.*\u00020.H\u0002J\f\u0010_\u001a\u00020A*\u00020.H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020403X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020403X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/AreaEditor;", "Lorg/veiset/kgame/engine/GameModule;", "engine", "Lcom/badlogic/ashley/core/Engine;", "areaData", "Lorg/veiset/kgame/engine/tools/editor/area/AreaData;", "config", "Lorg/veiset/kgame/engine/tools/editor/area/AreaEditorConfig;", "(Lcom/badlogic/ashley/core/Engine;Lorg/veiset/kgame/engine/tools/editor/area/AreaData;Lorg/veiset/kgame/engine/tools/editor/area/AreaEditorConfig;)V", "areaEntityEditor", "Lorg/veiset/kgame/engine/tools/editor/area/components/AreaEntityEditor;", "areaResource", "Lorg/veiset/kgame/engine/tools/editor/area/AreaResource;", "backgroundSelector", "Lorg/veiset/kgame/engine/tools/ui/components/Dropdown;", "", "getConfig", "()Lorg/veiset/kgame/engine/tools/editor/area/AreaEditorConfig;", "defaultScale", "", "displayBoundingBoxCheckbox", "Lorg/veiset/kgame/engine/tools/ui/components/CheckBox;", "displayGridCheckbox", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "entityTypeSelector", "Lorg/veiset/kgame/engine/tools/editor/area/EntityType;", "filenameInputField", "Lorg/veiset/kgame/engine/tools/ui/components/InputField;", "iconSelector", "Lorg/veiset/kgame/engine/tools/ui/components/IconList;", "inputHandler", "Lorg/veiset/kgame/engine/tools/editor/area/TextInputHandler;", "loadButton", "Lorg/veiset/kgame/engine/tools/ui/components/Button;", "newButton", "placementPreviewer", "Lorg/veiset/kgame/engine/tools/editor/area/components/PlacementPreviewer;", "runButton", "saveButton", "scene", "Lorg/veiset/kgame/engine/tools/editor/area/components/SceneContainer;", "sceneEntitySelector", "Lorg/veiset/kgame/engine/tools/editor/area/components/SceneEntitySelector;", "sceneItemsList", "Lorg/veiset/kgame/engine/tools/ui/components/TextSelectList;", "Lorg/veiset/kgame/engine/tools/editor/area/AreaEntity;", "selectedEntity", "tagInputField", "textureSearchInputField", "uiComponentGraphicEntity", "", "Lorg/veiset/kgame/engine/tools/ui/UiComponent;", "uiComponents", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "addCollisionEntity", "", "addCollisionEntityPressed", "", "addSelectedIconToScene", "selected", "Lorg/veiset/kgame/engine/storage/TextureStore$TextureMeta;", "dataEntitesToEntity", "entities", "Lorg/veiset/kgame/engine/tools/editor/area/AreaEntityData;", "deleteKeyPressed", "draw", "drawBoundingBox", "drawCollisionBoxes", "drawSaveInfo", "duplicateEntity", "entity", "duplicateKeyPressed", "findTextureSelected", "hasSelectedEntity", "loadFromFile", "file", "loadKeyPressed", "logic", "newButtonHotkeyPressed", "nextEntityType", "nextState", "removeEntity", "runButtonHotkeyPressed", "saveKeyPressed", "selectedIconPlacedInScene", "setup", "tabClicked", "teardown", "toggleBoundingBox", "update", "delta", "userInput", "deepCopy", "toDataEntity", "kgame2"})
public final class AreaEditor
implements GameModule {
    @NotNull
    private final Engine engine;
    @NotNull
    private final AreaEditorConfig config;
    @NotNull
    private final World world;
    @NotNull
    private final SceneContainer scene;
    @Nullable
    private AreaEntity selectedEntity;
    @NotNull
    private final AreaEntityEditor areaEntityEditor;
    @NotNull
    private final SceneEntitySelector sceneEntitySelector;
    private float defaultScale;
    @NotNull
    private final PlacementPreviewer placementPreviewer;
    @NotNull
    private final AreaResource areaResource;
    @NotNull
    private final InputField textureSearchInputField;
    @NotNull
    private final Dropdown<EntityType> entityTypeSelector;
    @NotNull
    private final Dropdown<String> backgroundSelector;
    @NotNull
    private final CheckBox displayGridCheckbox;
    @NotNull
    private final CheckBox displayBoundingBoxCheckbox;
    @NotNull
    private final TextSelectList<AreaEntity> sceneItemsList;
    @NotNull
    private final IconList iconSelector;
    @NotNull
    private final Button saveButton;
    @NotNull
    private final Button newButton;
    @NotNull
    private final Button loadButton;
    @NotNull
    private final Button runButton;
    @NotNull
    private final InputField filenameInputField;
    @NotNull
    private final InputField tagInputField;
    @NotNull
    private final List<UiComponent> uiComponents;
    @NotNull
    private final List<UiComponent> uiComponentGraphicEntity;
    @NotNull
    private final TextInputHandler inputHandler;

    public AreaEditor(@NotNull Engine engine, @NotNull AreaData areaData, @NotNull AreaEditorConfig config) {
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)areaData, (String)"areaData");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.engine = engine;
        this.config = config;
        Object object = WorldsKt.createWorld$default(null, (boolean)false, (int)3, null);
        boolean bl = false;
        boolean bl2 = false;
        Object[] objectArray = object;
        AreaEditor areaEditor = this;
        boolean bl3 = false;
        Log.INSTANCE.debug("GameWorldModule Loaded World");
        Unit unit = Unit.INSTANCE;
        areaEditor.world = object;
        this.scene = new SceneContainer(this.getEngine(), CollectionsKt.toMutableList((Collection)this.dataEntitesToEntity(areaData.getEntities())));
        this.areaEntityEditor = new AreaEntityEditor();
        this.sceneEntitySelector = new SceneEntitySelector(this.scene);
        this.defaultScale = 2.0f;
        this.placementPreviewer = new PlacementPreviewer(this.defaultScale);
        this.areaResource = new AreaResource("area");
        this.textureSearchInputField = new InputField(Vector2Kt.x(0.05f, 8.55f), Vector2Kt.x(2.9f, 0.4f), "");
        this.entityTypeSelector = new Dropdown(Vector2Kt.x(3.1f, 8.65f), ArraysKt.toList((Object[])EntityType.values()), this.config.getEntityType().ordinal(), 0.0f, entityTypeSelector.1.INSTANCE, 8, null);
        object = new String[]{"None", "Forest", "Noise", "Bleak"};
        this.backgroundSelector = new Dropdown(Vector2Kt.x(4.6f, 8.65f), CollectionsKt.listOf((Object[])object), 3, 0.0f, null, 24, null);
        this.displayGridCheckbox = new CheckBox(Vector2Kt.x(6.2f, 8.65f), "Display Grid", false);
        this.displayBoundingBoxCheckbox = new CheckBox(Vector2Kt.x(7.55f, 8.65f), "Bounding box", false);
        this.sceneItemsList = new TextSelectList(Vector2Kt.x(0.05f, 0.05f), Vector2Kt.x(2.9f, 4.0f), CollectionsKt.emptyList(), null, sceneItemsList.1.INSTANCE, 8, null);
        this.iconSelector = new IconList(Vector2Kt.x(0.05f, 8.0f), Vector2Kt.x(0.497f, 0.497f), 6, 9, CollectionsKt.toList((Iterable)AreaEditorKt.access$getTextures$p().values()));
        this.saveButton = new Button(Vector2Kt.x(9.1f, 8.63f), "Save");
        this.newButton = new Button(Vector2Kt.x(10.25f, 8.63f), "New");
        this.loadButton = new Button(Vector2Kt.x(10.85f, 8.63f), "Load");
        this.runButton = new Button(Vector2Kt.x(12.1f, 8.63f), "Run Test");
        this.filenameInputField = new InputField(Vector2Kt.x(13.7f, 8.61f), Vector2Kt.x(2.2f, 0.3f), areaData.getName());
        this.tagInputField = new InputField(Vector2Kt.x(13.7f, 8.25f), Vector2Kt.x(2.2f, 0.3f), CollectionsKt.joinToString$default((Iterable)areaData.getTags(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        object = new UiComponent[]{this.displayGridCheckbox, this.entityTypeSelector, this.backgroundSelector, this.displayBoundingBoxCheckbox, this.sceneItemsList, this.runButton, this.saveButton, this.newButton, this.loadButton, this.filenameInputField, this.tagInputField};
        this.uiComponents = CollectionsKt.listOf((Object[])object);
        object = new UiComponent[]{this.textureSearchInputField, this.iconSelector};
        this.uiComponentGraphicEntity = CollectionsKt.listOf((Object[])object);
        object = this.uiComponents;
        areaEditor = this;
        boolean $i$f$filterIsInstance = false;
        void var6_8 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof InputField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        $this$filterIsInstance$iv = this.uiComponentGraphicEntity;
        collection = collection;
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof InputField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        $this$filterIsInstance$iv = this.areaEntityEditor.getInputs();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof InputField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list = (List)destination$iv$iv;
        float f = 0.25f;
        CheckBox checkBox = this.displayGridCheckbox;
        AreaEntity areaEntity = null;
        IconList iconList = this.iconSelector;
        List list2 = CollectionsKt.plus((Collection)collection, (Iterable)list);
        areaEditor.inputHandler = new TextInputHandler(list2, iconList, areaEntity, checkBox, f);
        OrthographicCamera camera = TBEngineKt.getGlobals().getDrawGfx().getCamera();
        camera.position.set(0.0f, 0.0f, 0.0f);
        camera.update();
        TBEngineKt.getGlobals().getDrawGfx().getShapeRenderer().setProjectionMatrix(camera.combined);
        TBEngineKt.getGlobals().getDrawGfx().getSpriteBatch().setProjectionMatrix(camera.combined);
        this.getEngine().addSystem((EntitySystem)new DrawSystem(null, 1, null));
        Iterable $this$forEach$iv = this.scene.getItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AreaEntity it = (AreaEntity)element$iv;
            boolean bl4 = false;
            this.getEngine().addEntity(it.getEntity());
        }
    }

    public /* synthetic */ AreaEditor(Engine engine, AreaData areaData, AreaEditorConfig areaEditorConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            areaData = new AreaData("New Area", CollectionsKt.emptyList(), Vector2Kt.x(0.0f, 0.0f), Vector2Kt.x(0.0f, 0.0f), Vector2Kt.x(0.0f, 0.0f), CollectionsKt.emptyList());
        }
        if ((n & 4) != 0) {
            areaEditorConfig = new AreaEditorConfig(EntityType.GRAPHICS);
        }
        this(engine, areaData, areaEditorConfig);
    }

    @Override
    @NotNull
    public Engine getEngine() {
        return this.engine;
    }

    @NotNull
    public final AreaEditorConfig getConfig() {
        return this.config;
    }

    private final void drawSaveInfo() {
        AreaEditorKt.access$getSpriteBatch$p().begin();
        UiComponentsKt.getFont().setColor(Color.WHITE);
        UiComponentsKt.getFont().draw((Batch)AreaEditorKt.access$getSpriteBatch$p(), (CharSequence)"File:", 1572.0f, 1056.0f);
        UiComponentsKt.getFont().draw((Batch)AreaEditorKt.access$getSpriteBatch$p(), (CharSequence)"Tags:", 1572.0f, 1020.0f);
        AreaEditorKt.access$getSpriteBatch$p().end();
    }

    @Override
    public void setup() {
        EngineConfig.Debug.INSTANCE.setPROFILER(false);
        EngineConfig.Performance.INSTANCE.setDRAW_OUTSIDE_VIEWPORT(true);
    }

    @Override
    public void teardown() {
        EngineConfig.Debug.INSTANCE.setPROFILER(true);
        EngineConfig.Performance.INSTANCE.setDRAW_OUTSIDE_VIEWPORT(false);
    }

    @Override
    public void update(float delta) {
        this.draw();
        this.logic();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public GameModule nextState() {
        if (this.runButton.getClicked()) {
            Collection<AreaEntityData> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv2;
            Engine e = new Engine();
            World world = WorldsKt.createWorld$default(null, (boolean)false, (int)3, null);
            Iterable $this$forEach$iv = this.scene.getItems();
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                AreaEntity it = (AreaEntity)element$iv2;
                boolean bl = false;
                Log.INSTANCE.info(Intrinsics.stringPlus((String)"Added entity ", (Object)it));
                Vector2 gameWorldPos = Vector2Kt.plus(Vector2Kt.copy(it.getBase().getPosition()), EngineConfig.Game.INSTANCE.getPlayerStartPos());
                if (it instanceof GraphicEntity) {
                    e.addEntity(GraphicEntity.copy$default((GraphicEntity)it, BaseEntityData.copy$default(it.getBase(), gameWorldPos, null, false, null, 14, null), null, null, 6, null).getEntity());
                }
                if (!(it instanceof CollisionEntity)) continue;
                BaseEntityData baseEntityData = BaseEntityData.copy$default(it.getBase(), gameWorldPos, null, false, null, 14, null);
                e.addEntity(((CollisionEntity)it).copy(world, baseEntityData).getEntity());
            }
            SceneContainer.BoundingBox boundingBox = this.scene.boundingBox();
            SceneContainer.BoundingBox gridBox = SceneContainer.gridBox$default(this.scene, 0.0f, 1, null);
            element$iv2 = new String[]{","};
            List list = StringsKt.split$default((CharSequence)this.tagInputField.getText(), element$iv2, (boolean)false, (int)0, (int)6, null);
            element$iv2 = this.scene.getItems();
            Vector2 vector2 = gridBox.getSize();
            Vector2 vector22 = boundingBox.getSize();
            Vector2 vector23 = boundingBox.getPos();
            List list2 = list;
            String string = this.filenameInputField.getText();
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AreaEntity areaEntity = (AreaEntity)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                AreaEntityData areaEntityData = this.toDataEntity((AreaEntity)it);
                collection.add(areaEntityData);
            }
            Collection<AreaEntityData> collection2 = collection = (List)destination$iv$iv;
            Vector2 vector24 = vector2;
            Vector2 vector25 = vector22;
            Vector2 vector26 = vector23;
            List list3 = list2;
            String string2 = string;
            AreaData areaData = new AreaData(string2, list3, vector26, vector25, vector24, (List<? extends AreaEntityData>)collection2);
            AreaEditorConfig initConfig = new AreaEditorConfig(this.entityTypeSelector.selectedOption());
            return new GamePreviewModule<AreaData>(new Engine(), (Function2)new Function2<Engine, AreaData, GameModule>(initConfig){
                final /* synthetic */ AreaEditorConfig $initConfig;
                {
                    this.$initConfig = $initConfig;
                    super(2);
                }

                @NotNull
                public final GameModule invoke(@NotNull Engine engine, @NotNull AreaData data) {
                    Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    return new AreaEditor(engine, data, this.$initConfig);
                }
            }, new GameWorldModule(e, world, new GameState(null, null, null, null, 15, null)), areaData);
        }
        if (this.newButton.getClicked() || this.newButtonHotkeyPressed()) {
            return new AreaEditor(new Engine(), null, this.config, 2, null);
        }
        if (this.loadButton.getClicked()) {
            return new AreaFileBrowser(this.getEngine(), this);
        }
        return this;
    }

    private final void draw() {
        UiComponent p0;
        AreaEditorKt.access$drawBackgroundTiles(this.backgroundSelector.selectedOption());
        this.getEngine().update(Gdx.graphics.getDeltaTime());
        if (this.iconSelector.getSelected() != null) {
            TextureStore.TextureMeta textureMeta = this.iconSelector.getSelected();
            Intrinsics.checkNotNull((Object)textureMeta);
            this.placementPreviewer.draw(textureMeta);
        }
        AreaEditorKt.access$drawUiAreas();
        if (this.displayGridCheckbox.getChecked()) {
            AreaEditorKt.access$drawGrid();
        }
        AreaEditorKt.drawViewBox();
        Iterable $this$forEach$iv = this.uiComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (UiComponent)element$iv;
            boolean bl = false;
            p0.draw();
        }
        if (this.entityTypeSelector.selectedOption() == EntityType.GRAPHICS) {
            $this$forEach$iv = this.uiComponentGraphicEntity;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (UiComponent)element$iv;
                boolean bl = false;
                p0.draw();
            }
        }
        this.drawSaveInfo();
        if (this.entityTypeSelector.selectedOption() == EntityType.COLLISION) {
            this.drawCollisionBoxes();
        }
        if (this.selectedEntity != null && this.selectedEntity instanceof GraphicEntity) {
            AreaEntity areaEntity = this.selectedEntity;
            if (areaEntity == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.tools.editor.area.GraphicEntity");
            }
            this.areaEntityEditor.draw((GraphicEntity)areaEntity);
        }
        this.sceneEntitySelector.drawBoxAroundSelected(this.selectedEntity);
        if (this.displayBoundingBoxCheckbox.getChecked()) {
            this.drawBoundingBox();
        }
    }

    private final void drawBoundingBox() {
        SceneContainer.BoundingBox box = this.scene.boundingBox();
        SceneContainer.BoundingBox gridBox = SceneContainer.gridBox$default(this.scene, 0.0f, 1, null);
        float gridSize = 0.53333336f;
        ShapeRenderer sr = TBEngineKt.getGlobals().getDrawGfx().getShapeRenderer();
        sr.begin(ShapeRenderer.ShapeType.Line);
        sr.setColor(Color.ORANGE);
        ShapeRendererKt.rect((ShapeRenderer)sr, (Vector2)Vector2Kt.minus(Vector2Kt.dw(box.getPos()), new Vector2(gridSize, gridSize)), (Vector2)Vector2Kt.plus(Vector2Kt.dw(box.getSize()), new Vector2(gridSize * 2.0f, gridSize * 2.0f)));
        sr.setColor(Color.BROWN);
        Vector2 vector2 = Vector2Kt.minus(Vector2Kt.dw(gridBox.getPos()), new Vector2(gridSize, gridSize));
        Vector2 vector22 = Vector2Kt.dw(gridBox.getSize()).scl(0.53333336f);
        Intrinsics.checkNotNullExpressionValue((Object)vector22, (String)"gridBox.size.dw().scl(EngineConfig.Engine.gridSize)");
        ShapeRendererKt.rect((ShapeRenderer)sr, (Vector2)vector2, (Vector2)Vector2Kt.plus(vector22, new Vector2(gridSize * 2.0f, gridSize * 2.0f)));
        sr.end();
    }

    /*
     * WARNING - void declaration
     */
    private final void drawCollisionBoxes() {
        void $this$filterIsInstanceTo$iv$iv;
        ShapeRenderer gameShapeRenderer = TBEngineKt.getGlobals().getDrawGfx().getShapeRenderer();
        gameShapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        gameShapeRenderer.setColor(Color.BLUE);
        Iterable $this$filterIsInstance$iv = this.scene.getItems();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CollisionEntity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CollisionEntity it = (CollisionEntity)element$iv;
            boolean bl = false;
            Vector2 vector2 = it.getBase().getPosition();
            Vector2 vector22 = Vector2Kt.copy(it.getBase().getSize()).scl(0.5f);
            Intrinsics.checkNotNullExpressionValue((Object)vector22, (String)"it.base.size.copy().scl(0.5f)");
            ShapeRendererKt.rect((ShapeRenderer)gameShapeRenderer, (Vector2)Vector2Kt.dw(Vector2Kt.minus(vector2, vector22)), (Vector2)Vector2Kt.dw(it.getBase().getSize()));
        }
        gameShapeRenderer.end();
    }

    private final void logic() {
        UiComponent p0;
        this.iconSelector.setItems(AreaEditorKt.query(AreaEditorKt.access$getTextures$p(), this.textureSearchInputField.getText()));
        this.sceneItemsList.setOptions(this.scene.areaEntities(this.entityTypeSelector.selectedOption()));
        this.inputHandler.setSceneSelected(this.selectedEntity);
        if (this.iconSelector.getSelected() == null && AreaEditorKt.isInsideScene() && (UiComponentsKt.leftClick() || UiComponentsKt.rightClick())) {
            this.sceneItemsList.select(this.sceneEntitySelector.select(this.entityTypeSelector.selectedOption(), this.sceneItemsList.getSelected()));
        }
        this.selectedEntity = this.sceneItemsList.getSelected();
        if (this.iconSelector.justClicked()) {
            this.selectedEntity = null;
        }
        Iterable $this$forEach$iv = this.uiComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (UiComponent)element$iv;
            boolean bl = false;
            p0.update();
        }
        if (this.entityTypeSelector.selectedOption() == EntityType.GRAPHICS) {
            $this$forEach$iv = this.uiComponentGraphicEntity;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (UiComponent)element$iv;
                boolean bl = false;
                p0.update();
            }
        }
        if (this.selectedEntity != null && this.selectedEntity instanceof GraphicEntity) {
            AreaEntity areaEntity = this.selectedEntity;
            if (areaEntity == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.tools.editor.area.GraphicEntity");
            }
            this.areaEntityEditor.update((GraphicEntity)areaEntity);
        }
        this.userInput(this.selectedEntity);
    }

    private final void userInput(AreaEntity selectedEntity) {
        InputField it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        if (this.findTextureSelected()) {
            if (!this.textureSearchInputField.getSelected()) {
                $this$forEach$iv = this.inputHandler.getInputFields();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (InputField)element$iv;
                    boolean bl = false;
                    it.setSelected(false);
                }
            }
            this.textureSearchInputField.setSelected(!this.textureSearchInputField.getSelected());
        }
        if (this.selectedIconPlacedInScene()) {
            this.addSelectedIconToScene(this.iconSelector.getSelected());
        }
        if (this.runButtonHotkeyPressed()) {
            this.runButton.setClicked(true);
        }
        if (this.toggleBoundingBox()) {
            this.displayBoundingBoxCheckbox.setChecked(!this.displayBoundingBoxCheckbox.getChecked());
        }
        if (this.saveKeyPressed()) {
            if (!this.filenameInputField.getSelected()) {
                $this$forEach$iv = this.inputHandler.getInputFields();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (InputField)element$iv;
                    boolean bl = false;
                    it.setSelected(false);
                }
            }
            this.filenameInputField.setSelected(!this.filenameInputField.getSelected());
        }
        if (this.saveButton.getClicked() || (this.filenameInputField.getSelected() || this.tagInputField.getSelected()) && UiComponentsKt.enterClick()) {
            this.filenameInputField.setSelected(false);
            this.tagInputField.setSelected(false);
            String[] stringArray = new String[]{","};
            this.areaResource.save(this.scene, this.filenameInputField.getText(), StringsKt.split$default((CharSequence)this.tagInputField.getText(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        if (this.tabClicked() && this.filenameInputField.getSelected()) {
            this.filenameInputField.setSelected(false);
            this.tagInputField.setSelected(true);
        } else if (this.tabClicked() && this.tagInputField.getSelected()) {
            this.filenameInputField.setSelected(true);
            this.tagInputField.setSelected(false);
        }
        if (this.loadKeyPressed()) {
            this.loadButton.setClicked(true);
        }
        if (this.addCollisionEntityPressed()) {
            this.addCollisionEntity();
        }
        if (this.nextEntityType()) {
            this.entityTypeSelector.setSelected((this.entityTypeSelector.getSelected() + 1) % this.entityTypeSelector.getOptions().size());
        }
        if (this.hasSelectedEntity()) {
            if (this.deleteKeyPressed()) {
                AreaEntity areaEntity = selectedEntity;
                Intrinsics.checkNotNull((Object)areaEntity);
                this.removeEntity(areaEntity);
            }
            if (this.duplicateKeyPressed()) {
                AreaEntity areaEntity = selectedEntity;
                Intrinsics.checkNotNull((Object)areaEntity);
                this.duplicateEntity(areaEntity);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<AreaEntity> dataEntitesToEntity(List<? extends AreaEntityData> entities2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = entities2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AreaEntity areaEntity;
            void it;
            AreaEntityData areaEntityData = (AreaEntityData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_11 = it;
            if (var11_11 instanceof CollisionEntityData) {
                areaEntity = ((CollisionEntityData)it).toCollisionEntity(this.world);
            } else if (var11_11 instanceof GraphicEntityData) {
                areaEntity = ((GraphicEntityData)it).toGraphicalEntity(AreaEditorKt.access$getTextures$p());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            AreaEntity areaEntity2 = areaEntity;
            collection.add(areaEntity2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadFromFile(String file) {
        void $this$mapTo$iv$iv;
        AreaData areaData = this.areaResource.load("Simple Scene");
        if (areaData == null) {
            return;
        }
        AreaData areaData2 = areaData;
        Iterable $this$map$iv = areaData2.getEntities();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AreaEntity areaEntity;
            void it;
            AreaEntityData areaEntityData = (AreaEntityData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var13_13 = it;
            if (var13_13 instanceof CollisionEntityData) {
                areaEntity = ((CollisionEntityData)it).toCollisionEntity(this.world);
            } else if (var13_13 instanceof GraphicEntityData) {
                areaEntity = ((GraphicEntityData)it).toGraphicalEntity(AreaEditorKt.access$getTextures$p());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            AreaEntity areaEntity2 = areaEntity;
            collection.add(areaEntity2);
        }
        List areaEntities = (List)destination$iv$iv;
        this.scene.load(areaEntities);
        this.tagInputField.setText(CollectionsKt.joinToString$default((Iterable)areaData2.getTags(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        this.filenameInputField.setText(areaData2.getName());
    }

    private final void addCollisionEntity() {
        Vector2 size = Vector2Kt.x(0.5f, 0.5f);
        Vector2 vector2 = MouseKt.scaledPointer();
        Vector2 vector22 = Vector2Kt.copy(size).scl(0.5f);
        Intrinsics.checkNotNullExpressionValue((Object)vector22, (String)"size.copy().scl(0.5f)");
        this.scene.add(new CollisionEntity(this.world, new BaseEntityData(Vector2Kt.minus(vector2, vector22), size, true, null, 8, null)));
    }

    private final boolean findTextureSelected() {
        return Gdx.input.isKeyPressed(129) && Gdx.input.isKeyJustPressed(34);
    }

    private final boolean selectedIconPlacedInScene() {
        return this.iconSelector.getSelected() != null && UiComponentsKt.leftClick() && AreaEditorKt.isInsideScene();
    }

    private final boolean hasSelectedEntity() {
        return this.selectedEntity != null;
    }

    private final boolean deleteKeyPressed() {
        return Gdx.input.isKeyJustPressed(112);
    }

    private final boolean runButtonHotkeyPressed() {
        return Gdx.input.isKeyJustPressed(46) && Gdx.input.isKeyPressed(129);
    }

    private final boolean newButtonHotkeyPressed() {
        return Gdx.input.isKeyJustPressed(42) && Gdx.input.isKeyPressed(129);
    }

    private final boolean duplicateKeyPressed() {
        return Gdx.input.isKeyJustPressed(32);
    }

    private final boolean saveKeyPressed() {
        return UiComponentsKt.controlDown() && Gdx.input.isKeyJustPressed(47);
    }

    private final boolean loadKeyPressed() {
        return UiComponentsKt.controlDown() && Gdx.input.isKeyJustPressed(40);
    }

    private final boolean addCollisionEntityPressed() {
        return this.entityTypeSelector.selectedOption() == EntityType.COLLISION && Gdx.input.isKeyJustPressed(29);
    }

    private final boolean nextEntityType() {
        return UiComponentsKt.controlDown() && Gdx.input.isKeyJustPressed(48);
    }

    private final boolean toggleBoundingBox() {
        return UiComponentsKt.controlDown() && Gdx.input.isKeyJustPressed(30);
    }

    private final boolean tabClicked() {
        return Gdx.input.isKeyJustPressed(61);
    }

    private final void addSelectedIconToScene(TextureStore.TextureMeta selected) {
        boolean bl;
        float sy;
        float sx;
        Vector2 pointer;
        block4: {
            if (selected == null) {
                return;
            }
            pointer = MouseKt.scaledPointer();
            Vector2 vector2 = new Vector2(((Number)selected.getTextureSize().getFirst()).floatValue() / 120.0f, ((Number)selected.getTextureSize().getSecond()).floatValue() / 120.0f).scl(this.defaultScale);
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"scl(defaultScale)");
            sx = Vector2Kt.component1(vector2);
            sy = Vector2Kt.component2(vector2);
            Iterable $this$any$iv = selected.getTags();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Tag it = (Tag)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(it == Tag.BACKGROUND)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        int layer = bl ? -5 : 0;
        Vector2 position = pointer;
        GraphicEntity tileGraphic = new GraphicEntity(new BaseEntityData(position, Vector2Kt.x(sx, sy), true, null, 8, null), selected, new GraphicEntityData(null, selected.getName(), position, Vector2Kt.x(sx, sy), layer, 1.0f, false, 0.5f, 0.5f, Vector2Kt.x(0.0f, 0.0f), true, 1, null));
        this.scene.add(tileGraphic);
    }

    private final void removeEntity(AreaEntity entity) {
        this.scene.remove(entity);
        this.sceneItemsList.setSelected(null);
    }

    private final void duplicateEntity(AreaEntity entity) {
        AreaEntity areaEntity;
        AreaEntity areaEntity2 = entity;
        if (areaEntity2 instanceof GraphicEntity) {
            areaEntity = ((GraphicEntity)entity).deepCopy(true);
        } else if (areaEntity2 instanceof CollisionEntity) {
            areaEntity = ((CollisionEntity)entity).deepCopy(true, this.world);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        AreaEntity newEntity = areaEntity;
        this.scene.add(newEntity);
    }

    private final AreaEntity deepCopy(AreaEntity $this$deepCopy) {
        AreaEntity areaEntity;
        AreaEntity areaEntity2 = $this$deepCopy;
        if (areaEntity2 instanceof GraphicEntity) {
            areaEntity = ((GraphicEntity)$this$deepCopy).deepCopy(false);
        } else if (areaEntity2 instanceof CollisionEntity) {
            areaEntity = ((CollisionEntity)$this$deepCopy).deepCopy(false, ((CollisionEntity)$this$deepCopy).getWorld());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return areaEntity;
    }

    private final AreaEntityData toDataEntity(AreaEntity $this$toDataEntity) {
        AreaEntityData areaEntityData;
        AreaEntity areaEntity = $this$toDataEntity;
        if (areaEntity instanceof GraphicEntity) {
            areaEntityData = new GraphicEntityData($this$toDataEntity.getBase().getId(), ((GraphicEntity)$this$toDataEntity).getGfx().getName(), $this$toDataEntity.getBase().getPosition(), $this$toDataEntity.getBase().getSize(), ((GraphicEntity)$this$toDataEntity).getData().getLayer(), ((GraphicEntity)$this$toDataEntity).getData().getOpacity(), ((GraphicEntity)$this$toDataEntity).getData().getShadow(), ((GraphicEntity)$this$toDataEntity).getData().getShadowOpacity(), ((GraphicEntity)$this$toDataEntity).getData().getShadowSize(), ((GraphicEntity)$this$toDataEntity).getData().getShadowOffset(), ((GraphicEntity)$this$toDataEntity).getData().getBoundingBox());
        } else if (areaEntity instanceof CollisionEntity) {
            areaEntityData = new CollisionEntityData($this$toDataEntity.getBase().getId(), $this$toDataEntity.getBase().getPosition(), $this$toDataEntity.getBase().getSize(), $this$toDataEntity.getBase().getBoundingBox());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return areaEntityData;
    }
}

