/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.storage.Tag;
import org.veiset.kgame.engine.storage.TextureStore;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0002\u001a\b\u0010\u0017\u001a\u00020\u0015H\u0002\u001a\b\u0010\u0018\u001a\u00020\u0015H\u0002\u001a\u0006\u0010\u0019\u001a\u00020\u0015\u001a\b\u0010\u001a\u001a\u00020\u001bH\u0000\u001a$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d*\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u001e\u001a\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"cols", "", "gameHeight", "gameWidth", "resolution", "rows", "shapeRenderer", "Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "spriteBatch", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "textureStore", "Lorg/veiset/kgame/engine/storage/TextureStore;", "textures", "", "", "Lorg/veiset/kgame/engine/storage/TextureStore$TextureMeta;", "unitSize", "viewBoxPos", "Lcom/badlogic/gdx/math/Vector2;", "viewBoxSize", "drawBackgroundTiles", "", "type", "drawGrid", "drawUiAreas", "drawViewBox", "isInsideScene", "", "query", "", "searchString", "kgame2"})
public final class AreaEditorKt {
    private static final float resolution = 0.25f;
    @NotNull
    private static final ShapeRenderer shapeRenderer = TBEngineKt.getGlobals().getDrawUi().getShapeRenderer();
    @NotNull
    private static final SpriteBatch spriteBatch = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
    private static final float gameHeight = 9.0f;
    private static final float gameWidth = 16.0f;
    private static final float cols = 64.0f;
    private static final float rows = 36.0f;
    private static final float unitSize = 0.25f;
    @NotNull
    private static final Vector2 viewBoxPos = Vector2Kt.x(3.0f, 0.005f);
    @NotNull
    private static final Vector2 viewBoxSize = Vector2Kt.x(10.0f, 8.5f);
    @NotNull
    private static final TextureStore textureStore = TBEngineKt.getGlobals().getTextureStore();
    @NotNull
    private static final Map<String, TextureStore.TextureMeta> textures = TBEngineKt.getGlobals().getTextureStore().getTextures();

    public static final boolean isInsideScene() {
        return Vector2Kt.uiPointerWithinSquare(viewBoxPos, viewBoxSize);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TextureStore.TextureMeta> query(@NotNull Map<String, TextureStore.TextureMeta> $this$query, @NotNull String searchString) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$query, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        if (StringsKt.isBlank((CharSequence)searchString)) {
            return CollectionsKt.toList((Iterable)$this$query.values());
        }
        String string = searchString;
        boolean bl = false;
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        String search = string2;
        Object object = new String[]{" "};
        List queries = StringsKt.split$default((CharSequence)search, (String[])object, (boolean)false, (int)0, (int)6, null);
        object = queries;
        List initial$iv = CollectionsKt.toList((Iterable)$this$query.values());
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void $this$filterTo$iv$iv;
            String string3 = (String)element$iv;
            List results = accumulator$iv;
            boolean bl2 = false;
            Iterable $this$filter$iv = results;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                void query;
                TextureStore.TextureMeta it = (TextureStore.TextureMeta)element$iv$iv;
                boolean bl3 = false;
                boolean bl4 = StringsKt.startsWith$default((String)query, (String)"@", (boolean)false, (int)2, null) ? AreaEditorKt.query$tagMatches(it, StringsKt.drop((String)query, (int)1)) : AreaEditorKt.query$nameMatches(it, (String)query) || AreaEditorKt.query$tagMatches(it, (String)query);
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            accumulator$iv = (List)destination$iv$iv;
        }
        return accumulator$iv;
    }

    public static final void drawViewBox() {
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        shapeRenderer.setColor(Color.WHITE);
        ShapeRendererKt.rect((ShapeRenderer)shapeRenderer, (Vector2)Vector2Kt.dw(viewBoxPos), (Vector2)Vector2Kt.dw(viewBoxSize));
        shapeRenderer.end();
    }

    /*
     * WARNING - void declaration
     */
    private static final void drawBackgroundTiles(String type) {
        List list;
        String string = type;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        String selectedType = string3;
        if (Intrinsics.areEqual((Object)selectedType, (Object)"none")) {
            return;
        }
        if (Intrinsics.areEqual((Object)selectedType, (Object)"forest")) {
            void $this$mapTo$iv$iv;
            TextureStore.TextureMeta it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = textures.values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TextureStore.TextureMeta)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getTags().contains((Object)Tag.BACKGROUND) && it.getTags().contains((Object)Tag.GRASS))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TextureStore.TextureMeta)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                TextureRegion textureRegion = it.getTexture();
                collection.add(textureRegion);
            }
            list = (List)destination$iv$iv;
        } else {
            list = Intrinsics.areEqual((Object)selectedType, (Object)"bleak") ? textureStore.getBleakGrass() : CollectionsKt.listOf((Object)textureStore.getById("blood").getTexture());
        }
        List bgTiles = list;
        int scale = 2;
        float startX = 3.0f;
        float size = 0.25f * (float)scale;
        int xTiles = 40;
        int yTiles = 34;
        spriteBatch.begin();
        Iterable $this$forEach$iv = (Iterable)RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)xTiles)), (int)scale);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int x = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl4 = false;
            Iterable $this$forEach$iv2 = (Iterable)RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)yTiles)), (int)scale);
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                int element$iv2;
                int y = element$iv2 = ((IntIterator)iterator2).nextInt();
                boolean bl5 = false;
                spriteBatch.draw((TextureRegion)bgTiles.get((x / scale + y / scale) % bgTiles.size()), ((float)x * 0.25f + startX) * 120.0f, (float)y * 0.25f * 120.0f, size * 120.0f, size * 120.0f);
            }
        }
        spriteBatch.end();
    }

    private static final void drawUiAreas() {
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        shapeRenderer.setColor(new Color(0.12f, 0.1f, 0.1f, 1.0f));
        ShapeRendererKt.rect((ShapeRenderer)shapeRenderer, (Vector2)Vector2Kt.x(0.0f, 0.0f), (Vector2)Vector2Kt.x(360.0f, 1080.0f));
        shapeRenderer.setColor(new Color(0.1f, 0.1f, 0.1f, 1.0f));
        ShapeRendererKt.rect((ShapeRenderer)shapeRenderer, (Vector2)Vector2Kt.x(1560.0f, 0.0f), (Vector2)Vector2Kt.x(360.0f, 1080.0f));
        shapeRenderer.setColor(new Color(0.1f, 0.1f, 0.1f, 1.0f));
        ShapeRendererKt.rect((ShapeRenderer)shapeRenderer, (Vector2)Vector2Kt.dw(Vector2Kt.x(3.0f, 8.5f)), (Vector2)Vector2Kt.dw(Vector2Kt.x(10.0f, 10.0f)));
        shapeRenderer.end();
    }

    private static final void drawGrid() {
        int it;
        int element$iv;
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        shapeRenderer.setColor(new Color(0.05f, 0.05f, 0.05f, 0.35f));
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, 64);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            float x = (float)it * 16.0f / 64.0f;
            shapeRenderer.line(Vector2Kt.x(x * 120.0f, 0.0f), Vector2Kt.x(x * 120.0f, 1080.0f));
        }
        $this$forEach$iv = (Iterable)new IntRange(0, 36);
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            float y = (float)it * 9.0f / 36.0f;
            shapeRenderer.line(Vector2Kt.x(0.0f, y * 120.0f), Vector2Kt.x(1920.0f, y * 120.0f));
        }
        shapeRenderer.end();
        Gdx.gl.glDisable(3042);
    }

    private static final boolean query$nameMatches(TextureStore.TextureMeta $this$query_u24nameMatches, String search) {
        String string = $this$query_u24nameMatches.getName();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        return StringsKt.contains$default((CharSequence)string3, (CharSequence)search, (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean query$tagMatches(TextureStore.TextureMeta $this$query_u24tagMatches, String search) {
        boolean bl;
        Iterable $this$any$iv = $this$query_u24tagMatches.getTags();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            Tag tag = (Tag)((Object)element$iv);
            boolean bl2 = false;
            String string = tag.getTagName();
            boolean bl3 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            if (StringsKt.startsWith$default((String)string3, (String)search, (boolean)false, (int)2, null)) return true;
            String[] $this$any$iv2 = tag.getKeywords();
            boolean $i$f$any2 = false;
            String[] stringArray = $this$any$iv2;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv2;
                String keyWord = element$iv2 = stringArray[i];
                boolean bl4 = false;
                String string4 = keyWord;
                boolean bl5 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                if (!StringsKt.startsWith$default((String)string6, (String)search, (boolean)false, (int)2, null)) continue;
                return true;
            }
            boolean bl6 = false;
            if (bl6) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final /* synthetic */ Map access$getTextures$p() {
        return textures;
    }

    public static final /* synthetic */ SpriteBatch access$getSpriteBatch$p() {
        return spriteBatch;
    }

    public static final /* synthetic */ void access$drawBackgroundTiles(String type) {
        AreaEditorKt.drawBackgroundTiles(type);
    }

    public static final /* synthetic */ void access$drawUiAreas() {
        AreaEditorKt.drawUiAreas();
    }

    public static final /* synthetic */ void access$drawGrid() {
        AreaEditorKt.drawGrid();
    }
}

