/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.gdx.math.Vector2;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.storage.TextureStore;
import org.veiset.kgame.engine.tools.editor.area.AreaEntityData;
import org.veiset.kgame.engine.tools.editor.area.AreaEntityKt;
import org.veiset.kgame.engine.tools.editor.area.AreaResourceKt;
import org.veiset.kgame.engine.tools.editor.area.BaseEntityData;
import org.veiset.kgame.engine.tools.editor.area.GraphicEntity;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b3\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 I2\u00020\u0001:\u0001IB_\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u0006\u0012\u0006\u0010\u0011\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0012J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u0006H\u00c6\u0003J\t\u00104\u001a\u00020\rH\u00c6\u0003J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0006H\u00c6\u0003J\t\u00107\u001a\u00020\u0006H\u00c6\u0003J\t\u00108\u001a\u00020\tH\u00c6\u0003J\t\u00109\u001a\u00020\u000bH\u00c6\u0003J\t\u0010:\u001a\u00020\rH\u00c6\u0003J\t\u0010;\u001a\u00020\u000bH\u00c6\u0003J\t\u0010<\u001a\u00020\u000bH\u00c6\u0003Jw\u0010=\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\rH\u00c6\u0001J\u0010\u0010>\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0006J\u0013\u0010?\u001a\u00020\r2\b\u0010@\u001a\u0004\u0018\u00010AH\u00d6\u0003J\t\u0010B\u001a\u00020\tH\u00d6\u0001J\u001a\u0010C\u001a\u00020D2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020G0FJ\t\u0010H\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0011\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0014\"\u0004\b&\u0010\u0016R\u001a\u0010\u0010\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\"\"\u0004\b(\u0010$R\u001a\u0010\u000e\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001e\"\u0004\b*\u0010 R\u001a\u0010\u000f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001e\"\u0004\b,\u0010 R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\"\"\u0004\b.\u0010$R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0018\"\u0004\b0\u00101\u00a8\u0006J"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/GraphicEntityData;", "Lorg/veiset/kgame/engine/tools/editor/area/AreaEntityData;", "id", "", "textureId", "position", "Lcom/badlogic/gdx/math/Vector2;", "size", "layer", "", "opacity", "", "shadow", "", "shadowOpacity", "shadowSize", "shadowOffset", "boundingBox", "(Ljava/lang/String;Ljava/lang/String;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;IFZFFLcom/badlogic/gdx/math/Vector2;Z)V", "getBoundingBox", "()Z", "setBoundingBox", "(Z)V", "getId", "()Ljava/lang/String;", "getLayer", "()I", "setLayer", "(I)V", "getOpacity", "()F", "setOpacity", "(F)V", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "setPosition", "(Lcom/badlogic/gdx/math/Vector2;)V", "getShadow", "setShadow", "getShadowOffset", "setShadowOffset", "getShadowOpacity", "setShadowOpacity", "getShadowSize", "setShadowSize", "getSize", "setSize", "getTextureId", "setTextureId", "(Ljava/lang/String;)V", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "deepCopy", "equals", "other", "", "hashCode", "toGraphicalEntity", "Lorg/veiset/kgame/engine/tools/editor/area/GraphicEntity;", "textures", "", "Lorg/veiset/kgame/engine/storage/TextureStore$TextureMeta;", "toString", "Companion", "kgame2"})
public final class GraphicEntityData
extends AreaEntityData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private String textureId;
    @NotNull
    private Vector2 position;
    @NotNull
    private Vector2 size;
    private int layer;
    private float opacity;
    private boolean shadow;
    private float shadowOpacity;
    private float shadowSize;
    @NotNull
    private Vector2 shadowOffset;
    private boolean boundingBox;

    public GraphicEntityData(@NotNull String id, @NotNull String textureId, @NotNull Vector2 position, @NotNull Vector2 size, int layer, float opacity, boolean shadow, float shadowOpacity, float shadowSize, @NotNull Vector2 shadowOffset, boolean boundingBox) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)textureId, (String)"textureId");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)shadowOffset, (String)"shadowOffset");
        super(null);
        this.id = id;
        this.textureId = textureId;
        this.position = position;
        this.size = size;
        this.layer = layer;
        this.opacity = opacity;
        this.shadow = shadow;
        this.shadowOpacity = shadowOpacity;
        this.shadowSize = shadowSize;
        this.shadowOffset = shadowOffset;
        this.boundingBox = boundingBox;
    }

    public /* synthetic */ GraphicEntityData(String string, String string2, Vector2 vector2, Vector2 vector22, int n, float f, boolean bl, float f2, float f3, Vector2 vector23, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            String string3 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"randomUUID().toString()");
            string = Intrinsics.stringPlus((String)"entity_", (Object)StringsKt.drop((String)string3, (int)15));
        }
        this(string, string2, vector2, vector22, n, f, bl, f2, f3, vector23, bl2);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getTextureId() {
        return this.textureId;
    }

    public final void setTextureId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.textureId = string;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    public final void setPosition(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter((Object)vector2, (String)"<set-?>");
        this.position = vector2;
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }

    public final void setSize(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter((Object)vector2, (String)"<set-?>");
        this.size = vector2;
    }

    public final int getLayer() {
        return this.layer;
    }

    public final void setLayer(int n) {
        this.layer = n;
    }

    public final float getOpacity() {
        return this.opacity;
    }

    public final void setOpacity(float f) {
        this.opacity = f;
    }

    public final boolean getShadow() {
        return this.shadow;
    }

    public final void setShadow(boolean bl) {
        this.shadow = bl;
    }

    public final float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public final void setShadowOpacity(float f) {
        this.shadowOpacity = f;
    }

    public final float getShadowSize() {
        return this.shadowSize;
    }

    public final void setShadowSize(float f) {
        this.shadowSize = f;
    }

    @NotNull
    public final Vector2 getShadowOffset() {
        return this.shadowOffset;
    }

    public final void setShadowOffset(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter((Object)vector2, (String)"<set-?>");
        this.shadowOffset = vector2;
    }

    public final boolean getBoundingBox() {
        return this.boundingBox;
    }

    public final void setBoundingBox(boolean bl) {
        this.boundingBox = bl;
    }

    @NotNull
    public final GraphicEntity toGraphicalEntity(@NotNull Map<String, TextureStore.TextureMeta> textures) {
        Intrinsics.checkNotNullParameter(textures, (String)"textures");
        Vector2 vector2 = Vector2Kt.copy(this.position);
        Vector2 vector22 = Vector2Kt.copy(this.size);
        String string = this.id;
        boolean bl = this.boundingBox;
        BaseEntityData baseEntityData = new BaseEntityData(vector2, vector22, bl, string);
        TextureStore.TextureMeta textureMeta = textures.get(this.textureId);
        Intrinsics.checkNotNull((Object)textureMeta);
        return new GraphicEntity(baseEntityData, textureMeta, this);
    }

    @NotNull
    public final GraphicEntityData deepCopy(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return new GraphicEntityData(this.id, this.textureId, Vector2Kt.copy(position), Vector2Kt.copy(this.size), this.layer, this.opacity, this.shadow, this.shadowOpacity, this.shadowSize, Vector2Kt.copy(this.shadowOffset), this.boundingBox);
    }

    public static /* synthetic */ GraphicEntityData deepCopy$default(GraphicEntityData graphicEntityData, Vector2 vector2, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = graphicEntityData.position;
        }
        return graphicEntityData.deepCopy(vector2);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.textureId;
    }

    @NotNull
    public final Vector2 component3() {
        return this.position;
    }

    @NotNull
    public final Vector2 component4() {
        return this.size;
    }

    public final int component5() {
        return this.layer;
    }

    public final float component6() {
        return this.opacity;
    }

    public final boolean component7() {
        return this.shadow;
    }

    public final float component8() {
        return this.shadowOpacity;
    }

    public final float component9() {
        return this.shadowSize;
    }

    @NotNull
    public final Vector2 component10() {
        return this.shadowOffset;
    }

    public final boolean component11() {
        return this.boundingBox;
    }

    @NotNull
    public final GraphicEntityData copy(@NotNull String id, @NotNull String textureId, @NotNull Vector2 position, @NotNull Vector2 size, int layer, float opacity, boolean shadow, float shadowOpacity, float shadowSize, @NotNull Vector2 shadowOffset, boolean boundingBox) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)textureId, (String)"textureId");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)shadowOffset, (String)"shadowOffset");
        return new GraphicEntityData(id, textureId, position, size, layer, opacity, shadow, shadowOpacity, shadowSize, shadowOffset, boundingBox);
    }

    public static /* synthetic */ GraphicEntityData copy$default(GraphicEntityData graphicEntityData, String string, String string2, Vector2 vector2, Vector2 vector22, int n, float f, boolean bl, float f2, float f3, Vector2 vector23, boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = graphicEntityData.id;
        }
        if ((n2 & 2) != 0) {
            string2 = graphicEntityData.textureId;
        }
        if ((n2 & 4) != 0) {
            vector2 = graphicEntityData.position;
        }
        if ((n2 & 8) != 0) {
            vector22 = graphicEntityData.size;
        }
        if ((n2 & 0x10) != 0) {
            n = graphicEntityData.layer;
        }
        if ((n2 & 0x20) != 0) {
            f = graphicEntityData.opacity;
        }
        if ((n2 & 0x40) != 0) {
            bl = graphicEntityData.shadow;
        }
        if ((n2 & 0x80) != 0) {
            f2 = graphicEntityData.shadowOpacity;
        }
        if ((n2 & 0x100) != 0) {
            f3 = graphicEntityData.shadowSize;
        }
        if ((n2 & 0x200) != 0) {
            vector23 = graphicEntityData.shadowOffset;
        }
        if ((n2 & 0x400) != 0) {
            bl2 = graphicEntityData.boundingBox;
        }
        return graphicEntityData.copy(string, string2, vector2, vector22, n, f, bl, f2, f3, vector23, bl2);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GraphicEntityData(id=").append(this.id).append(", textureId=").append(this.textureId).append(", position=").append(this.position).append(", size=").append(this.size).append(", layer=").append(this.layer).append(", opacity=").append(this.opacity).append(", shadow=").append(this.shadow).append(", shadowOpacity=").append(this.shadowOpacity).append(", shadowSize=").append(this.shadowSize).append(", shadowOffset=").append(this.shadowOffset).append(", boundingBox=").append(this.boundingBox).append(')');
        return stringBuilder.toString();
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.textureId.hashCode();
        result = result * 31 + this.position.hashCode();
        result = result * 31 + this.size.hashCode();
        result = result * 31 + Integer.hashCode(this.layer);
        result = result * 31 + Float.hashCode(this.opacity);
        int n = this.shadow ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + Float.hashCode(this.shadowOpacity);
        result = result * 31 + Float.hashCode(this.shadowSize);
        result = result * 31 + this.shadowOffset.hashCode();
        int n2 = this.boundingBox ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GraphicEntityData)) {
            return false;
        }
        GraphicEntityData graphicEntityData = (GraphicEntityData)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)graphicEntityData.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.textureId, (Object)graphicEntityData.textureId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.position, (Object)graphicEntityData.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.size, (Object)graphicEntityData.size)) {
            return false;
        }
        if (this.layer != graphicEntityData.layer) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.opacity), (Object)Float.valueOf(graphicEntityData.opacity))) {
            return false;
        }
        if (this.shadow != graphicEntityData.shadow) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.shadowOpacity), (Object)Float.valueOf(graphicEntityData.shadowOpacity))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.shadowSize), (Object)Float.valueOf(graphicEntityData.shadowSize))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shadowOffset, (Object)graphicEntityData.shadowOffset)) {
            return false;
        }
        return this.boundingBox == graphicEntityData.boundingBox;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/GraphicEntityData$Companion;", "", "()V", "fromString", "Lorg/veiset/kgame/engine/tools/editor/area/GraphicEntityData;", "data", "", "kgame2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GraphicEntityData fromString(@NotNull String data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Map<String, String> attr = AreaEntityKt.dataMapFromStr(data);
            String string = attr.get("id");
            Intrinsics.checkNotNull((Object)string);
            String string2 = attr.get("textureId");
            Intrinsics.checkNotNull((Object)string2);
            String string3 = attr.get("position");
            Intrinsics.checkNotNull((Object)string3);
            Vector2 vector2 = AreaResourceKt.toVector2(string3);
            Intrinsics.checkNotNull((Object)vector2);
            String string4 = attr.get("size");
            Intrinsics.checkNotNull((Object)string4);
            Vector2 vector22 = AreaResourceKt.toVector2(string4);
            Intrinsics.checkNotNull((Object)vector22);
            String string5 = attr.get("layer");
            Intrinsics.checkNotNull((Object)string5);
            Integer n = AreaResourceKt.toValidInt(string5);
            Intrinsics.checkNotNull((Object)n);
            int n2 = n;
            String string6 = attr.getOrDefault("opacity", "1f");
            Intrinsics.checkNotNull((Object)string6);
            String string7 = string6;
            boolean bl = false;
            float f = Float.parseFloat(string7);
            string7 = attr.getOrDefault("shadow", "false");
            bl = false;
            boolean bl2 = Boolean.parseBoolean(string7);
            String string8 = attr.getOrDefault("shadowOpacity", "0.5f");
            Intrinsics.checkNotNull((Object)string8);
            string7 = string8;
            bl = false;
            float f2 = Float.parseFloat(string7);
            String string9 = attr.getOrDefault("shadowSize", "0.5f");
            Intrinsics.checkNotNull((Object)string9);
            string7 = string9;
            bl = false;
            float f3 = Float.parseFloat(string7);
            String string10 = attr.getOrDefault("shadowOffset", "0,0");
            Intrinsics.checkNotNull((Object)string10);
            Vector2 vector23 = AreaResourceKt.toVector2(string10);
            Intrinsics.checkNotNull((Object)vector23);
            string7 = attr.getOrDefault("boundingBox", "true");
            bl = false;
            return new GraphicEntityData(string, string2, vector2, vector22, n2, f, bl2, f2, f3, vector23, Boolean.parseBoolean(string7));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

