/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area.components;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.editor.area.AreaResourceKt;
import org.veiset.kgame.engine.tools.editor.area.GraphicEntity;
import org.veiset.kgame.engine.tools.ui.UiComponent;
import org.veiset.kgame.engine.tools.ui.UiComponentsKt;
import org.veiset.kgame.engine.tools.ui.components.CheckBox;
import org.veiset.kgame.engine.tools.ui.components.InputField;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J-\u0010\u001c\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u001d*\u0004\u0018\u0001H\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u00140\u001fH\u0002\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/components/AreaEntityEditor;", "", "()V", "checkboxBoundingBox", "Lorg/veiset/kgame/engine/tools/ui/components/CheckBox;", "checkboxShadow", "inputLayer", "Lorg/veiset/kgame/engine/tools/ui/components/InputField;", "inputOpacity", "inputPosition", "inputScale", "inputShadowOffset", "inputShadowOpacity", "inputShadowScale", "inputs", "", "Lorg/veiset/kgame/engine/tools/ui/UiComponent;", "getInputs", "()Ljava/util/List;", "draw", "", "areaEntity", "Lorg/veiset/kgame/engine/tools/editor/area/GraphicEntity;", "populateInputs", "update", "updateEntity", "validFields", "", "ifNotNull", "T", "f", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "kgame2"})
public final class AreaEntityEditor {
    @NotNull
    private final InputField inputPosition = new InputField(Vector2Kt.x(14.0f, 7.5f), Vector2Kt.x(1.5f, 0.3f), "");
    @NotNull
    private final InputField inputScale = new InputField(Vector2Kt.x(14.0f, 7.1f), Vector2Kt.x(1.5f, 0.3f), "");
    @NotNull
    private final InputField inputLayer = new InputField(Vector2Kt.x(14.0f, 6.7f), Vector2Kt.x(0.75f, 0.3f), "0");
    @NotNull
    private final InputField inputOpacity = new InputField(Vector2Kt.x(14.0f, 6.2999997f), Vector2Kt.x(0.75f, 0.3f), "1.0");
    @NotNull
    private final CheckBox checkboxBoundingBox = new CheckBox(Vector2Kt.x(13.2f, 5.9f), "Bounding box", true);
    @NotNull
    private final CheckBox checkboxShadow = new CheckBox(Vector2Kt.x(14.0f, 5.1699996f), "", false);
    @NotNull
    private final InputField inputShadowOpacity = new InputField(Vector2Kt.x(14.0f, 4.7000003f), Vector2Kt.x(0.75f, 0.3f), "0.5");
    @NotNull
    private final InputField inputShadowScale = new InputField(Vector2Kt.x(14.0f, 4.2999997f), Vector2Kt.x(0.75f, 0.3f), "0.5");
    @NotNull
    private final InputField inputShadowOffset = new InputField(Vector2Kt.x(14.0f, 3.9f), Vector2Kt.x(1.5f, 0.3f), "0f, 0f");
    @NotNull
    private final List<UiComponent> inputs;

    public AreaEntityEditor() {
        Object[] objectArray = new UiComponent[]{this.inputPosition, this.inputScale, this.checkboxShadow, this.inputShadowOpacity, this.inputShadowScale, this.inputShadowOffset, this.inputLayer, this.inputOpacity, this.checkboxBoundingBox};
        this.inputs = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<UiComponent> getInputs() {
        return this.inputs;
    }

    private final void populateInputs(GraphicEntity areaEntity) {
        if (!this.validFields()) {
            return;
        }
        this.inputPosition.setText(AreaResourceKt.toEditStr(areaEntity.getBase().getPosition()));
        this.inputScale.setText(AreaResourceKt.toEditStr(areaEntity.getBase().getSize()));
        this.checkboxShadow.setChecked(areaEntity.getData().getShadow());
        this.inputLayer.setText(String.valueOf(areaEntity.getData().getLayer()));
        this.inputShadowOpacity.setText(String.valueOf(areaEntity.getData().getShadowOpacity()));
        this.inputShadowScale.setText(String.valueOf(areaEntity.getData().getShadowSize()));
        this.inputOpacity.setText(String.valueOf(areaEntity.getData().getOpacity()));
        this.checkboxBoundingBox.setChecked(areaEntity.getBase().getBoundingBox());
        this.inputShadowOffset.setText(AreaResourceKt.toEditStr(areaEntity.getData().getShadowOffset()));
    }

    public final void draw(@NotNull GraphicEntity areaEntity) {
        Intrinsics.checkNotNullParameter((Object)areaEntity, (String)"areaEntity");
        UiComponentsKt.getSpriteBatch().begin();
        UiComponentsKt.getFont().setColor(Color.WHITE);
        UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)areaEntity.getBase().getId(), 1572.0f, 966.0f);
        UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)"Position:", 1584.0f, 929.99994f);
        UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)"Scale:", 1584.0f, 881.99994f);
        UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)"Layer:", 1584.0f, 833.99994f);
        UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)"Opacity", 1584.0f, 785.99994f);
        UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)"Shadow", 1584.0f, 641.99994f);
        UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)"Opacity:", 1584.0f, 593.99994f);
        UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)"Scale:", 1584.0f, 545.99994f);
        UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)"Offset:", 1584.0f, 497.9999f);
        UiComponentsKt.getSpriteBatch().end();
        Iterable $this$forEach$iv = this.inputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UiComponent p0 = (UiComponent)element$iv;
            boolean bl = false;
            p0.draw();
        }
    }

    public final void update(@NotNull GraphicEntity areaEntity) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)areaEntity, (String)"areaEntity");
        this.populateInputs(areaEntity);
        if (UiComponentsKt.leftClick() || UiComponentsKt.rightClick() || UiComponentsKt.enterClick()) {
            $this$forEach$iv = this.inputs;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UiComponent it = (UiComponent)element$iv;
                boolean bl = false;
                if (!(it instanceof InputField)) continue;
                ((InputField)it).setSelected(false);
            }
        }
        $this$forEach$iv = this.inputs;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UiComponent p0 = (UiComponent)element$iv;
            boolean bl = false;
            p0.update();
        }
        this.updateEntity(areaEntity);
    }

    private final <T> void ifNotNull(T $this$ifNotNull, Function1<? super T, Unit> f) {
        if ($this$ifNotNull == null) {
            return;
        }
        f.invoke($this$ifNotNull);
    }

    private final void updateEntity(GraphicEntity areaEntity) {
        this.ifNotNull(AreaResourceKt.toVector2(this.inputPosition.getText()), (Function1)new Function1<Vector2, Unit>(areaEntity){
            final /* synthetic */ GraphicEntity $areaEntity;
            {
                this.$areaEntity = $areaEntity;
                super(1);
            }

            public final void invoke(@NotNull Vector2 it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$areaEntity.getBase().setPosition(it);
            }
        });
        this.ifNotNull(AreaResourceKt.toVector2(this.inputScale.getText()), (Function1)new Function1<Vector2, Unit>(areaEntity){
            final /* synthetic */ GraphicEntity $areaEntity;
            {
                this.$areaEntity = $areaEntity;
                super(1);
            }

            public final void invoke(@NotNull Vector2 it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$areaEntity.getBase().setSize(it);
            }
        });
        this.ifNotNull(AreaResourceKt.toValidInt(this.inputLayer.getText()), (Function1)new Function1<Integer, Unit>(areaEntity){
            final /* synthetic */ GraphicEntity $areaEntity;
            {
                this.$areaEntity = $areaEntity;
                super(1);
            }

            public final void invoke(int it) {
                this.$areaEntity.getData().setLayer(it);
            }
        });
        this.ifNotNull(AreaResourceKt.toValidFloat(this.inputOpacity.getText()), (Function1)new Function1<Float, Unit>(areaEntity){
            final /* synthetic */ GraphicEntity $areaEntity;
            {
                this.$areaEntity = $areaEntity;
                super(1);
            }

            public final void invoke(float it) {
                this.$areaEntity.getData().setOpacity(it);
            }
        });
        this.ifNotNull(AreaResourceKt.toValidFloat(this.inputShadowOpacity.getText()), (Function1)new Function1<Float, Unit>(areaEntity){
            final /* synthetic */ GraphicEntity $areaEntity;
            {
                this.$areaEntity = $areaEntity;
                super(1);
            }

            public final void invoke(float it) {
                this.$areaEntity.getData().setShadowOpacity(it);
            }
        });
        this.ifNotNull(AreaResourceKt.toValidFloat(this.inputShadowScale.getText()), (Function1)new Function1<Float, Unit>(areaEntity){
            final /* synthetic */ GraphicEntity $areaEntity;
            {
                this.$areaEntity = $areaEntity;
                super(1);
            }

            public final void invoke(float it) {
                this.$areaEntity.getData().setShadowSize(it);
            }
        });
        this.ifNotNull(AreaResourceKt.toVector2(this.inputShadowOffset.getText()), (Function1)new Function1<Vector2, Unit>(areaEntity){
            final /* synthetic */ GraphicEntity $areaEntity;
            {
                this.$areaEntity = $areaEntity;
                super(1);
            }

            public final void invoke(@NotNull Vector2 it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$areaEntity.getData().setShadowOffset(it);
            }
        });
        areaEntity.getData().setShadow(this.checkboxShadow.getChecked());
        areaEntity.getBase().setBoundingBox(this.checkboxBoundingBox.getChecked());
        areaEntity.update();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean validFields() {
        boolean bl;
        block4: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.inputs;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof InputField)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    InputField it = (InputField)element$iv;
                    boolean bl2 = false;
                    if (!it.getSelected()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return !bl;
    }
}

