/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.world;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.storage.Tag;
import org.veiset.kgame.engine.storage.TextureStore;
import org.veiset.kgame.engine.world.MetaTile;
import org.veiset.kgame.engine.world.WorldMapKt;
import org.veiset.kgame.engine.world.WorldMapTileThreshold;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/veiset/kgame/engine/world/HeavyForest;", "Lorg/veiset/kgame/engine/world/WorldMapTileThreshold;", "icon", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "areaSize", "Lkotlin/Pair;", "", "(Lcom/badlogic/gdx/graphics/g2d/TextureRegion;Lkotlin/Pair;)V", "getAreaSize", "()Lkotlin/Pair;", "description", "", "getDescription", "()Ljava/lang/String;", "getIcon", "()Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "textureFromIdNoise", "id", "noise", "", "tileFromNoise", "Lorg/veiset/kgame/engine/world/MetaTile;", "kgame2"})
public final class HeavyForest
implements WorldMapTileThreshold {
    @NotNull
    private final TextureRegion icon;
    @NotNull
    private final Pair<Integer, Integer> areaSize;
    @NotNull
    private final String description;

    public HeavyForest(@NotNull TextureRegion icon, @NotNull Pair<Integer, Integer> areaSize) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter(areaSize, (String)"areaSize");
        this.icon = icon;
        this.areaSize = areaSize;
        this.description = "Heavy Forest";
    }

    public /* synthetic */ HeavyForest(TextureRegion textureRegion, Pair pair, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            textureRegion = WorldMapKt.getTextureStore().getHexTiles().get(3);
        }
        if ((n & 2) != 0) {
            pair = new Pair((Object)160, (Object)80);
        }
        this(textureRegion, (Pair<Integer, Integer>)pair);
    }

    @Override
    @NotNull
    public TextureRegion getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> getAreaSize() {
        return this.areaSize;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public MetaTile tileFromNoise(float noise) {
        MetaTile metaTile;
        float f = noise;
        double d = f;
        boolean bl = 0.0 <= d ? d <= 0.2 : false;
        if (bl) {
            metaTile = new MetaTile(0, this.textureFromIdNoise(0, noise), CollectionsKt.listOf((Object)((Object)Tag.ROCK)));
        } else {
            d = f;
            boolean bl2 = 0.2 <= d ? d <= 0.7 : false;
            if (bl2) {
                metaTile = new MetaTile(1, this.textureFromIdNoise(1, noise), CollectionsKt.listOf((Object)((Object)Tag.GRASS)));
            } else {
                d = f;
                boolean bl3 = 0.7 <= d ? d <= 1.0 : false;
                if (bl3) {
                    metaTile = new MetaTile(2, this.textureFromIdNoise(2, noise), CollectionsKt.listOf((Object)((Object)Tag.DESERT)));
                } else {
                    boolean bl4 = false;
                    metaTile = new MetaTile(-1, this.textureFromIdNoise(-1, noise), CollectionsKt.emptyList());
                }
            }
        }
        return metaTile;
    }

    private final TextureRegion textureFromIdNoise(int id, float noise) {
        TextureRegion textureRegion;
        TextureStore textureStore = TBEngineKt.getGlobals().getTextureStore();
        int n = id;
        switch (n) {
            case 0: {
                textureRegion = textureStore.getStoneTiles().get((int)((float)textureStore.getStoneTiles().size() * noise));
                break;
            }
            case 1: {
                textureRegion = textureStore.getGrassTiles().get((int)((float)textureStore.getGrassTiles().size() * noise));
                break;
            }
            default: {
                textureRegion = textureStore.getDesertTiles().get((int)((float)textureStore.getDesertTiles().size() * noise));
            }
        }
        return textureRegion;
    }

    public HeavyForest() {
        this(null, null, 3, null);
    }
}

