/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.backends.lwjgl.LwjglGL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL21;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GL40;
import org.lwjgl.opengl.GL41;
import org.lwjgl.opengl.GL43;

class LwjglGL30
extends LwjglGL20
implements GL30 {
    LwjglGL30() {
    }

    public void glReadBuffer(int mode) {
        GL11.glReadBuffer((int)mode);
    }

    public void glDrawRangeElements(int mode, int start, int end, int count, int type, Buffer indices) {
        if (indices instanceof ByteBuffer) {
            GL12.glDrawRangeElements((int)mode, (int)start, (int)end, (ByteBuffer)((ByteBuffer)indices));
        } else if (indices instanceof ShortBuffer) {
            GL12.glDrawRangeElements((int)mode, (int)start, (int)end, (ShortBuffer)((ShortBuffer)indices));
        } else if (indices instanceof IntBuffer) {
            GL12.glDrawRangeElements((int)mode, (int)start, (int)end, (IntBuffer)((IntBuffer)indices));
        } else {
            throw new GdxRuntimeException("indices must be byte, short or int buffer");
        }
    }

    public void glDrawRangeElements(int mode, int start, int end, int count, int type, int offset) {
        GL12.glDrawRangeElements((int)mode, (int)start, (int)end, (int)count, (int)type, (long)offset);
    }

    public void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, Buffer pixels) {
        if (pixels == null) {
            GL12.glTexImage3D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, (int)format, (int)type, (ByteBuffer)null);
        } else if (pixels instanceof ByteBuffer) {
            GL12.glTexImage3D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, (int)format, (int)type, (ByteBuffer)((ByteBuffer)pixels));
        } else if (pixels instanceof ShortBuffer) {
            GL12.glTexImage3D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, (int)format, (int)type, (ShortBuffer)((ShortBuffer)pixels));
        } else if (pixels instanceof IntBuffer) {
            GL12.glTexImage3D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, (int)format, (int)type, (IntBuffer)((IntBuffer)pixels));
        } else if (pixels instanceof FloatBuffer) {
            GL12.glTexImage3D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, (int)format, (int)type, (FloatBuffer)((FloatBuffer)pixels));
        } else if (pixels instanceof DoubleBuffer) {
            GL12.glTexImage3D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, (int)format, (int)type, (DoubleBuffer)((DoubleBuffer)pixels));
        } else {
            throw new GdxRuntimeException("Can't use " + pixels.getClass().getName() + " with this method. Use ByteBuffer, ShortBuffer, IntBuffer, FloatBuffer or DoubleBuffer instead. Blame LWJGL");
        }
    }

    public void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, int offset) {
        GL12.glTexImage3D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, (int)format, (int)type, (long)offset);
    }

    public void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, Buffer pixels) {
        if (pixels instanceof ByteBuffer) {
            GL12.glTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (ByteBuffer)((ByteBuffer)pixels));
        } else if (pixels instanceof ShortBuffer) {
            GL12.glTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (ShortBuffer)((ShortBuffer)pixels));
        } else if (pixels instanceof IntBuffer) {
            GL12.glTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (IntBuffer)((IntBuffer)pixels));
        } else if (pixels instanceof FloatBuffer) {
            GL12.glTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (FloatBuffer)((FloatBuffer)pixels));
        } else if (pixels instanceof DoubleBuffer) {
            GL12.glTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (DoubleBuffer)((DoubleBuffer)pixels));
        } else {
            throw new GdxRuntimeException("Can't use " + pixels.getClass().getName() + " with this method. Use ByteBuffer, ShortBuffer, IntBuffer, FloatBuffer or DoubleBuffer instead. Blame LWJGL");
        }
    }

    public void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int offset) {
        GL12.glTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (long)offset);
    }

    public void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        GL12.glCopyTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)x, (int)y, (int)width, (int)height);
    }

    public void glGenQueries(int n, int[] ids, int offset) {
        for (int i = offset; i < offset + n; ++i) {
            ids[i] = GL15.glGenQueries();
        }
    }

    public void glGenQueries(int n, IntBuffer ids) {
        for (int i = 0; i < n; ++i) {
            ids.put(GL15.glGenQueries());
        }
    }

    public void glDeleteQueries(int n, int[] ids, int offset) {
        for (int i = offset; i < offset + n; ++i) {
            GL15.glDeleteQueries((int)ids[i]);
        }
    }

    public void glDeleteQueries(int n, IntBuffer ids) {
        for (int i = 0; i < n; ++i) {
            GL15.glDeleteQueries((int)ids.get());
        }
    }

    public boolean glIsQuery(int id) {
        return GL15.glIsQuery((int)id);
    }

    public void glBeginQuery(int target, int id) {
        GL15.glBeginQuery((int)target, (int)id);
    }

    public void glEndQuery(int target) {
        GL15.glEndQuery((int)target);
    }

    public void glGetQueryiv(int target, int pname, IntBuffer params) {
        GL15.glGetQuery((int)target, (int)pname, (IntBuffer)params);
    }

    public void glGetQueryObjectuiv(int id, int pname, IntBuffer params) {
        GL15.glGetQueryObjectu((int)id, (int)pname, (IntBuffer)params);
    }

    public boolean glUnmapBuffer(int target) {
        return GL15.glUnmapBuffer((int)target);
    }

    public Buffer glGetBufferPointerv(int target, int pname) {
        return GL15.glGetBufferPointer((int)target, (int)pname);
    }

    public void glDrawBuffers(int n, IntBuffer bufs) {
        int limit = bufs.limit();
        ((Buffer)bufs).limit(n);
        GL20.glDrawBuffers((IntBuffer)bufs);
        ((Buffer)bufs).limit(limit);
    }

    public void glUniformMatrix2x3fv(int location, int count, boolean transpose, FloatBuffer value) {
        GL21.glUniformMatrix2x3((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public void glUniformMatrix3x2fv(int location, int count, boolean transpose, FloatBuffer value) {
        GL21.glUniformMatrix3x2((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public void glUniformMatrix2x4fv(int location, int count, boolean transpose, FloatBuffer value) {
        GL21.glUniformMatrix2x4((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public void glUniformMatrix4x2fv(int location, int count, boolean transpose, FloatBuffer value) {
        GL21.glUniformMatrix4x2((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public void glUniformMatrix3x4fv(int location, int count, boolean transpose, FloatBuffer value) {
        GL21.glUniformMatrix3x4((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public void glUniformMatrix4x3fv(int location, int count, boolean transpose, FloatBuffer value) {
        GL21.glUniformMatrix4x3((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        org.lwjgl.opengl.GL30.glBlitFramebuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
    }

    @Override
    public void glBindFramebuffer(int target, int framebuffer) {
        org.lwjgl.opengl.GL30.glBindFramebuffer((int)target, (int)framebuffer);
    }

    @Override
    public void glBindRenderbuffer(int target, int renderbuffer) {
        org.lwjgl.opengl.GL30.glBindRenderbuffer((int)target, (int)renderbuffer);
    }

    @Override
    public int glCheckFramebufferStatus(int target) {
        return org.lwjgl.opengl.GL30.glCheckFramebufferStatus((int)target);
    }

    @Override
    public void glDeleteFramebuffers(int n, IntBuffer framebuffers) {
        org.lwjgl.opengl.GL30.glDeleteFramebuffers((IntBuffer)framebuffers);
    }

    @Override
    public void glDeleteFramebuffer(int framebuffer) {
        org.lwjgl.opengl.GL30.glDeleteFramebuffers((int)framebuffer);
    }

    @Override
    public void glDeleteRenderbuffers(int n, IntBuffer renderbuffers) {
        org.lwjgl.opengl.GL30.glDeleteRenderbuffers((IntBuffer)renderbuffers);
    }

    @Override
    public void glDeleteRenderbuffer(int renderbuffer) {
        org.lwjgl.opengl.GL30.glDeleteRenderbuffers((int)renderbuffer);
    }

    @Override
    public void glGenerateMipmap(int target) {
        org.lwjgl.opengl.GL30.glGenerateMipmap((int)target);
    }

    @Override
    public void glGenFramebuffers(int n, IntBuffer framebuffers) {
        org.lwjgl.opengl.GL30.glGenFramebuffers((IntBuffer)framebuffers);
    }

    @Override
    public int glGenFramebuffer() {
        return org.lwjgl.opengl.GL30.glGenFramebuffers();
    }

    @Override
    public void glGenRenderbuffers(int n, IntBuffer renderbuffers) {
        org.lwjgl.opengl.GL30.glGenRenderbuffers((IntBuffer)renderbuffers);
    }

    @Override
    public int glGenRenderbuffer() {
        return org.lwjgl.opengl.GL30.glGenRenderbuffers();
    }

    @Override
    public void glGetRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        org.lwjgl.opengl.GL30.glGetRenderbufferParameter((int)target, (int)pname, (IntBuffer)params);
    }

    @Override
    public boolean glIsFramebuffer(int framebuffer) {
        return org.lwjgl.opengl.GL30.glIsFramebuffer((int)framebuffer);
    }

    @Override
    public boolean glIsRenderbuffer(int renderbuffer) {
        return org.lwjgl.opengl.GL30.glIsRenderbuffer((int)renderbuffer);
    }

    @Override
    public void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        org.lwjgl.opengl.GL30.glRenderbufferStorage((int)target, (int)internalformat, (int)width, (int)height);
    }

    public void glRenderbufferStorageMultisample(int target, int samples, int internalformat, int width, int height) {
        org.lwjgl.opengl.GL30.glRenderbufferStorageMultisample((int)target, (int)samples, (int)internalformat, (int)width, (int)height);
    }

    @Override
    public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        org.lwjgl.opengl.GL30.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
    }

    @Override
    public void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        org.lwjgl.opengl.GL30.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
    }

    public void glFramebufferTextureLayer(int target, int attachment, int texture, int level, int layer) {
        org.lwjgl.opengl.GL30.glFramebufferTextureLayer((int)target, (int)attachment, (int)texture, (int)level, (int)layer);
    }

    public Buffer glMapBufferRange(int target, int offset, int length, int access) {
        return org.lwjgl.opengl.GL30.glMapBufferRange((int)target, (long)offset, (long)length, (int)access, null);
    }

    public void glFlushMappedBufferRange(int target, int offset, int length) {
        org.lwjgl.opengl.GL30.glFlushMappedBufferRange((int)target, (long)offset, (long)length);
    }

    public void glBindVertexArray(int array) {
        org.lwjgl.opengl.GL30.glBindVertexArray((int)array);
    }

    public void glDeleteVertexArrays(int n, int[] arrays, int offset) {
        for (int i = offset; i < offset + n; ++i) {
            org.lwjgl.opengl.GL30.glDeleteVertexArrays((int)arrays[i]);
        }
    }

    public void glDeleteVertexArrays(int n, IntBuffer arrays) {
        org.lwjgl.opengl.GL30.glDeleteVertexArrays((IntBuffer)arrays);
    }

    public void glGenVertexArrays(int n, int[] arrays, int offset) {
        for (int i = offset; i < offset + n; ++i) {
            arrays[i] = org.lwjgl.opengl.GL30.glGenVertexArrays();
        }
    }

    public void glGenVertexArrays(int n, IntBuffer arrays) {
        org.lwjgl.opengl.GL30.glGenVertexArrays((IntBuffer)arrays);
    }

    public boolean glIsVertexArray(int array) {
        return org.lwjgl.opengl.GL30.glIsVertexArray((int)array);
    }

    public void glBeginTransformFeedback(int primitiveMode) {
        org.lwjgl.opengl.GL30.glBeginTransformFeedback((int)primitiveMode);
    }

    public void glEndTransformFeedback() {
        org.lwjgl.opengl.GL30.glEndTransformFeedback();
    }

    public void glBindBufferRange(int target, int index, int buffer, int offset, int size) {
        org.lwjgl.opengl.GL30.glBindBufferRange((int)target, (int)index, (int)buffer, (long)offset, (long)size);
    }

    public void glBindBufferBase(int target, int index, int buffer) {
        org.lwjgl.opengl.GL30.glBindBufferBase((int)target, (int)index, (int)buffer);
    }

    public void glTransformFeedbackVaryings(int program, String[] varyings, int bufferMode) {
        org.lwjgl.opengl.GL30.glTransformFeedbackVaryings((int)program, (CharSequence[])varyings, (int)bufferMode);
    }

    public void glVertexAttribIPointer(int index, int size, int type, int stride, int offset) {
        org.lwjgl.opengl.GL30.glVertexAttribIPointer((int)index, (int)size, (int)type, (int)stride, (long)offset);
    }

    public void glGetVertexAttribIiv(int index, int pname, IntBuffer params) {
        org.lwjgl.opengl.GL30.glGetVertexAttribI((int)index, (int)pname, (IntBuffer)params);
    }

    public void glGetVertexAttribIuiv(int index, int pname, IntBuffer params) {
        org.lwjgl.opengl.GL30.glGetVertexAttribIu((int)index, (int)pname, (IntBuffer)params);
    }

    public void glVertexAttribI4i(int index, int x, int y, int z, int w) {
        org.lwjgl.opengl.GL30.glVertexAttribI4i((int)index, (int)x, (int)y, (int)z, (int)w);
    }

    public void glVertexAttribI4ui(int index, int x, int y, int z, int w) {
        org.lwjgl.opengl.GL30.glVertexAttribI4ui((int)index, (int)x, (int)y, (int)z, (int)w);
    }

    public void glGetUniformuiv(int program, int location, IntBuffer params) {
        org.lwjgl.opengl.GL30.glGetUniformu((int)program, (int)location, (IntBuffer)params);
    }

    public int glGetFragDataLocation(int program, String name) {
        return org.lwjgl.opengl.GL30.glGetFragDataLocation((int)program, (CharSequence)name);
    }

    public void glUniform1uiv(int location, int count, IntBuffer value) {
        org.lwjgl.opengl.GL30.glUniform1u((int)location, (IntBuffer)value);
    }

    public void glUniform3uiv(int location, int count, IntBuffer value) {
        org.lwjgl.opengl.GL30.glUniform3u((int)location, (IntBuffer)value);
    }

    public void glUniform4uiv(int location, int count, IntBuffer value) {
        org.lwjgl.opengl.GL30.glUniform4u((int)location, (IntBuffer)value);
    }

    public void glClearBufferiv(int buffer, int drawbuffer, IntBuffer value) {
        org.lwjgl.opengl.GL30.glClearBuffer((int)buffer, (int)drawbuffer, (IntBuffer)value);
    }

    public void glClearBufferuiv(int buffer, int drawbuffer, IntBuffer value) {
        org.lwjgl.opengl.GL30.glClearBufferu((int)buffer, (int)drawbuffer, (IntBuffer)value);
    }

    public void glClearBufferfv(int buffer, int drawbuffer, FloatBuffer value) {
        org.lwjgl.opengl.GL30.glClearBuffer((int)buffer, (int)drawbuffer, (FloatBuffer)value);
    }

    public void glClearBufferfi(int buffer, int drawbuffer, float depth, int stencil) {
        org.lwjgl.opengl.GL30.glClearBufferfi((int)buffer, (int)drawbuffer, (float)depth, (int)stencil);
    }

    public String glGetStringi(int name, int index) {
        return org.lwjgl.opengl.GL30.glGetStringi((int)name, (int)index);
    }

    public void glCopyBufferSubData(int readTarget, int writeTarget, int readOffset, int writeOffset, int size) {
        GL31.glCopyBufferSubData((int)readTarget, (int)writeTarget, (long)readOffset, (long)writeOffset, (long)size);
    }

    public void glGetUniformIndices(int program, String[] uniformNames, IntBuffer uniformIndices) {
        GL31.glGetUniformIndices((int)program, (CharSequence[])uniformNames, (IntBuffer)uniformIndices);
    }

    public void glGetActiveUniformsiv(int program, int uniformCount, IntBuffer uniformIndices, int pname, IntBuffer params) {
        GL31.glGetActiveUniforms((int)program, (IntBuffer)uniformIndices, (int)pname, (IntBuffer)params);
    }

    public int glGetUniformBlockIndex(int program, String uniformBlockName) {
        return GL31.glGetUniformBlockIndex((int)program, (CharSequence)uniformBlockName);
    }

    public void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, IntBuffer params) {
        GL31.glGetActiveUniformBlock((int)program, (int)uniformBlockIndex, (int)pname, (IntBuffer)params);
    }

    public void glGetActiveUniformBlockName(int program, int uniformBlockIndex, Buffer length, Buffer uniformBlockName) {
        GL31.glGetActiveUniformBlockName((int)program, (int)uniformBlockIndex, (IntBuffer)((IntBuffer)length), (ByteBuffer)((ByteBuffer)uniformBlockName));
    }

    public String glGetActiveUniformBlockName(int program, int uniformBlockIndex) {
        return GL31.glGetActiveUniformBlockName((int)program, (int)uniformBlockIndex, (int)1024);
    }

    public void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding) {
        GL31.glUniformBlockBinding((int)program, (int)uniformBlockIndex, (int)uniformBlockBinding);
    }

    public void glDrawArraysInstanced(int mode, int first, int count, int instanceCount) {
        GL31.glDrawArraysInstanced((int)mode, (int)first, (int)count, (int)instanceCount);
    }

    public void glDrawElementsInstanced(int mode, int count, int type, int indicesOffset, int instanceCount) {
        GL31.glDrawElementsInstanced((int)mode, (int)count, (int)type, (long)indicesOffset, (int)instanceCount);
    }

    public void glGetInteger64v(int pname, LongBuffer params) {
        GL32.glGetInteger64((int)pname, (LongBuffer)params);
    }

    public void glGetBufferParameteri64v(int target, int pname, LongBuffer params) {
        params.put(GL32.glGetBufferParameteri64((int)target, (int)pname));
    }

    public void glGenSamplers(int count, int[] samplers, int offset) {
        for (int i = offset; i < offset + count; ++i) {
            samplers[i] = GL33.glGenSamplers();
        }
    }

    public void glGenSamplers(int count, IntBuffer samplers) {
        GL33.glGenSamplers((IntBuffer)samplers);
    }

    public void glDeleteSamplers(int count, int[] samplers, int offset) {
        for (int i = offset; i < offset + count; ++i) {
            GL33.glDeleteSamplers((int)samplers[i]);
        }
    }

    public void glDeleteSamplers(int count, IntBuffer samplers) {
        GL33.glDeleteSamplers((IntBuffer)samplers);
    }

    public boolean glIsSampler(int sampler) {
        return GL33.glIsSampler((int)sampler);
    }

    public void glBindSampler(int unit, int sampler) {
        GL33.glBindSampler((int)unit, (int)sampler);
    }

    public void glSamplerParameteri(int sampler, int pname, int param) {
        GL33.glSamplerParameteri((int)sampler, (int)pname, (int)param);
    }

    public void glSamplerParameteriv(int sampler, int pname, IntBuffer param) {
        GL33.glSamplerParameter((int)sampler, (int)pname, (IntBuffer)param);
    }

    public void glSamplerParameterf(int sampler, int pname, float param) {
        GL33.glSamplerParameterf((int)sampler, (int)pname, (float)param);
    }

    public void glSamplerParameterfv(int sampler, int pname, FloatBuffer param) {
        GL33.glSamplerParameter((int)sampler, (int)pname, (FloatBuffer)param);
    }

    public void glGetSamplerParameteriv(int sampler, int pname, IntBuffer params) {
        GL33.glGetSamplerParameterI((int)sampler, (int)pname, (IntBuffer)params);
    }

    public void glGetSamplerParameterfv(int sampler, int pname, FloatBuffer params) {
        GL33.glGetSamplerParameter((int)sampler, (int)pname, (FloatBuffer)params);
    }

    public void glVertexAttribDivisor(int index, int divisor) {
        GL33.glVertexAttribDivisor((int)index, (int)divisor);
    }

    public void glBindTransformFeedback(int target, int id) {
        GL40.glBindTransformFeedback((int)target, (int)id);
    }

    public void glDeleteTransformFeedbacks(int n, int[] ids, int offset) {
        for (int i = offset; i < offset + n; ++i) {
            GL40.glDeleteTransformFeedbacks((int)ids[i]);
        }
    }

    public void glDeleteTransformFeedbacks(int n, IntBuffer ids) {
        GL40.glDeleteTransformFeedbacks((IntBuffer)ids);
    }

    public void glGenTransformFeedbacks(int n, int[] ids, int offset) {
        for (int i = offset; i < offset + n; ++i) {
            ids[i] = GL40.glGenTransformFeedbacks();
        }
    }

    public void glGenTransformFeedbacks(int n, IntBuffer ids) {
        GL40.glGenTransformFeedbacks((IntBuffer)ids);
    }

    public boolean glIsTransformFeedback(int id) {
        return GL40.glIsTransformFeedback((int)id);
    }

    public void glPauseTransformFeedback() {
        GL40.glPauseTransformFeedback();
    }

    public void glResumeTransformFeedback() {
        GL40.glResumeTransformFeedback();
    }

    public void glProgramParameteri(int program, int pname, int value) {
        GL41.glProgramParameteri((int)program, (int)pname, (int)value);
    }

    public void glInvalidateFramebuffer(int target, int numAttachments, IntBuffer attachments) {
        GL43.glInvalidateFramebuffer((int)target, (IntBuffer)attachments);
    }

    public void glInvalidateSubFramebuffer(int target, int numAttachments, IntBuffer attachments, int x, int y, int width, int height) {
        GL43.glInvalidateSubFramebuffer((int)target, (IntBuffer)attachments, (int)x, (int)y, (int)width, (int)height);
    }
}

