/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.CLICol;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.LoggerKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ'\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lorg/veiset/kgame/engine/TimeSummed;", "", "summaryText", "", "padding", "", "(Ljava/lang/String;I)V", "getPadding", "()I", "getSummaryText", "()Ljava/lang/String;", "timeMap", "", "Lkotlin/time/Duration;", "display", "", "time", "T", "key", "f", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kgame2"})
public final class TimeSummed {
    @NotNull
    private final String summaryText;
    private final int padding;
    @NotNull
    private final Map<String, Duration> timeMap;

    public TimeSummed(@NotNull String summaryText, int padding) {
        Intrinsics.checkNotNullParameter((Object)summaryText, (String)"summaryText");
        this.summaryText = summaryText;
        this.padding = padding;
        boolean bl = false;
        this.timeMap = new LinkedHashMap();
    }

    public /* synthetic */ TimeSummed(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "Sum of calls";
        }
        if ((n2 & 2) != 0) {
            n = 8;
        }
        this(string, n);
    }

    @NotNull
    public final String getSummaryText() {
        return this.summaryText;
    }

    public final int getPadding() {
        return this.padding;
    }

    public final <T> T time(@NotNull String key, @NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        boolean $i$f$measureTimedValue = false;
        boolean bl = false;
        TimeSource $this$measureTimedValue$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        boolean bl2 = false;
        TimeMark mark$iv$iv = $this$measureTimedValue$iv$iv.markNow();
        Object result$iv$iv = f.invoke();
        TimedValue timed = new TimedValue(result$iv$iv, mark$iv$iv.elapsedNow-UwyO8pc(), null);
        long elapsed = this.timeMap.getOrDefault(key, Duration.box-impl((long)Duration.Companion.getZERO-UwyO8pc())).unbox-impl();
        Map<String, Duration> map = this.timeMap;
        Duration duration2 = Duration.box-impl((long)Duration.plus-LRDsOJo((long)elapsed, (long)timed.getDuration-UwyO8pc()));
        boolean bl3 = false;
        map.put(key, duration2);
        return (T)timed.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void display() {
        Object object;
        void $this$mapTo$iv$iv;
        Float f;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = this.timeMap.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            long l = ((Duration)item$iv$iv2).unbox-impl();
            collection = destination$iv$iv;
            boolean bl = false;
            f = Float.valueOf((float)Duration.getInWholeNanoseconds-impl((long)it) / 1000000.0f);
            collection.add(f);
        }
        float totalTime = CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv));
        String c = LoggerKt.c(CLICol.GREEN, "\u23f2");
        Log.INSTANCE.debug(c + ' ' + this.summaryText + " (" + totalTime + "ms)");
        Map<String, Duration> $this$map$iv2 = this.timeMap;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        item$iv$iv2 = $this$mapTo$iv$iv;
        boolean it = false;
        Iterator iterator = item$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            void $dstr$k$v;
            Map.Entry item$iv$iv3;
            Map.Entry entry = item$iv$iv3 = iterator.next();
            collection = destination$iv$iv2;
            boolean bl5 = false;
            object = $dstr$k$v;
            boolean bl2 = false;
            String k = (String)object.getKey();
            void var17_35 = $dstr$k$v;
            boolean bl3 = false;
            long v = ((Duration)var17_35.getValue()).unbox-impl();
            f = new Pair((Object)k, (Object)Duration.box-impl((long)v));
            collection.add(f);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)b;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Duration)it.getSecond());
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Duration duration2 = (Duration)it.getSecond();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)duration2));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair $dstr$key$duration = (Pair)element$iv;
            boolean bl4 = false;
            String key = (String)$dstr$key$duration.component1();
            long duration2 = ((Duration)$dstr$key$duration.component2()).unbox-impl();
            float time = (float)Duration.getInWholeNanoseconds-impl((long)duration2) / 1000000.0f;
            String bl5 = "%.2f";
            object = new Object[]{Float.valueOf(time / totalTime * 100.0f)};
            boolean bl6 = false;
            String string = String.format(bl5, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(this, *args)");
            String timeOfTotal = StringsKt.padStart$default((String)string, (int)6, (char)'\u0000', (int)2, null);
            object = "%.4f";
            Object[] objectArray = new Object[]{Float.valueOf(time)};
            boolean bl7 = false;
            String string2 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
            String formattedNumber = StringsKt.padStart$default((String)string2, (int)this.getPadding(), (char)'\u0000', (int)2, null);
            Log.INSTANCE.debug(LoggerKt.cb(CLICol.GREEN, " \u21b3") + ' ' + timeOfTotal + "% " + formattedNumber + "ms - " + key);
        }
    }

    public TimeSummed() {
        this(null, 0, 3, null);
    }
}

