/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.asset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.TimeSummed;
import org.veiset.kgame.engine.asset.AssetLoader;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.asset.assetloader.AnimationLoader;
import org.veiset.kgame.engine.asset.assetloader.AnimationSetLoader;
import org.veiset.kgame.engine.asset.assetloader.BitmapFontLoader;
import org.veiset.kgame.engine.asset.assetloader.IconLoader;
import org.veiset.kgame.engine.asset.assetloader.MusicLoader;
import org.veiset.kgame.engine.asset.assetloader.SoundLoader;
import org.veiset.kgame.engine.asset.assetloader.TextureLoader;
import org.veiset.kgame.engine.asset.assetloader.TilesetLoader;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002=>B\u0005\u00a2\u0006\u0002\u0010\u0002JS\u0010\u001d\u001a\u00020\u001e\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u0001\"\n\b\u0001\u0010 \u0018\u0001*\u00020\u0001\"\u0016\b\u0002\u0010!\u0018\u0001*\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H 0\u00052\u0018\u0010\"\u001a\u0014\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u0002H!0\u0012H\u0086\bJ\u0017\u0010#\u001a\b\u0012\u0004\u0012\u0002H 0$\"\u0006\b\u0000\u0010 \u0018\u0001H\u0086\bJ=\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u0002H 0&0$\"\u0014\b\u0000\u0010!\u0018\u0001*\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H 0\u0005\"\n\b\u0001\u0010 \u0018\u0001*\u00020\u0001H\u0086\bJ\u0006\u0010'\u001a\u00020\u001eJ5\u0010(\u001a\u00020\u0015\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u0001\"\n\b\u0001\u0010 \u0018\u0001*\u00020\u00012\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H 0\u0005H\u0086\bJ:\u0010*\u001a\u0002H \"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u0001\"\n\b\u0001\u0010 \u0018\u0001*\u00020\u00012\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H 0\u0005H\u0086\b\u00a2\u0006\u0002\u0010+J\u001e\u0010,\u001a\u0002H-\"\u0006\b\u0000\u0010-\u0018\u00012\u0006\u0010.\u001a\u00020\tH\u0086\b\u00a2\u0006\u0002\u0010/J\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u000201JF\u00103\u001a\u00020\u001e\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u0001\"\n\b\u0001\u0010 \u0018\u0001*\u00020\u0001\"\u0016\b\u0002\u0010!\u0018\u0001*\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H 0\u00052\u0006\u0010)\u001a\u0002H!H\u0086\b\u00a2\u0006\u0002\u00104JR\u00103\u001a\u00020\u001e\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u0001\"\n\b\u0001\u0010 \u0018\u0001*\u00020\u0001\"\u0016\b\u0002\u0010!\u0018\u0001*\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H 0\u00052\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u0002H!06\"\u0002H!H\u0086\b\u00a2\u0006\u0002\u00107JF\u00108\u001a\u00020\u001e\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u0001\"\n\b\u0001\u0010 \u0018\u0001*\u00020\u0001\"\u0016\b\u0002\u0010!\u0018\u0001*\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H 0\u00052\u0006\u0010)\u001a\u0002H!H\u0086\b\u00a2\u0006\u0002\u00104J\u0006\u00109\u001a\u00020\u0015J\u0006\u0010:\u001a\u00020\u001eJ\u0006\u0010;\u001a\u00020\u001eJF\u0010<\u001a\u00020\u001e\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u0001\"\n\b\u0001\u0010 \u0018\u0001*\u00020\u0001\"\u0016\b\u0002\u0010!\u0018\u0001*\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H 0\u00052\u0006\u0010)\u001a\u0002H!H\u0086\b\u00a2\u0006\u0002\u00104R%\u0010\u0003\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R#\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR-\u0010\u0010\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00120\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R#\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000f\u00a8\u0006?"}, d2={"Lorg/veiset/kgame/engine/asset/AssetManager;", "", "()V", "assets", "", "Lorg/veiset/kgame/engine/asset/AssetRef;", "getAssets", "()Ljava/util/Map;", "assetsIdMap", "", "getAssetsIdMap", "asyncLoadQueue", "", "Lorg/veiset/kgame/engine/asset/AssetManager$QueueAsync;", "getAsyncLoadQueue", "()Ljava/util/List;", "loaders", "Lkotlin/reflect/KClass;", "Lorg/veiset/kgame/engine/asset/AssetLoader;", "getLoaders", "processing", "", "getProcessing", "()Z", "setProcessing", "(Z)V", "syncLoadQueue", "Lorg/veiset/kgame/engine/asset/AssetManager$QueueSync;", "getSyncLoadQueue", "addLoader", "", "E", "ASSET", "REF", "assetLoader", "all", "", "allRefs", "Lkotlin/Pair;", "clear", "contains", "assetRef", "get", "(Lorg/veiset/kgame/engine/asset/AssetRef;)Ljava/lang/Object;", "getById", "T", "id", "(Ljava/lang/String;)Ljava/lang/Object;", "getLoaded", "", "getTotal", "load", "(Lorg/veiset/kgame/engine/asset/AssetRef;)V", "assetRefs", "", "([Lorg/veiset/kgame/engine/asset/AssetRef;)V", "loadSync", "needsSyncProcess", "preprocess", "processSync", "unload", "QueueAsync", "QueueSync", "kgame2"})
public final class AssetManager {
    @NotNull
    private final Map<KClass<?>, AssetLoader<?, ?, ?>> loaders;
    @NotNull
    private final List<QueueAsync<?, ?, ?>> asyncLoadQueue;
    @NotNull
    private final List<QueueSync<?, ?, ?>> syncLoadQueue;
    @NotNull
    private final Map<AssetRef<?, ?>, Object> assets;
    @NotNull
    private final Map<String, Object> assetsIdMap;
    private boolean processing;

    public AssetManager() {
        boolean bl = false;
        this.loaders = new LinkedHashMap();
        bl = false;
        this.asyncLoadQueue = new ArrayList();
        bl = false;
        this.syncLoadQueue = new ArrayList();
        bl = false;
        this.assets = new LinkedHashMap();
        bl = false;
        this.assetsIdMap = new LinkedHashMap();
        LoggerKt.logTimed$default("Added asset loaders", null, null, 0, (Function0)new Function0<Unit>(){

            public final void invoke() {
                boolean bl;
                KClass kClass;
                Map<KClass<?>, AssetLoader<?, ?, ?>> map;
                AssetManager this_$iv;
                AssetManager assetManager = this;
                AssetLoader assetLoader$iv = new AnimationLoader();
                boolean $i$f$addLoader = false;
                if (this_$iv.getLoaders().containsKey(Reflection.getOrCreateKotlinClass(AssetRef.AnimationRef.class))) {
                    Log.INSTANCE.error("Loader '" + Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName() + "' already registered");
                } else {
                    Log.INSTANCE.info(Intrinsics.stringPlus((String)"Adding asset loader: ", (Object)Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName()));
                    map = this_$iv.getLoaders();
                    kClass = Reflection.getOrCreateKotlinClass(AssetRef.AnimationRef.class);
                    bl = false;
                    map.put(kClass, assetLoader$iv);
                }
                this_$iv = this;
                assetLoader$iv = new SoundLoader();
                $i$f$addLoader = false;
                if (this_$iv.getLoaders().containsKey(Reflection.getOrCreateKotlinClass(AssetRef.SoundRef.class))) {
                    Log.INSTANCE.error("Loader '" + Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName() + "' already registered");
                } else {
                    Log.INSTANCE.info(Intrinsics.stringPlus((String)"Adding asset loader: ", (Object)Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName()));
                    map = this_$iv.getLoaders();
                    kClass = Reflection.getOrCreateKotlinClass(AssetRef.SoundRef.class);
                    bl = false;
                    map.put(kClass, assetLoader$iv);
                }
                this_$iv = this;
                assetLoader$iv = new MusicLoader();
                $i$f$addLoader = false;
                if (this_$iv.getLoaders().containsKey(Reflection.getOrCreateKotlinClass(AssetRef.MusicRef.class))) {
                    Log.INSTANCE.error("Loader '" + Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName() + "' already registered");
                } else {
                    Log.INSTANCE.info(Intrinsics.stringPlus((String)"Adding asset loader: ", (Object)Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName()));
                    map = this_$iv.getLoaders();
                    kClass = Reflection.getOrCreateKotlinClass(AssetRef.MusicRef.class);
                    bl = false;
                    map.put(kClass, assetLoader$iv);
                }
                this_$iv = this;
                assetLoader$iv = new TextureLoader();
                $i$f$addLoader = false;
                if (this_$iv.getLoaders().containsKey(Reflection.getOrCreateKotlinClass(AssetRef.TextureRef.class))) {
                    Log.INSTANCE.error("Loader '" + Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName() + "' already registered");
                } else {
                    Log.INSTANCE.info(Intrinsics.stringPlus((String)"Adding asset loader: ", (Object)Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName()));
                    map = this_$iv.getLoaders();
                    kClass = Reflection.getOrCreateKotlinClass(AssetRef.TextureRef.class);
                    bl = false;
                    map.put(kClass, assetLoader$iv);
                }
                this_$iv = this;
                assetLoader$iv = new BitmapFontLoader();
                $i$f$addLoader = false;
                if (this_$iv.getLoaders().containsKey(Reflection.getOrCreateKotlinClass(AssetRef.BitmapFontRef.class))) {
                    Log.INSTANCE.error("Loader '" + Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName() + "' already registered");
                } else {
                    Log.INSTANCE.info(Intrinsics.stringPlus((String)"Adding asset loader: ", (Object)Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName()));
                    map = this_$iv.getLoaders();
                    kClass = Reflection.getOrCreateKotlinClass(AssetRef.BitmapFontRef.class);
                    bl = false;
                    map.put(kClass, assetLoader$iv);
                }
                this_$iv = this;
                assetLoader$iv = new AnimationSetLoader();
                $i$f$addLoader = false;
                if (this_$iv.getLoaders().containsKey(Reflection.getOrCreateKotlinClass(AssetRef.AnimationSetRef.class))) {
                    Log.INSTANCE.error("Loader '" + Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName() + "' already registered");
                } else {
                    Log.INSTANCE.info(Intrinsics.stringPlus((String)"Adding asset loader: ", (Object)Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName()));
                    map = this_$iv.getLoaders();
                    kClass = Reflection.getOrCreateKotlinClass(AssetRef.AnimationSetRef.class);
                    bl = false;
                    map.put(kClass, assetLoader$iv);
                }
                this_$iv = this;
                assetLoader$iv = new TilesetLoader();
                $i$f$addLoader = false;
                if (this_$iv.getLoaders().containsKey(Reflection.getOrCreateKotlinClass(AssetRef.TilesetRef.class))) {
                    Log.INSTANCE.error("Loader '" + Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName() + "' already registered");
                } else {
                    Log.INSTANCE.info(Intrinsics.stringPlus((String)"Adding asset loader: ", (Object)Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName()));
                    map = this_$iv.getLoaders();
                    kClass = Reflection.getOrCreateKotlinClass(AssetRef.TilesetRef.class);
                    bl = false;
                    map.put(kClass, assetLoader$iv);
                }
                this_$iv = this;
                assetLoader$iv = new IconLoader();
                $i$f$addLoader = false;
                if (this_$iv.getLoaders().containsKey(Reflection.getOrCreateKotlinClass(AssetRef.IconRef.class))) {
                    Log.INSTANCE.error("Loader '" + Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName() + "' already registered");
                } else {
                    Log.INSTANCE.info(Intrinsics.stringPlus((String)"Adding asset loader: ", (Object)Reflection.getOrCreateKotlinClass(assetLoader$iv.getClass()).getQualifiedName()));
                    map = this_$iv.getLoaders();
                    kClass = Reflection.getOrCreateKotlinClass(AssetRef.IconRef.class);
                    bl = false;
                    map.put(kClass, assetLoader$iv);
                }
            }
        }, 14, null);
    }

    @NotNull
    public final Map<KClass<?>, AssetLoader<?, ?, ?>> getLoaders() {
        return this.loaders;
    }

    @NotNull
    public final List<QueueAsync<?, ?, ?>> getAsyncLoadQueue() {
        return this.asyncLoadQueue;
    }

    @NotNull
    public final List<QueueSync<?, ?, ?>> getSyncLoadQueue() {
        return this.syncLoadQueue;
    }

    @NotNull
    public final Map<AssetRef<?, ?>, Object> getAssets() {
        return this.assets;
    }

    @NotNull
    public final Map<String, Object> getAssetsIdMap() {
        return this.assetsIdMap;
    }

    public final boolean needsSyncProcess() {
        Collection collection = this.syncLoadQueue;
        boolean bl = false;
        return !collection.isEmpty() && !this.processing;
    }

    public final int getTotal() {
        return this.assets.keySet().size() + this.syncLoadQueue.size() + this.asyncLoadQueue.size();
    }

    public final int getLoaded() {
        return this.assets.keySet().size() + this.syncLoadQueue.size();
    }

    public final boolean getProcessing() {
        return this.processing;
    }

    public final void setProcessing(boolean bl) {
        this.processing = bl;
    }

    public final /* synthetic */ <E, ASSET, REF extends AssetRef<E, ASSET>> void addLoader(AssetLoader<E, ASSET, REF> assetLoader) {
        Intrinsics.checkNotNullParameter(assetLoader, (String)"assetLoader");
        boolean $i$f$addLoader = false;
        Map<KClass<?>, AssetLoader<?, ?, ?>> map = this.getLoaders();
        Intrinsics.reifiedOperationMarker((int)4, (String)"REF");
        if (map.containsKey(Reflection.getOrCreateKotlinClass(AssetRef.class))) {
            Log.INSTANCE.error("Loader '" + Reflection.getOrCreateKotlinClass(assetLoader.getClass()).getQualifiedName() + "' already registered");
        } else {
            Log.INSTANCE.info(Intrinsics.stringPlus((String)"Adding asset loader: ", (Object)Reflection.getOrCreateKotlinClass(assetLoader.getClass()).getQualifiedName()));
            Map<KClass<?>, AssetLoader<?, ?, ?>> map2 = this.getLoaders();
            Intrinsics.reifiedOperationMarker((int)4, (String)"REF");
            KClass kClass = Reflection.getOrCreateKotlinClass(AssetRef.class);
            boolean bl = false;
            map2.put(kClass, assetLoader);
        }
    }

    public final /* synthetic */ <E, ASSET, REF extends AssetRef<E, ASSET>> void load(REF ... assetRefs) {
        Intrinsics.checkNotNullParameter(assetRefs, (String)"assetRefs");
        boolean $i$f$load = false;
        REF[] $this$forEach$iv = assetRefs;
        boolean $i$f$forEach = false;
        for (REF element$iv : $this$forEach$iv) {
            AssetRef it = (AssetRef)element$iv;
            boolean bl = false;
            AssetManager this_$iv = this;
            boolean $i$f$load2 = false;
            Map<KClass<?>, AssetLoader<?, ?, ?>> map = this_$iv.getLoaders();
            Intrinsics.reifiedOperationMarker((int)4, (String)"REF");
            if (map.get(Reflection.getOrCreateKotlinClass(AssetRef.class)) == null) {
                Intrinsics.reifiedOperationMarker((int)4, (String)"REF");
                Log.INSTANCE.critical(Intrinsics.stringPlus((String)"No loader for type ", (Object)Reflection.getOrCreateKotlinClass(AssetRef.class).getQualifiedName()));
                continue;
            }
            AssetManager this_$iv$iv = this_$iv;
            boolean $i$f$contains = false;
            if (this_$iv$iv.getAssets().containsKey(it)) {
                Log.INSTANCE.error("Asset " + it + " already loaded");
                continue;
            }
            List<QueueAsync<?, ?, ?>> list = this_$iv.getAsyncLoadQueue();
            Map<KClass<?>, AssetLoader<?, ?, ?>> map2 = this_$iv.getLoaders();
            Intrinsics.reifiedOperationMarker((int)4, (String)"REF");
            AssetLoader<?, ?, ?> assetLoader = map2.get(Reflection.getOrCreateKotlinClass(AssetRef.class));
            if (assetLoader == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.asset.AssetLoader<E of org.veiset.kgame.engine.asset.AssetManager.load, ASSET of org.veiset.kgame.engine.asset.AssetManager.load, REF of org.veiset.kgame.engine.asset.AssetManager.load>");
            }
            list.add(new QueueAsync(it, assetLoader));
        }
    }

    public final /* synthetic */ <E, ASSET, REF extends AssetRef<E, ASSET>> void load(REF assetRef) {
        Intrinsics.checkNotNullParameter(assetRef, (String)"assetRef");
        boolean $i$f$load = false;
        Map<KClass<?>, AssetLoader<?, ?, ?>> map = this.getLoaders();
        Intrinsics.reifiedOperationMarker((int)4, (String)"REF");
        if (map.get(Reflection.getOrCreateKotlinClass(AssetRef.class)) == null) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"REF");
            Log.INSTANCE.critical(Intrinsics.stringPlus((String)"No loader for type ", (Object)Reflection.getOrCreateKotlinClass(AssetRef.class).getQualifiedName()));
        } else {
            AssetManager this_$iv = this;
            boolean $i$f$contains = false;
            if (this_$iv.getAssets().containsKey(assetRef)) {
                Log.INSTANCE.error("Asset " + assetRef + " already loaded");
            } else {
                List<QueueAsync<?, ?, ?>> list = this.getAsyncLoadQueue();
                Map<KClass<?>, AssetLoader<?, ?, ?>> map2 = this.getLoaders();
                Intrinsics.reifiedOperationMarker((int)4, (String)"REF");
                AssetLoader<?, ?, ?> assetLoader = map2.get(Reflection.getOrCreateKotlinClass(AssetRef.class));
                if (assetLoader == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.asset.AssetLoader<E of org.veiset.kgame.engine.asset.AssetManager.load, ASSET of org.veiset.kgame.engine.asset.AssetManager.load, REF of org.veiset.kgame.engine.asset.AssetManager.load>");
                }
                list.add(new QueueAsync(assetRef, assetLoader));
            }
        }
    }

    public final /* synthetic */ <E, ASSET, REF extends AssetRef<E, ASSET>> void loadSync(REF assetRef) {
        Intrinsics.checkNotNullParameter(assetRef, (String)"assetRef");
        boolean $i$f$loadSync = false;
        Map<KClass<?>, AssetLoader<?, ?, ?>> map = this.getLoaders();
        Intrinsics.reifiedOperationMarker((int)4, (String)"REF");
        if (map.get(Reflection.getOrCreateKotlinClass(AssetRef.class)) == null) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"REF");
            Log.INSTANCE.critical(Intrinsics.stringPlus((String)"No loader for type ", (Object)Reflection.getOrCreateKotlinClass(AssetRef.class).getQualifiedName()));
        } else {
            AssetManager this_$iv = this;
            boolean $i$f$contains = false;
            if (this_$iv.getAssets().containsKey(assetRef)) {
                Log.INSTANCE.error("Asset " + assetRef + " already loaded");
            } else {
                Log.INSTANCE.debug(Intrinsics.stringPlus((String)"Loaded sync ", assetRef));
                Map<KClass<?>, AssetLoader<?, ?, ?>> map2 = this.getLoaders();
                Intrinsics.reifiedOperationMarker((int)4, (String)"REF");
                Object object = map2.get(Reflection.getOrCreateKotlinClass(AssetRef.class));
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.asset.AssetLoader<E of org.veiset.kgame.engine.asset.AssetManager.loadSync, ASSET of org.veiset.kgame.engine.asset.AssetManager.loadSync, REF of org.veiset.kgame.engine.asset.AssetManager.loadSync>");
                }
                AssetLoader<?, ?, ?> loader = object;
                object = this.getAssets();
                Object obj = loader.loadSync(assetRef, loader.loadAsync(assetRef));
                boolean bl = false;
                object.put(assetRef, obj);
            }
        }
    }

    public final /* synthetic */ <E, ASSET, REF extends AssetRef<E, ASSET>> void unload(REF assetRef) {
        Object object;
        Intrinsics.checkNotNullParameter(assetRef, (String)"assetRef");
        boolean $i$f$unload = false;
        Map<KClass<?>, AssetLoader<?, ?, ?>> map = this.getLoaders();
        Intrinsics.reifiedOperationMarker((int)4, (String)"REF");
        AssetLoader<?, ?, ?> assetLoader = map.get(Reflection.getOrCreateKotlinClass(AssetRef.class));
        if (assetLoader == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.asset.AssetLoader<E of org.veiset.kgame.engine.asset.AssetManager.unload, ASSET of org.veiset.kgame.engine.asset.AssetManager.unload, REF of org.veiset.kgame.engine.asset.AssetManager.unload>");
        }
        AssetLoader<?, ?, ?> assetLoader2 = assetLoader;
        AssetManager this_$iv = this;
        boolean $i$f$get = false;
        try {
            Object object2 = this_$iv.getAssets().get(assetRef);
            Intrinsics.reifiedOperationMarker((int)1, (String)"ASSET");
            object = object2;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef + " not loaded");
            throw ex$iv;
        }
        Object asset = object;
        this.getAssets().remove(assetRef);
        assetLoader2.unload(asset);
    }

    public final /* synthetic */ <E, ASSET> ASSET get(AssetRef<E, ASSET> assetRef) {
        Intrinsics.checkNotNullParameter(assetRef, (String)"assetRef");
        boolean $i$f$get = false;
        try {
            Object object = this.getAssets().get(assetRef);
            Intrinsics.reifiedOperationMarker((int)1, (String)"ASSET");
            return (ASSET)object;
        }
        catch (Exception ex) {
            Log.INSTANCE.critical("AssetRef " + assetRef + " not loaded");
            throw ex;
        }
    }

    public final /* synthetic */ <T> T getById(String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        boolean $i$f$getById = false;
        try {
            Object object = this.getAssetsIdMap().get(id);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)object;
        }
        catch (Exception ex) {
            Log.INSTANCE.critical("AssetRef id '" + id + "' not loaded");
            throw ex;
        }
    }

    public final /* synthetic */ <E, ASSET> boolean contains(AssetRef<E, ASSET> assetRef) {
        Intrinsics.checkNotNullParameter(assetRef, (String)"assetRef");
        boolean $i$f$contains = false;
        return this.getAssets().containsKey(assetRef);
    }

    public final void clear() {
    }

    public final void preprocess() {
        this.processing = true;
        TimeSummed timer = new TimeSummed("Preprocessing all unloaded assets", 10);
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this, timer){
            final /* synthetic */ AssetManager this$0;
            final /* synthetic */ TimeSummed $timer;
            {
                this.this$0 = $receiver;
                this.$timer = $timer;
                super(0);
            }

            public final void invoke() {
                Iterator<QueueAsync<?, ?, ?>> iterator = this.this$0.getAsyncLoadQueue().iterator();
                while (iterator.hasNext()) {
                    QueueAsync<?, ?, ?> el = iterator.next();
                    QueueSync q2 = (QueueSync)this.$timer.time(String.valueOf(el.getAssetRef()), (Function0)new Function0<QueueSync<? extends Object, ? extends Object, ? extends AssetRef<?, ?>>>(el){
                        final /* synthetic */ QueueAsync<?, ?, ?> $el;
                        {
                            this.$el = $el;
                            super(0);
                        }

                        @NotNull
                        public final QueueSync<? extends Object, ? extends Object, ? extends AssetRef<?, ?>> invoke() {
                            return this.$el.loadAsync();
                        }
                    });
                    this.this$0.getSyncLoadQueue().add(q2);
                    iterator.remove();
                }
                this.$timer.display();
                this.this$0.setProcessing(false);
            }
        }), (int)31, null);
    }

    public final void processSync() {
        TimeSummed timer = new TimeSummed("Synchronized loading", 10);
        Iterator<QueueSync<?, ?, ?>> iterator = this.syncLoadQueue.iterator();
        while (iterator.hasNext()) {
            QueueSync<?, ?, ?> el = iterator.next();
            Pair pair = (Pair)timer.time(String.valueOf(el.getAssetRef()), (Function0)new Function0<Pair<? extends AssetRef<?, ?>, ? extends Object>>(el){
                final /* synthetic */ QueueSync<?, ?, ?> $el;
                {
                    this.$el = $el;
                    super(0);
                }

                @NotNull
                public final Pair<AssetRef<?, ?>, Object> invoke() {
                    return this.$el.loadSync();
                }
            });
            AssetRef ref = (AssetRef)pair.component1();
            Object v = pair.component2();
            Map<Object, Object> map = this.assets;
            boolean bl = false;
            map.put(ref, v);
            map = this.assetsIdMap;
            String string = ref.getId();
            boolean bl2 = false;
            map.put(string, v);
            iterator.remove();
        }
        timer.display();
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <REF extends AssetRef<?, ASSET>, ASSET> List<Pair<REF, ASSET>> allRefs() {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        boolean $i$f$allRefs = false;
        Log.INSTANCE.info(Intrinsics.stringPlus((String)"Filtering ", (Object)this.getAssets().size()));
        Map<AssetRef<?, ?>, Object> $this$filter$iv = this.getAssets();
        boolean $i$f$filter = false;
        Map<AssetRef<?, ?>, Object> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            Object k = it.getKey();
            Intrinsics.reifiedOperationMarker((int)3, (String)"REF");
            if (!(k instanceof AssetRef)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        var7_7 = $this$mapTo$iv$iv;
        bl = false;
        for (Map.Entry item$iv$iv : var7_7.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl3 = false;
            Object k = it.getKey();
            Intrinsics.reifiedOperationMarker((int)1, (String)"REF");
            AssetRef assetRef = (AssetRef)k;
            Object v = it.getValue();
            Intrinsics.reifiedOperationMarker((int)1, (String)"ASSET");
            Object asset = v;
            Pair pair = new Pair((Object)assetRef, asset);
            object.add(pair);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <ASSET> List<ASSET> all() {
        void $this$filterIsInstanceTo$iv$iv;
        boolean $i$f$all = false;
        Iterable $this$filterIsInstance$iv = this.getAssets().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"ASSET");
            if (!(element$iv$iv instanceof Object)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\u0014\b\u0002\u0010\u0004*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00052\u00020\u0002B/\u0012\u0006\u0010\u0006\u001a\u00028\u0002\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\bH\u00c6\u0003J\u000e\u0010\u0015\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011JP\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00028\u00022\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\b2\b\b\u0002\u0010\t\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00010\u001eJ\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\t\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/veiset/kgame/engine/asset/AssetManager$QueueSync;", "E", "", "ASSET", "REF", "Lorg/veiset/kgame/engine/asset/AssetRef;", "assetRef", "assetLoader", "Lorg/veiset/kgame/engine/asset/AssetLoader;", "preprocessed", "(Lorg/veiset/kgame/engine/asset/AssetRef;Lorg/veiset/kgame/engine/asset/AssetLoader;Ljava/lang/Object;)V", "getAssetLoader", "()Lorg/veiset/kgame/engine/asset/AssetLoader;", "getAssetRef", "()Lorg/veiset/kgame/engine/asset/AssetRef;", "Lorg/veiset/kgame/engine/asset/AssetRef;", "getPreprocessed", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "component3", "copy", "(Lorg/veiset/kgame/engine/asset/AssetRef;Lorg/veiset/kgame/engine/asset/AssetLoader;Ljava/lang/Object;)Lorg/veiset/kgame/engine/asset/AssetManager$QueueSync;", "equals", "", "other", "hashCode", "", "loadSync", "Lkotlin/Pair;", "toString", "", "kgame2"})
    public static final class QueueSync<E, ASSET, REF extends AssetRef<E, ASSET>> {
        @NotNull
        private final REF assetRef;
        @NotNull
        private final AssetLoader<E, ASSET, REF> assetLoader;
        @NotNull
        private final E preprocessed;

        public QueueSync(@NotNull REF assetRef, @NotNull AssetLoader<E, ASSET, REF> assetLoader, @NotNull E preprocessed) {
            Intrinsics.checkNotNullParameter(assetRef, (String)"assetRef");
            Intrinsics.checkNotNullParameter(assetLoader, (String)"assetLoader");
            Intrinsics.checkNotNullParameter(preprocessed, (String)"preprocessed");
            this.assetRef = assetRef;
            this.assetLoader = assetLoader;
            this.preprocessed = preprocessed;
        }

        @NotNull
        public final REF getAssetRef() {
            return this.assetRef;
        }

        @NotNull
        public final AssetLoader<E, ASSET, REF> getAssetLoader() {
            return this.assetLoader;
        }

        @NotNull
        public final E getPreprocessed() {
            return this.preprocessed;
        }

        @NotNull
        public final Pair<REF, ASSET> loadSync() {
            return new Pair(this.assetRef, this.assetLoader.loadSync(this.assetRef, this.preprocessed));
        }

        @NotNull
        public final REF component1() {
            return this.assetRef;
        }

        @NotNull
        public final AssetLoader<E, ASSET, REF> component2() {
            return this.assetLoader;
        }

        @NotNull
        public final E component3() {
            return this.preprocessed;
        }

        @NotNull
        public final QueueSync<E, ASSET, REF> copy(@NotNull REF assetRef, @NotNull AssetLoader<E, ASSET, REF> assetLoader, @NotNull E preprocessed) {
            Intrinsics.checkNotNullParameter(assetRef, (String)"assetRef");
            Intrinsics.checkNotNullParameter(assetLoader, (String)"assetLoader");
            Intrinsics.checkNotNullParameter(preprocessed, (String)"preprocessed");
            return new QueueSync<E, ASSET, REF>(assetRef, assetLoader, preprocessed);
        }

        public static /* synthetic */ QueueSync copy$default(QueueSync queueSync, AssetRef assetRef, AssetLoader assetLoader, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                assetRef = queueSync.assetRef;
            }
            if ((n & 2) != 0) {
                assetLoader = queueSync.assetLoader;
            }
            if ((n & 4) != 0) {
                object = queueSync.preprocessed;
            }
            return queueSync.copy(assetRef, assetLoader, object);
        }

        @NotNull
        public String toString() {
            return "QueueSync(assetRef=" + this.assetRef + ", assetLoader=" + this.assetLoader + ", preprocessed=" + this.preprocessed + ')';
        }

        public int hashCode() {
            int result = this.assetRef.hashCode();
            result = result * 31 + this.assetLoader.hashCode();
            result = result * 31 + this.preprocessed.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QueueSync)) {
                return false;
            }
            QueueSync queueSync = (QueueSync)other;
            if (!Intrinsics.areEqual(this.assetRef, queueSync.assetRef)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.assetLoader, queueSync.assetLoader)) {
                return false;
            }
            return Intrinsics.areEqual(this.preprocessed, queueSync.preprocessed);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\u0014\b\u0002\u0010\u0004*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00052\u00020\u0002B'\u0012\u0006\u0010\u0006\u001a\u00028\u0002\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000eR \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/veiset/kgame/engine/asset/AssetManager$QueueAsync;", "E", "", "ASSET", "REF", "Lorg/veiset/kgame/engine/asset/AssetRef;", "assetRef", "assetLoader", "Lorg/veiset/kgame/engine/asset/AssetLoader;", "(Lorg/veiset/kgame/engine/asset/AssetRef;Lorg/veiset/kgame/engine/asset/AssetLoader;)V", "getAssetRef", "()Lorg/veiset/kgame/engine/asset/AssetRef;", "Lorg/veiset/kgame/engine/asset/AssetRef;", "loadAsync", "Lorg/veiset/kgame/engine/asset/AssetManager$QueueSync;", "kgame2"})
    public static final class QueueAsync<E, ASSET, REF extends AssetRef<E, ASSET>> {
        @NotNull
        private final REF assetRef;
        @NotNull
        private final AssetLoader<E, ASSET, REF> assetLoader;

        public QueueAsync(@NotNull REF assetRef, @NotNull AssetLoader<E, ASSET, REF> assetLoader) {
            Intrinsics.checkNotNullParameter(assetRef, (String)"assetRef");
            Intrinsics.checkNotNullParameter(assetLoader, (String)"assetLoader");
            this.assetRef = assetRef;
            this.assetLoader = assetLoader;
        }

        @NotNull
        public final REF getAssetRef() {
            return this.assetRef;
        }

        @NotNull
        public final QueueSync<E, ASSET, REF> loadAsync() {
            return new QueueSync<E, ASSET, REF>(this.assetRef, this.assetLoader, this.assetLoader.loadAsync(this.assetRef));
        }
    }
}

