/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.asset;

import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.asset.AnimationData;
import org.veiset.kgame.engine.asset.TxSize;
import org.veiset.kgame.engine.behaviour.AnimationSet;
import org.veiset.kgame.engine.values.Tag;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002:\b\t\n\u000b\f\r\u000e\u000f\u0010B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0001\b\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lorg/veiset/kgame/engine/asset/AssetRef;", "E", "", "ASSET", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "AnimationRef", "AnimationSetRef", "BitmapFontRef", "IconRef", "MusicRef", "SoundRef", "TextureRef", "TilesetRef", "Lorg/veiset/kgame/engine/asset/AssetRef$TextureRef;", "Lorg/veiset/kgame/engine/asset/AssetRef$TilesetRef;", "Lorg/veiset/kgame/engine/asset/AssetRef$MusicRef;", "Lorg/veiset/kgame/engine/asset/AssetRef$SoundRef;", "Lorg/veiset/kgame/engine/asset/AssetRef$BitmapFontRef;", "Lorg/veiset/kgame/engine/asset/AssetRef$AnimationRef;", "Lorg/veiset/kgame/engine/asset/AssetRef$AnimationSetRef;", "Lorg/veiset/kgame/engine/asset/AssetRef$IconRef;", "kgame2"})
public abstract class AssetRef<E, ASSET> {
    @NotNull
    private final String id;

    private AssetRef(String id) {
        this.id = id;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public /* synthetic */ AssetRef(String id, DefaultConstructorMarker $constructor_marker) {
        this(id);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J-\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/veiset/kgame/engine/asset/AssetRef$TextureRef;", "Lorg/veiset/kgame/engine/asset/AssetRef;", "", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "path", "", "txSize", "Lorg/veiset/kgame/engine/asset/TxSize;", "tags", "", "Lorg/veiset/kgame/engine/values/Tag;", "(Ljava/lang/String;Lorg/veiset/kgame/engine/asset/TxSize;Ljava/util/List;)V", "getPath", "()Ljava/lang/String;", "getTags", "()Ljava/util/List;", "getTxSize", "()Lorg/veiset/kgame/engine/asset/TxSize;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kgame2"})
    public static final class TextureRef
    extends AssetRef<Unit, TextureRegion> {
        @NotNull
        private final String path;
        @NotNull
        private final TxSize txSize;
        @NotNull
        private final List<Tag> tags;

        public TextureRef(@NotNull String path, @NotNull TxSize txSize, @NotNull List<? extends Tag> tags) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)txSize, (String)"txSize");
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            super("texture:" + path + ':' + txSize, null);
            this.path = path;
            this.txSize = txSize;
            this.tags = tags;
        }

        public /* synthetic */ TextureRef(String string, TxSize txSize, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string, txSize, list);
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final TxSize getTxSize() {
            return this.txSize;
        }

        @NotNull
        public final List<Tag> getTags() {
            return this.tags;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final TxSize component2() {
            return this.txSize;
        }

        @NotNull
        public final List<Tag> component3() {
            return this.tags;
        }

        @NotNull
        public final TextureRef copy(@NotNull String path, @NotNull TxSize txSize, @NotNull List<? extends Tag> tags) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)txSize, (String)"txSize");
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            return new TextureRef(path, txSize, tags);
        }

        public static /* synthetic */ TextureRef copy$default(TextureRef textureRef, String string, TxSize txSize, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = textureRef.path;
            }
            if ((n & 2) != 0) {
                txSize = textureRef.txSize;
            }
            if ((n & 4) != 0) {
                list = textureRef.tags;
            }
            return textureRef.copy(string, txSize, list);
        }

        @NotNull
        public String toString() {
            return "TextureRef(path=" + this.path + ", txSize=" + this.txSize + ", tags=" + this.tags + ')';
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + this.txSize.hashCode();
            result = result * 31 + ((Object)this.tags).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextureRef)) {
                return false;
            }
            TextureRef textureRef = (TextureRef)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)textureRef.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.txSize, (Object)textureRef.txSize)) {
                return false;
            }
            return Intrinsics.areEqual(this.tags, textureRef.tags);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B3\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u0011\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0003H\u00c6\u0003J;\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/veiset/kgame/engine/asset/AssetRef$TilesetRef;", "Lorg/veiset/kgame/engine/asset/AssetRef;", "", "", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "path", "", "size", "Lkotlin/Pair;", "", "tiles", "(Ljava/lang/String;Lkotlin/Pair;Ljava/util/List;)V", "getPath", "()Ljava/lang/String;", "getSize", "()Lkotlin/Pair;", "getTiles", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "kgame2"})
    public static final class TilesetRef
    extends AssetRef<Unit, List<? extends TextureRegion>> {
        @NotNull
        private final String path;
        @NotNull
        private final Pair<Integer, Integer> size;
        @Nullable
        private final List<Integer> tiles;

        public TilesetRef(@NotNull String path, @NotNull Pair<Integer, Integer> size, @Nullable List<Integer> tiles) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(size, (String)"size");
            super(Intrinsics.stringPlus((String)"tileset.", (Object)path), null);
            this.path = path;
            this.size = size;
            this.tiles = tiles;
        }

        public /* synthetic */ TilesetRef(String string, Pair pair, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = null;
            }
            this(string, (Pair<Integer, Integer>)pair, list);
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final Pair<Integer, Integer> getSize() {
            return this.size;
        }

        @Nullable
        public final List<Integer> getTiles() {
            return this.tiles;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final Pair<Integer, Integer> component2() {
            return this.size;
        }

        @Nullable
        public final List<Integer> component3() {
            return this.tiles;
        }

        @NotNull
        public final TilesetRef copy(@NotNull String path, @NotNull Pair<Integer, Integer> size, @Nullable List<Integer> tiles) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(size, (String)"size");
            return new TilesetRef(path, size, tiles);
        }

        public static /* synthetic */ TilesetRef copy$default(TilesetRef tilesetRef, String string, Pair pair, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = tilesetRef.path;
            }
            if ((n & 2) != 0) {
                pair = tilesetRef.size;
            }
            if ((n & 4) != 0) {
                list = tilesetRef.tiles;
            }
            return tilesetRef.copy(string, pair, list);
        }

        @NotNull
        public String toString() {
            return "TilesetRef(path=" + this.path + ", size=" + this.size + ", tiles=" + this.tiles + ')';
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + this.size.hashCode();
            result = result * 31 + (this.tiles == null ? 0 : ((Object)this.tiles).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TilesetRef)) {
                return false;
            }
            TilesetRef tilesetRef = (TilesetRef)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)tilesetRef.path)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.size, tilesetRef.size)) {
                return false;
            }
            return Intrinsics.areEqual(this.tiles, tilesetRef.tiles);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/veiset/kgame/engine/asset/AssetRef$MusicRef;", "Lorg/veiset/kgame/engine/asset/AssetRef;", "Lcom/badlogic/gdx/audio/Music;", "path", "", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kgame2"})
    public static final class MusicRef
    extends AssetRef<Music, Music> {
        @NotNull
        private final String path;

        public MusicRef(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(Intrinsics.stringPlus((String)"music:", (Object)path), null);
            this.path = path;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final MusicRef copy(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new MusicRef(path);
        }

        public static /* synthetic */ MusicRef copy$default(MusicRef musicRef, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = musicRef.path;
            }
            return musicRef.copy(string);
        }

        @NotNull
        public String toString() {
            return "MusicRef(path=" + this.path + ')';
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MusicRef)) {
                return false;
            }
            MusicRef musicRef = (MusicRef)other;
            return Intrinsics.areEqual((Object)this.path, (Object)musicRef.path);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/veiset/kgame/engine/asset/AssetRef$SoundRef;", "Lorg/veiset/kgame/engine/asset/AssetRef;", "Lcom/badlogic/gdx/audio/Sound;", "path", "", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kgame2"})
    public static final class SoundRef
    extends AssetRef<Sound, Sound> {
        @NotNull
        private final String path;

        public SoundRef(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(Intrinsics.stringPlus((String)"sound:", (Object)path), null);
            this.path = path;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final SoundRef copy(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new SoundRef(path);
        }

        public static /* synthetic */ SoundRef copy$default(SoundRef soundRef, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = soundRef.path;
            }
            return soundRef.copy(string);
        }

        @NotNull
        public String toString() {
            return "SoundRef(path=" + this.path + ')';
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SoundRef)) {
                return false;
            }
            SoundRef soundRef = (SoundRef)other;
            return Intrinsics.areEqual((Object)this.path, (Object)soundRef.path);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/veiset/kgame/engine/asset/AssetRef$BitmapFontRef;", "Lorg/veiset/kgame/engine/asset/AssetRef;", "Lcom/badlogic/gdx/graphics/g2d/freetype/FreeTypeFontGenerator;", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "path", "", "size", "", "aa", "(Ljava/lang/String;II)V", "getAa", "()I", "getPath", "()Ljava/lang/String;", "getSize", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "kgame2"})
    public static final class BitmapFontRef
    extends AssetRef<FreeTypeFontGenerator, BitmapFont> {
        @NotNull
        private final String path;
        private final int size;
        private final int aa;

        public BitmapFontRef(@NotNull String path, int size, int aa) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(Intrinsics.stringPlus((String)"bitmap:", (Object)path), null);
            this.path = path;
            this.size = size;
            this.aa = aa;
        }

        public /* synthetic */ BitmapFontRef(String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                n2 = 1;
            }
            this(string, n, n2);
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final int getSize() {
            return this.size;
        }

        public final int getAa() {
            return this.aa;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        public final int component2() {
            return this.size;
        }

        public final int component3() {
            return this.aa;
        }

        @NotNull
        public final BitmapFontRef copy(@NotNull String path, int size, int aa) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new BitmapFontRef(path, size, aa);
        }

        public static /* synthetic */ BitmapFontRef copy$default(BitmapFontRef bitmapFontRef, String string, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = bitmapFontRef.path;
            }
            if ((n3 & 2) != 0) {
                n = bitmapFontRef.size;
            }
            if ((n3 & 4) != 0) {
                n2 = bitmapFontRef.aa;
            }
            return bitmapFontRef.copy(string, n, n2);
        }

        @NotNull
        public String toString() {
            return "BitmapFontRef(path=" + this.path + ", size=" + this.size + ", aa=" + this.aa + ')';
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + Integer.hashCode(this.size);
            result = result * 31 + Integer.hashCode(this.aa);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BitmapFontRef)) {
                return false;
            }
            BitmapFontRef bitmapFontRef = (BitmapFontRef)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)bitmapFontRef.path)) {
                return false;
            }
            if (this.size != bitmapFontRef.size) {
                return false;
            }
            return this.aa == bitmapFontRef.aa;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B)\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u000bH\u00c6\u0003J3\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/veiset/kgame/engine/asset/AssetRef$AnimationRef;", "Lorg/veiset/kgame/engine/asset/AssetRef;", "", "Lcom/badlogic/gdx/graphics/g2d/Animation;", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "path", "", "size", "Lkotlin/Pair;", "", "speed", "", "(Ljava/lang/String;Lkotlin/Pair;F)V", "getPath", "()Ljava/lang/String;", "getSize", "()Lkotlin/Pair;", "getSpeed", "()F", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "kgame2"})
    public static final class AnimationRef
    extends AssetRef<Unit, Animation<TextureRegion>> {
        @NotNull
        private final String path;
        @NotNull
        private final Pair<Integer, Integer> size;
        private final float speed;

        public AnimationRef(@NotNull String path, @NotNull Pair<Integer, Integer> size, float speed) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(size, (String)"size");
            super(Intrinsics.stringPlus((String)"animation:", (Object)path), null);
            this.path = path;
            this.size = size;
            this.speed = speed;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final Pair<Integer, Integer> getSize() {
            return this.size;
        }

        public final float getSpeed() {
            return this.speed;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final Pair<Integer, Integer> component2() {
            return this.size;
        }

        public final float component3() {
            return this.speed;
        }

        @NotNull
        public final AnimationRef copy(@NotNull String path, @NotNull Pair<Integer, Integer> size, float speed) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(size, (String)"size");
            return new AnimationRef(path, size, speed);
        }

        public static /* synthetic */ AnimationRef copy$default(AnimationRef animationRef, String string, Pair pair, float f, int n, Object object) {
            if ((n & 1) != 0) {
                string = animationRef.path;
            }
            if ((n & 2) != 0) {
                pair = animationRef.size;
            }
            if ((n & 4) != 0) {
                f = animationRef.speed;
            }
            return animationRef.copy(string, pair, f);
        }

        @NotNull
        public String toString() {
            return "AnimationRef(path=" + this.path + ", size=" + this.size + ", speed=" + this.speed + ')';
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + this.size.hashCode();
            result = result * 31 + Float.hashCode(this.speed);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnimationRef)) {
                return false;
            }
            AnimationRef animationRef = (AnimationRef)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)animationRef.path)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.size, animationRef.size)) {
                return false;
            }
            return Intrinsics.areEqual((Object)Float.valueOf(this.speed), (Object)Float.valueOf(animationRef.speed));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BQ\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003J\t\u0010 \u001a\u00020\nH\u00c6\u0003J\t\u0010!\u001a\u00020\nH\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\t\u0010#\u001a\u00020\nH\u00c6\u0003Je\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\u000f\u001a\u00020\nH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020\bH\u00d6\u0001J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012\u00a8\u0006+"}, d2={"Lorg/veiset/kgame/engine/asset/AssetRef$AnimationSetRef;", "Lorg/veiset/kgame/engine/asset/AssetRef;", "", "Lorg/veiset/kgame/engine/behaviour/AnimationSet;", "path", "", "size", "Lkotlin/Pair;", "", "idle", "Lorg/veiset/kgame/engine/asset/AnimationData;", "moving", "attack", "dodge", "stagger", "death", "(Ljava/lang/String;Lkotlin/Pair;Lorg/veiset/kgame/engine/asset/AnimationData;Lorg/veiset/kgame/engine/asset/AnimationData;Lorg/veiset/kgame/engine/asset/AnimationData;Lorg/veiset/kgame/engine/asset/AnimationData;Lorg/veiset/kgame/engine/asset/AnimationData;Lorg/veiset/kgame/engine/asset/AnimationData;)V", "getAttack", "()Lorg/veiset/kgame/engine/asset/AnimationData;", "getDeath", "getDodge", "getIdle", "getMoving", "getPath", "()Ljava/lang/String;", "getSize", "()Lkotlin/Pair;", "getStagger", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "", "hashCode", "toString", "kgame2"})
    public static final class AnimationSetRef
    extends AssetRef<Unit, AnimationSet> {
        @NotNull
        private final String path;
        @NotNull
        private final Pair<Integer, Integer> size;
        @NotNull
        private final AnimationData idle;
        @NotNull
        private final AnimationData moving;
        @NotNull
        private final AnimationData attack;
        @NotNull
        private final AnimationData dodge;
        @NotNull
        private final AnimationData stagger;
        @NotNull
        private final AnimationData death;

        public AnimationSetRef(@NotNull String path, @NotNull Pair<Integer, Integer> size, @NotNull AnimationData idle, @NotNull AnimationData moving, @NotNull AnimationData attack, @NotNull AnimationData dodge, @NotNull AnimationData stagger, @NotNull AnimationData death) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(size, (String)"size");
            Intrinsics.checkNotNullParameter((Object)idle, (String)"idle");
            Intrinsics.checkNotNullParameter((Object)moving, (String)"moving");
            Intrinsics.checkNotNullParameter((Object)attack, (String)"attack");
            Intrinsics.checkNotNullParameter((Object)dodge, (String)"dodge");
            Intrinsics.checkNotNullParameter((Object)stagger, (String)"stagger");
            Intrinsics.checkNotNullParameter((Object)death, (String)"death");
            super(Intrinsics.stringPlus((String)"animationSet:", (Object)path), null);
            this.path = path;
            this.size = size;
            this.idle = idle;
            this.moving = moving;
            this.attack = attack;
            this.dodge = dodge;
            this.stagger = stagger;
            this.death = death;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final Pair<Integer, Integer> getSize() {
            return this.size;
        }

        @NotNull
        public final AnimationData getIdle() {
            return this.idle;
        }

        @NotNull
        public final AnimationData getMoving() {
            return this.moving;
        }

        @NotNull
        public final AnimationData getAttack() {
            return this.attack;
        }

        @NotNull
        public final AnimationData getDodge() {
            return this.dodge;
        }

        @NotNull
        public final AnimationData getStagger() {
            return this.stagger;
        }

        @NotNull
        public final AnimationData getDeath() {
            return this.death;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final Pair<Integer, Integer> component2() {
            return this.size;
        }

        @NotNull
        public final AnimationData component3() {
            return this.idle;
        }

        @NotNull
        public final AnimationData component4() {
            return this.moving;
        }

        @NotNull
        public final AnimationData component5() {
            return this.attack;
        }

        @NotNull
        public final AnimationData component6() {
            return this.dodge;
        }

        @NotNull
        public final AnimationData component7() {
            return this.stagger;
        }

        @NotNull
        public final AnimationData component8() {
            return this.death;
        }

        @NotNull
        public final AnimationSetRef copy(@NotNull String path, @NotNull Pair<Integer, Integer> size, @NotNull AnimationData idle, @NotNull AnimationData moving, @NotNull AnimationData attack, @NotNull AnimationData dodge, @NotNull AnimationData stagger, @NotNull AnimationData death) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(size, (String)"size");
            Intrinsics.checkNotNullParameter((Object)idle, (String)"idle");
            Intrinsics.checkNotNullParameter((Object)moving, (String)"moving");
            Intrinsics.checkNotNullParameter((Object)attack, (String)"attack");
            Intrinsics.checkNotNullParameter((Object)dodge, (String)"dodge");
            Intrinsics.checkNotNullParameter((Object)stagger, (String)"stagger");
            Intrinsics.checkNotNullParameter((Object)death, (String)"death");
            return new AnimationSetRef(path, size, idle, moving, attack, dodge, stagger, death);
        }

        public static /* synthetic */ AnimationSetRef copy$default(AnimationSetRef animationSetRef, String string, Pair pair, AnimationData animationData, AnimationData animationData2, AnimationData animationData3, AnimationData animationData4, AnimationData animationData5, AnimationData animationData6, int n, Object object) {
            if ((n & 1) != 0) {
                string = animationSetRef.path;
            }
            if ((n & 2) != 0) {
                pair = animationSetRef.size;
            }
            if ((n & 4) != 0) {
                animationData = animationSetRef.idle;
            }
            if ((n & 8) != 0) {
                animationData2 = animationSetRef.moving;
            }
            if ((n & 0x10) != 0) {
                animationData3 = animationSetRef.attack;
            }
            if ((n & 0x20) != 0) {
                animationData4 = animationSetRef.dodge;
            }
            if ((n & 0x40) != 0) {
                animationData5 = animationSetRef.stagger;
            }
            if ((n & 0x80) != 0) {
                animationData6 = animationSetRef.death;
            }
            return animationSetRef.copy(string, pair, animationData, animationData2, animationData3, animationData4, animationData5, animationData6);
        }

        @NotNull
        public String toString() {
            return "AnimationSetRef(path=" + this.path + ", size=" + this.size + ", idle=" + this.idle + ", moving=" + this.moving + ", attack=" + this.attack + ", dodge=" + this.dodge + ", stagger=" + this.stagger + ", death=" + this.death + ')';
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + this.size.hashCode();
            result = result * 31 + this.idle.hashCode();
            result = result * 31 + this.moving.hashCode();
            result = result * 31 + this.attack.hashCode();
            result = result * 31 + this.dodge.hashCode();
            result = result * 31 + this.stagger.hashCode();
            result = result * 31 + this.death.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnimationSetRef)) {
                return false;
            }
            AnimationSetRef animationSetRef = (AnimationSetRef)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)animationSetRef.path)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.size, animationSetRef.size)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.idle, (Object)animationSetRef.idle)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.moving, (Object)animationSetRef.moving)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.attack, (Object)animationSetRef.attack)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dodge, (Object)animationSetRef.dodge)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stagger, (Object)animationSetRef.stagger)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.death, (Object)animationSetRef.death);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0007H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/veiset/kgame/engine/asset/AssetRef$IconRef;", "Lorg/veiset/kgame/engine/asset/AssetRef;", "", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "path", "", "txSize", "Lorg/veiset/kgame/engine/asset/TxSize;", "(Ljava/lang/String;Lorg/veiset/kgame/engine/asset/TxSize;)V", "getPath", "()Ljava/lang/String;", "getTxSize", "()Lorg/veiset/kgame/engine/asset/TxSize;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kgame2"})
    public static final class IconRef
    extends AssetRef<Unit, TextureRegion> {
        @NotNull
        private final String path;
        @NotNull
        private final TxSize txSize;

        public IconRef(@NotNull String path, @NotNull TxSize txSize) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)txSize, (String)"txSize");
            super("icon:" + path + ':' + txSize, null);
            this.path = path;
            this.txSize = txSize;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final TxSize getTxSize() {
            return this.txSize;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final TxSize component2() {
            return this.txSize;
        }

        @NotNull
        public final IconRef copy(@NotNull String path, @NotNull TxSize txSize) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)txSize, (String)"txSize");
            return new IconRef(path, txSize);
        }

        public static /* synthetic */ IconRef copy$default(IconRef iconRef, String string, TxSize txSize, int n, Object object) {
            if ((n & 1) != 0) {
                string = iconRef.path;
            }
            if ((n & 2) != 0) {
                txSize = iconRef.txSize;
            }
            return iconRef.copy(string, txSize);
        }

        @NotNull
        public String toString() {
            return "IconRef(path=" + this.path + ", txSize=" + this.txSize + ')';
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + this.txSize.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IconRef)) {
                return false;
            }
            IconRef iconRef = (IconRef)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)iconRef.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.txSize, (Object)iconRef.txSize);
        }
    }
}

