/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.asset.assetloader;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.asset.AssetLoader;
import org.veiset.kgame.engine.asset.AssetRef;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u001d\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/veiset/kgame/engine/asset/assetloader/IconLoader;", "Lorg/veiset/kgame/engine/asset/AssetLoader;", "", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "Lorg/veiset/kgame/engine/asset/AssetRef$IconRef;", "()V", "textureCache", "", "", "Lcom/badlogic/gdx/graphics/Texture;", "loadAsync", "ref", "loadSync", "preloaded", "(Lorg/veiset/kgame/engine/asset/AssetRef$IconRef;Lkotlin/Unit;)Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "unload", "asset", "kgame2"})
public final class IconLoader
implements AssetLoader<Unit, TextureRegion, AssetRef.IconRef> {
    @NotNull
    private final Map<String, Texture> textureCache;

    public IconLoader() {
        boolean bl = false;
        this.textureCache = new LinkedHashMap();
    }

    @Override
    public void loadAsync(@NotNull AssetRef.IconRef ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
    }

    @Override
    @NotNull
    public TextureRegion loadSync(@NotNull AssetRef.IconRef ref, @NotNull Unit preloaded) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)preloaded, (String)"preloaded");
        if (!this.textureCache.containsKey(ref.getPath())) {
            Map<String, Texture> map = this.textureCache;
            String string = ref.getPath();
            Texture texture = new Texture(Gdx.files.internal(ref.getPath()));
            boolean bl = false;
            map.put(string, texture);
        }
        Texture texture = this.textureCache.get(ref.getPath());
        Intrinsics.checkNotNull((Object)texture);
        Texture texture2 = texture;
        int sizeX = ref.getTxSize().getSizeX();
        int sizeY = ref.getTxSize().getSizeY();
        int x = ref.getTxSize().getX();
        int y = ref.getTxSize().getY();
        return new TextureRegion(texture2, x, y, sizeX, sizeY);
    }

    @Override
    public void unload(@NotNull TextureRegion asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
    }
}

