/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.event;

import box2dLight.PointLight;
import box2dLight.RayHandler;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.gdx.graphics.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.physics.CollisionGroup;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/veiset/kgame/engine/ecs/event/SimpleAttackEvent;", "Lcom/badlogic/ashley/core/EntityListener;", "rayHandler", "Lbox2dLight/RayHandler;", "(Lbox2dLight/RayHandler;)V", "lights", "", "", "Lbox2dLight/PointLight;", "getLights", "()Ljava/util/Map;", "getRayHandler", "()Lbox2dLight/RayHandler;", "entityAdded", "", "entity", "Lcom/badlogic/ashley/core/Entity;", "entityRemoved", "kgame2"})
public final class SimpleAttackEvent
implements EntityListener {
    @NotNull
    private final RayHandler rayHandler;
    @NotNull
    private final Map<Integer, PointLight> lights;

    public SimpleAttackEvent(@NotNull RayHandler rayHandler) {
        Intrinsics.checkNotNullParameter((Object)rayHandler, (String)"rayHandler");
        this.rayHandler = rayHandler;
        boolean bl = false;
        this.lights = new LinkedHashMap();
    }

    @NotNull
    public final RayHandler getRayHandler() {
        return this.rayHandler;
    }

    @NotNull
    public final Map<Integer, PointLight> getLights() {
        return this.lights;
    }

    public void entityAdded(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        DynamicBodyComponent m = (DynamicBodyComponent)Mapper.INSTANCE.getDynamicBody().get(entity);
        if (m != null) {
            PointLight pointLight = new PointLight(this.rayHandler, 20, new Color(0.8f, 0.8f, 0.9f, 0.3f), 1.0f, 0.0f, 0.0f);
            Map<Integer, PointLight> map = this.lights;
            Integer n = entity.hashCode();
            boolean bl = false;
            map.put(n, pointLight);
            pointLight.setSoftnessLength(2.0f);
            pointLight.setSoft(true);
            pointLight.setXray(true);
            pointLight.attachToBody(m.getBody());
            pointLight.setContactFilter(CollisionGroup.INSTANCE.getENVIRONMENT_AND_MONSTERS());
        }
    }

    public void entityRemoved(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        PointLight pointLight = this.lights.get(entity.hashCode());
        if (pointLight != null) {
            pointLight.setActive(false);
        }
        this.lights.remove(entity.hashCode());
    }
}

