/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.debug;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Box2DDebugRenderer;
import com.badlogic.gdx.physics.box2d.World;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.debug.VisualMouse;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.component.physics.SensorBodyComponent;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.debug.DebugControlSystem;
import org.veiset.kgame.engine.ecs.system.debug.DebugControlSystemKt;
import org.veiset.kgame.engine.ecs.system.debug.ToggleKey;
import org.veiset.kgame.engine.ecs.system.player.PlayerInputSystem;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J&\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020#2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/veiset/kgame/engine/ecs/system/debug/DebugControlSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "debugMatrix", "Lcom/badlogic/gdx/math/Matrix4;", "debugRenderer", "Lcom/badlogic/gdx/physics/box2d/Box2DDebugRenderer;", "displayToggles", "", "getDisplayToggles", "()Z", "setDisplayToggles", "(Z)V", "entities", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "pos", "toggles", "", "Lorg/veiset/kgame/engine/ecs/system/debug/ToggleKey;", "getToggles", "()Ljava/util/List;", "visualMouse", "Lorg/veiset/kgame/engine/debug/VisualMouse;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "toggle", "Lcom/badlogic/gdx/math/Vector2;", "value", "text", "", "keyname", "update", "delta", "", "kgame2"})
public final class DebugControlSystem
extends EntitySystem {
    @NotNull
    private final World world;
    @NotNull
    private final AssetManager am;
    @NotNull
    private final BitmapFont font;
    @NotNull
    private final VisualMouse visualMouse;
    @NotNull
    private final Box2DDebugRenderer debugRenderer;
    @NotNull
    private final Matrix4 debugMatrix;
    private boolean displayToggles;
    @NotNull
    private final List<ToggleKey> toggles;
    private ImmutableArray<Entity> entities;
    private ImmutableArray<Entity> pos;

    /*
     * WARNING - void declaration
     */
    public DebugControlSystem(@NotNull World world) {
        BitmapFont bitmapFont;
        BitmapFont bitmapFont2;
        void assetRef$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.am = TBEngineKt.getGlobals().getAssetManager();
        Object[] objectArray = this.am;
        AssetRef assetRef = Asset.Font.INSTANCE.getRetron14();
        DebugControlSystem debugControlSystem = this;
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont2 = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        debugControlSystem.font = bitmapFont = bitmapFont2;
        this.visualMouse = new VisualMouse();
        this.debugRenderer = new Box2DDebugRenderer();
        this.debugMatrix = new Matrix4(TBEngineKt.getGlobals().getDrawUi().getCamera().combined.cpy().scl(30.0f));
        objectArray = new ToggleKey[]{new ToggleKey("Display physics", 8, "1", new Vector2(0.1f, 3.0f), (Function0<Boolean>)((Function0)toggles.1.INSTANCE), (Function0<Unit>)((Function0)toggles.2.INSTANCE)), new ToggleKey("Display physics scaled", 9, "2", new Vector2(0.1f, 2.85f), (Function0<Boolean>)((Function0)toggles.3.INSTANCE), (Function0<Unit>)((Function0)toggles.4.INSTANCE)), new ToggleKey("Profiler", 10, "3", new Vector2(0.1f, 2.7f), (Function0<Boolean>)((Function0)toggles.5.INSTANCE), (Function0<Unit>)((Function0)toggles.6.INSTANCE)), new ToggleKey("Display coords", 11, "4", new Vector2(0.1f, 2.55f), (Function0<Boolean>)((Function0)toggles.7.INSTANCE), (Function0<Unit>)((Function0)toggles.8.INSTANCE)), new ToggleKey("Draw pathfinding area", 13, "6", new Vector2(0.1f, 2.25f), (Function0<Boolean>)((Function0)toggles.9.INSTANCE), (Function0<Unit>)((Function0)toggles.10.INSTANCE)), new ToggleKey("Draw pathfinding path", 14, "7", new Vector2(0.1f, 2.1f), (Function0<Boolean>)((Function0)toggles.11.INSTANCE), (Function0<Unit>)((Function0)toggles.12.INSTANCE)), new ToggleKey("Micro Profiler", 15, "8", new Vector2(0.1f, 1.95f), (Function0<Boolean>)((Function0)toggles.13.INSTANCE), (Function0<Unit>)((Function0)toggles.14.INSTANCE)), new ToggleKey("Debug Camera System", 16, "9", new Vector2(0.1f, 1.8f), (Function0<Boolean>)((Function0)toggles.15.INSTANCE), (Function0<Unit>)((Function0)toggles.16.INSTANCE))};
        this.toggles = CollectionsKt.listOf((Object[])objectArray);
    }

    public final boolean getDisplayToggles() {
        return this.displayToggles;
    }

    public final void setDisplayToggles(boolean bl) {
        this.displayToggles = bl;
    }

    @NotNull
    public final List<ToggleKey> getToggles() {
        return this.toggles;
    }

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{PlayerCharacterComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(PlayerCharacterComponent::class.java).get())");
        this.entities = immutableArray;
        classArray = new Class[]{PositionComponent.class};
        Family.Builder builder = Family.all((Class[])classArray);
        classArray = new Class[]{DynamicBodyComponent.class, SensorBodyComponent.class};
        immutableArray = engine.getEntitiesFor(builder.one(classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(PositionComponent::class.java).one(DynamicBodyComponent::class.java, SensorBodyComponent::class.java).get())");
        this.pos = immutableArray;
    }

    /*
     * WARNING - void declaration
     */
    public void update(float delta) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Vector2 vector2;
        ImmutableArray<Entity> immutableArray = this.entities;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"entities");
            throw null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableArray));
        if (entity == null) {
            return;
        }
        Entity playerEntity = entity;
        PositionComponent position = (PositionComponent)Mapper.INSTANCE.getPosition().get(playerEntity);
        PlayerInputSystem playerInputSystem = (PlayerInputSystem)this.getEngine().getSystem(PlayerInputSystem.class);
        if (EngineConfig.Debug.INSTANCE.getZOOM_OUT_DEBUG()) {
            if (Gdx.input.isKeyJustPressed(135)) {
                vector2 = DebugControlSystemKt.access$getCamera$p();
                vector2.zoom -= 0.5f;
            }
            if (Gdx.input.isKeyJustPressed(136)) {
                vector2 = DebugControlSystemKt.access$getCamera$p();
                vector2.zoom += 1.0f;
            }
            if (Gdx.input.isKeyJustPressed(137)) {
                DebugControlSystemKt.access$getCamera$p().zoom = 1.0f;
            }
            if (DebugControlSystemKt.access$getCamera$p().zoom > 1.0f) {
                EngineConfig.Performance.INSTANCE.setDRAW_OUTSIDE_VIEWPORT(true);
            }
            EngineConfig.Debug.INSTANCE.setDEBUG_CAMERA_ZOOM(DebugControlSystemKt.access$getCamera$p().zoom);
        }
        if (EngineConfig.Debug.INSTANCE.getDISPLAY_COORDS()) {
            DebugControlSystemKt.debugDrawMouseline(position.getPos(), playerInputSystem.getTarget(), this.font);
            this.visualMouse.draw();
        }
        if (EngineConfig.Debug.INSTANCE.getDISPLAY_PHYSICS()) {
            this.debugRenderer.render(this.world, this.debugMatrix);
        }
        if (EngineConfig.Debug.INSTANCE.getDISPLAY_PHYSICS_SCALED()) {
            this.debugRenderer.render(this.world, new Matrix4(DebugControlSystemKt.access$getCamera$p().combined).scl(120.0f));
        }
        if (EngineConfig.Debug.INSTANCE.getDISPLAY_POS()) {
            DebugControlSystemKt.access$getShapeRenderer$p().begin(ShapeRenderer.ShapeType.Filled);
            vector2 = this.pos;
            if (vector2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pos");
                throw null;
            }
            $this$forEach$iv = (Iterable)vector2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity entity2 = (Entity)element$iv;
                boolean bl = false;
                Vector2 vector22 = ((PositionComponent)Mapper.INSTANCE.getPosition().get(entity2)).getPos();
                float x = Vector2Kt.component1(vector22);
                float y = Vector2Kt.component2(vector22);
                DebugControlSystemKt.access$getShapeRenderer$p().circle(x * 120.0f, y * 120.0f, 5.0f);
            }
            DebugControlSystemKt.access$getShapeRenderer$p().end();
        }
        if (Gdx.input.isKeyJustPressed(32)) {
            boolean bl = this.displayToggles = !this.displayToggles;
        }
        if (this.displayToggles) {
            ToggleKey it;
            $this$forEach$iv = this.toggles;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ToggleKey)element$iv;
                boolean bl = false;
                if (!Gdx.input.isKeyJustPressed(it.getKey())) continue;
                it.getToggle().invoke();
            }
            if (Gdx.input.isKeyJustPressed(52)) {
                $this$forEach$iv = this.toggles;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (ToggleKey)element$iv;
                    boolean bl = false;
                    if (((Boolean)it.getValue().invoke()).booleanValue()) continue;
                    it.getToggle().invoke();
                }
                EngineConfig.Debug.INSTANCE.setPROFILER_DETAILED(true);
            }
            if (Gdx.input.isKeyJustPressed(54)) {
                $this$forEach$iv = this.toggles;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (ToggleKey)element$iv;
                    boolean bl = false;
                    if (!((Boolean)it.getValue().invoke()).booleanValue()) continue;
                    it.getToggle().invoke();
                }
                EngineConfig.Debug.INSTANCE.setPROFILER_DETAILED(false);
                EngineConfig.Debug.INSTANCE.setPROFILER(true);
            }
        }
        if (this.displayToggles) {
            void $this$fold$iv;
            DebugControlSystemKt.access$getUiShapeRenderer$p().begin(ShapeRenderer.ShapeType.Filled);
            DebugControlSystemKt.access$getUiShapeRenderer$p().setColor(Color.BLUE);
            Iterable $i$f$forEach2 = this.toggles;
            Vector2 initial$iv = new Vector2(10.0f, 0.0f);
            boolean $i$f$fold = false;
            Vector2 accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void v;
                ToggleKey x = (ToggleKey)element$iv;
                Vector2 $dstr$cmin$cmax = accumulator$iv;
                boolean bl = false;
                float cmin = Vector2Kt.component1($dstr$cmin$cmax);
                float cmax = Vector2Kt.component2($dstr$cmin$cmax);
                float y = v.getPosition().y;
                boolean bl2 = false;
                bl2 = false;
                accumulator$iv = new Vector2(Math.min(cmin, y), Math.max(cmax, y));
            }
            vector2 = accumulator$iv;
            float minY = Vector2Kt.component1(vector2);
            float maxY = Vector2Kt.component2(vector2);
            ShapeRendererKt.rect((ShapeRenderer)DebugControlSystemKt.access$getUiShapeRenderer$p(), (Vector2)Vector2Kt.dw(new Vector2(0.0f, minY - 0.18f)), (Vector2)Vector2Kt.dw(new Vector2(2.5f, maxY - minY + 0.3f)));
            DebugControlSystemKt.access$getUiShapeRenderer$p().end();
            Iterable $this$forEach$iv2 = this.toggles;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv2) {
                ToggleKey it = (ToggleKey)element$iv;
                boolean bl = false;
                this.toggle(it.getPosition(), (Boolean)it.getValue().invoke(), it.getDescription(), it.getKeyname());
            }
        }
    }

    public final void toggle(@NotNull Vector2 pos, boolean value, @NotNull String text, @NotNull String keyname) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)keyname, (String)"keyname");
        Vector2 vector2 = Vector2Kt.dw(pos);
        float x = Vector2Kt.component1(vector2);
        float y = Vector2Kt.component2(vector2);
        String toggleChar = value ? "X" : " ";
        DebugControlSystemKt.access$getUiSpriteBatch$p().begin();
        this.font.draw((Batch)DebugControlSystemKt.access$getUiSpriteBatch$p(), (CharSequence)('[' + toggleChar + "]  " + keyname + "  -  " + text), x, y);
        DebugControlSystemKt.access$getUiSpriteBatch$p().end();
    }
}

