/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.graphics;

import box2dLight.PointLight;
import box2dLight.RayHandler;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.physics.box2d.World;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.component.attack.ProjectileComponent;
import org.veiset.kgame.engine.ecs.entity.PlayerEntity;
import org.veiset.kgame.engine.ecs.event.SimpleAttackEvent;
import org.veiset.kgame.engine.ecs.system.debug.ProfilerSystemKt;
import org.veiset.kgame.engine.ecs.system.physics.CollisionGroup;
import org.veiset.kgame.engine.values.ProfilerName;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/veiset/kgame/engine/ecs/system/graphics/LightSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "engine1", "Lcom/badlogic/ashley/core/Engine;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "player", "Lorg/veiset/kgame/engine/ecs/entity/PlayerEntity;", "(Lcom/badlogic/ashley/core/Engine;Lcom/badlogic/gdx/physics/box2d/World;Lorg/veiset/kgame/engine/ecs/entity/PlayerEntity;)V", "getEngine1", "()Lcom/badlogic/ashley/core/Engine;", "getPlayer", "()Lorg/veiset/kgame/engine/ecs/entity/PlayerEntity;", "rayHandler", "Lbox2dLight/RayHandler;", "getWorld", "()Lcom/badlogic/gdx/physics/box2d/World;", "update", "", "deltaTime", "", "kgame2"})
public final class LightSystem
extends EntitySystem {
    @NotNull
    private final Engine engine1;
    @NotNull
    private final World world;
    @NotNull
    private final PlayerEntity player;
    @NotNull
    private final RayHandler rayHandler;

    public LightSystem(@NotNull Engine engine1, @NotNull World world, @NotNull PlayerEntity player) {
        Intrinsics.checkNotNullParameter((Object)engine1, (String)"engine1");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)((Object)player), (String)"player");
        this.engine1 = engine1;
        this.world = world;
        this.player = player;
        this.rayHandler = new RayHandler(this.world);
        RayHandler.useDiffuseLight((boolean)true);
        this.rayHandler.setAmbientLight(0.45f, 0.45f, 0.35f, 1.0f);
        PointLight pointLight = new PointLight(this.rayHandler, 400, new Color(0.8f, 0.8f, 0.8f, 1.0f), 5.0f, 0.0f, 0.0f);
        pointLight.setSoftnessLength(2.0f);
        pointLight.setSoft(true);
        pointLight.attachToBody(this.player.getDynamicBody().getBody());
        pointLight.setContactFilter(CollisionGroup.INSTANCE.getENVIRONMENT_AND_MONSTERS());
        this.rayHandler.setBlurNum(3);
        this.rayHandler.setShadows(true);
        Class[] classArray = new Class[]{ProjectileComponent.class};
        this.engine1.addEntityListener(Family.all((Class[])classArray).get(), (EntityListener)new SimpleAttackEvent(this.rayHandler));
    }

    @NotNull
    public final Engine getEngine1() {
        return this.engine1;
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @NotNull
    public final PlayerEntity getPlayer() {
        return this.player;
    }

    public void update(float deltaTime) {
        if (Gdx.input.isKeyJustPressed(40)) {
            EngineConfig.Effects.INSTANCE.setLIGHTS(!EngineConfig.Effects.INSTANCE.getLIGHTS());
        }
        if (!EngineConfig.Effects.INSTANCE.getLIGHTS()) {
            return;
        }
        Engine engine = this.getEngine();
        Intrinsics.checkNotNullExpressionValue((Object)engine, (String)"engine");
        ProfilerSystemKt.profile(engine, ProfilerName.LIGHT, (Function0)new Function0<Unit>(this){
            final /* synthetic */ LightSystem this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                OrthographicCamera cam = TBEngineKt.getGlobals().getDrawGfx().getCamera();
                LightSystem.access$getRayHandler$p(this.this$0).setCombinedMatrix(cam.combined.cpy().scl(120.0f), 0.0f, 0.0f, cam.viewportWidth, cam.viewportHeight);
                LightSystem.access$getRayHandler$p(this.this$0).updateAndRender();
            }
        });
    }

    public static final /* synthetic */ RayHandler access$getRayHandler$p(LightSystem $this) {
        return $this.rayHandler;
    }
}

