/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.loot;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.component.player.InventoryComponent;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.loot.BlindSystemKt;
import org.veiset.kgame.engine.modifier.ModifierEngine;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/veiset/kgame/engine/ecs/system/loot/BlindSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "blindnessShader", "Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "inventories", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "players", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class BlindSystem
extends EntitySystem {
    private ImmutableArray<Entity> players;
    private ImmutableArray<Entity> inventories;
    @NotNull
    private final AssetManager am = TBEngineKt.getGlobals().getAssetManager();
    @NotNull
    private final ShaderProgram blindnessShader = new ShaderProgram(Gdx.files.internal("shader/blindness/blindness.vert"), Gdx.files.internal("shader/blindness/blindness.frag"));

    public BlindSystem() {
        ShaderProgram.pedantic = false;
        if (!this.blindnessShader.isCompiled()) {
            String string = this.blindnessShader.getLog();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"blindnessShader.log");
            Log.INSTANCE.error(string);
        } else {
            Log.INSTANCE.debug("Blindness Shader loaded.");
        }
    }

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{PlayerCharacterComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.one((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.one(PlayerCharacterComponent::class.java).get())");
        this.players = immutableArray;
        classArray = new Class[]{InventoryComponent.class};
        immutableArray = engine.getEntitiesFor(Family.one((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.one(InventoryComponent::class.java).get())");
        this.inventories = immutableArray;
    }

    /*
     * WARNING - void declaration
     */
    public void update(float deltaTime) {
        Entity entity = this.players;
        if (entity == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"players");
            throw null;
        }
        Entity entity2 = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)entity));
        if (entity2 == null) {
            return;
        }
        Entity player = entity2;
        Object object = this.inventories;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inventories");
            throw null;
        }
        entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)object));
        if (entity == null) {
            return;
        }
        Entity inventoryEntity = entity;
        object = (InventoryComponent)Mapper.INSTANCE.getInventory().get(inventoryEntity);
        if (object == null) {
            return;
        }
        Object inventory = object;
        float blindness = ModifierEngine.INSTANCE.blind(((InventoryComponent)inventory).allMods());
        if (blindness > 0.0f) {
            TextureRegion textureRegion;
            void assetRef$iv;
            BlindSystemKt.access$getUiSpriteBatch$p().begin();
            BlindSystemKt.access$getUiSpriteBatch$p().setShader(this.blindnessShader);
            Object object2 = new Pair[]{TuplesKt.to((Object)"u_blindness", (Object)Float.valueOf(blindness))};
            BlindSystemKt.setVars(this.blindnessShader, object2);
            object2 = this.am;
            AssetRef assetRef = Asset.Texture.INSTANCE.getBlackSquare();
            SpriteBatch spriteBatch = BlindSystemKt.access$getUiSpriteBatch$p();
            boolean $i$f$get = false;
            try {
                void this_$iv;
                Object object3 = this_$iv.getAssets().get(assetRef$iv);
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
                }
                textureRegion = (TextureRegion)object3;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
            TextureRegion textureRegion2 = textureRegion;
            spriteBatch.draw(textureRegion2, 0.0f, 0.0f, 1920.0f, 1080.0f);
            BlindSystemKt.access$getUiSpriteBatch$p().end();
            BlindSystemKt.access$getUiSpriteBatch$p().setShader(null);
        }
    }
}

