/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.scenario;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ktx.graphics.ColorKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.component.scenario.BossScenarioComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.scenario.ScenarioBossSystemKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u001a\u0010\u0012\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\fR\u001a\u0010\u0015\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\n\"\u0004\b\u0017\u0010\f\u00a8\u0006#"}, d2={"Lorg/veiset/kgame/engine/ecs/system/scenario/DrawBossFrame;", "", "fadeTime", "", "textSpeed", "(FF)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "fade", "getFade", "()F", "setFade", "(F)V", "getFadeTime", "font18", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "font46", "getTextSpeed", "textTime", "getTextTime", "setTextTime", "time", "getTime", "setTime", "draw", "", "deltaTime", "boss", "Lcom/badlogic/ashley/core/Entity;", "txt", "", "drawText", "fadeComplete", "", "reset", "kgame2"})
public final class DrawBossFrame {
    private final float fadeTime;
    private final float textSpeed;
    @NotNull
    private final AssetManager am;
    @NotNull
    private final BitmapFont font18;
    @NotNull
    private final BitmapFont font46;
    private float fade;
    private float time;
    private float textTime;

    public DrawBossFrame(float fadeTime, float textSpeed) {
        BitmapFont bitmapFont;
        BitmapFont bitmapFont2;
        BitmapFont bitmapFont3;
        AssetRef assetRef$iv;
        AssetManager this_$iv;
        this.fadeTime = fadeTime;
        this.textSpeed = textSpeed;
        AssetManager assetManager = this.am = TBEngineKt.getGlobals().getAssetManager();
        AssetRef assetRef = Asset.Font.INSTANCE.getRetron18();
        DrawBossFrame drawBossFrame = this;
        boolean $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont3 = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        drawBossFrame.font18 = bitmapFont2 = bitmapFont3;
        this_$iv = this.am;
        assetRef$iv = Asset.Font.INSTANCE.getRetron46();
        drawBossFrame = this;
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        drawBossFrame.font46 = bitmapFont2 = bitmapFont;
        this.textTime = this.textSpeed;
    }

    public /* synthetic */ DrawBossFrame(float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.5f;
        }
        if ((n & 2) != 0) {
            f2 = 0.1f;
        }
        this(f, f2);
    }

    public final float getFadeTime() {
        return this.fadeTime;
    }

    public final float getTextSpeed() {
        return this.textSpeed;
    }

    public final float getFade() {
        return this.fade;
    }

    public final void setFade(float f) {
        this.fade = f;
    }

    public final float getTime() {
        return this.time;
    }

    public final void setTime(float f) {
        this.time = f;
    }

    public final float getTextTime() {
        return this.textTime;
    }

    public final void setTextTime(float f) {
        this.textTime = f;
    }

    public final boolean fadeComplete() {
        return this.fade >= this.fadeTime;
    }

    public final void reset() {
        this.fade = 0.0f;
        this.time = 0.0f;
        this.textTime = 0.0f;
    }

    public final void draw(float deltaTime, @NotNull Entity boss, @NotNull String txt) {
        Intrinsics.checkNotNullParameter((Object)boss, (String)"boss");
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        DrawBossFrame drawBossFrame = this;
        drawBossFrame.time += deltaTime;
        drawBossFrame = this;
        drawBossFrame.fade += deltaTime;
        float f = this.fade / this.fadeTime;
        float f2 = 1.0f;
        boolean bl = false;
        float opacity = Math.min(f, f2);
        ScenarioBossSystemKt.access$getUiShapeRenderer$p().begin(ShapeRenderer.ShapeType.Filled);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        ScenarioBossSystemKt.access$getUiShapeRenderer$p().setColor(ColorKt.color((float)0.0f, (float)0.0f, (float)0.0f, (float)opacity));
        ScenarioBossSystemKt.access$getUiShapeRenderer$p().rect(80.0f, 80.0f, 700.0f, 250.0f);
        ScenarioBossSystemKt.access$getUiShapeRenderer$p().end();
        TextureRegion gfx = ((BossScenarioComponent)Mapper.INSTANCE.getBossScenarioComponent().get(boss)).getIcon();
        float f3 = this.time * 10.0f;
        boolean bl2 = false;
        float y = (float)Math.sin(f3) * 30.0f;
        ScenarioBossSystemKt.access$getUiSpriteBatch$p().begin();
        ScenarioBossSystemKt.access$getUiSpriteBatch$p().draw(gfx, 100.0f, 130.0f + y, 200.0f, 200.0f);
        ScenarioBossSystemKt.access$getUiSpriteBatch$p().end();
        Gdx.gl.glDisable(3042);
        if (this.fadeComplete()) {
            this.drawText(deltaTime, txt);
        }
    }

    public final void drawText(float deltaTime, @NotNull String txt) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        DrawBossFrame drawBossFrame = this;
        drawBossFrame.textTime += deltaTime;
        int numberOfChars = (int)(this.textTime / this.textSpeed);
        String chrs = StringsKt.take((String)txt, (int)numberOfChars);
        float f = this.time * 10.0f;
        boolean bl = false;
        float y = (float)Math.cos(f) * 5.0f;
        this.font18.setColor(Color.GRAY);
        ScenarioBossSystemKt.access$getUiSpriteBatch$p().begin();
        this.font46.draw((Batch)ScenarioBossSystemKt.access$getUiSpriteBatch$p(), (CharSequence)chrs, 280.0f, 210.0f + y);
        this.font18.draw((Batch)ScenarioBossSystemKt.access$getUiSpriteBatch$p(), (CharSequence)"[space] to continue", 556.0f, 116.0f);
        ScenarioBossSystemKt.access$getUiSpriteBatch$p().end();
    }

    public DrawBossFrame() {
        this(0.0f, 0.0f, 3, null);
    }
}

