/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.math.Hex;
import org.veiset.kgame.engine.math.HexOrientation;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u0015\u0010\f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0086\u0002\u001a\u0015\u0010\u000e\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0086\u0002\u001a\u0015\u0010\u000f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000bH\u0086\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"hexDirections", "", "Lorg/veiset/kgame/engine/math/Hex;", "getHexDirections", "()Ljava/util/List;", "layoutPointy", "Lorg/veiset/kgame/engine/math/HexOrientation;", "getLayoutPointy", "()Lorg/veiset/kgame/engine/math/HexOrientation;", "generateHexCircle", "circleSize", "", "minus", "hex", "plus", "times", "k", "kgame2"})
public final class HexagonKt {
    @NotNull
    private static final List<Hex> hexDirections;
    @NotNull
    private static final HexOrientation layoutPointy;

    @NotNull
    public static final List<Hex> getHexDirections() {
        return hexDirections;
    }

    @NotNull
    public static final HexOrientation getLayoutPointy() {
        return layoutPointy;
    }

    @NotNull
    public static final Hex plus(@NotNull Hex $this$plus, @NotNull Hex hex) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        return new Hex($this$plus.getQ() + hex.getQ(), $this$plus.getR() + hex.getR());
    }

    @NotNull
    public static final Hex minus(@NotNull Hex $this$minus, @NotNull Hex hex) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        return new Hex($this$minus.getQ() - hex.getQ(), $this$minus.getR() - hex.getR());
    }

    @NotNull
    public static final Hex times(@NotNull Hex $this$times, int k) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        return new Hex($this$times.getQ() * k, $this$times.getR() * k);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Hex> generateHexCircle(int circleSize) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = (Iterable)RangesKt.until((int)0, (int)circleSize);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            int element$iv$iv;
            int row = element$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int halfSize = circleSize - circleSize / 2;
            int n = circleSize - halfSize - row;
            int n2 = 0;
            boolean bl2 = false;
            int start = Math.max(n, n2);
            int elements = row < halfSize ? halfSize + row : circleSize + halfSize - row - 1;
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)elements);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void col;
                int item$iv$iv;
                int n3 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                Hex hex = new Hex((int)(col + start), row);
                collection.add(hex);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        Object[] objectArray = new Hex[]{new Hex(1, 0), new Hex(1, -1), new Hex(0, -1), new Hex(-1, 0), new Hex(-1, 1), new Hex(0, 1)};
        hexDirections = CollectionsKt.listOf((Object[])objectArray);
        float f = 3.0f;
        boolean bl = false;
        float f2 = (float)Math.sqrt(f);
        f = 3.0f;
        bl = false;
        float f3 = (float)Math.sqrt(f) / 2.0f;
        f = 3.0f;
        bl = false;
        layoutPointy = new HexOrientation(f2, f3, 0.0f, 1.5f, (float)Math.sqrt(f) / 3.0f, -0.33333334f, 0.0f, 0.6666667f, 0.5f);
    }
}

