/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.math;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.input.MouseKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u001a\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u001a\r\u0010\r\u001a\u00020\u0001*\u00020\nH\u0086\u0002\u001a\r\u0010\u000e\u001a\u00020\u0001*\u00020\nH\u0086\u0002\u001a\n\u0010\u000f\u001a\u00020\n*\u00020\n\u001a\n\u0010\u0010\u001a\u00020\n*\u00020\n\u001a\n\u0010\u0011\u001a\u00020\n*\u00020\n\u001a\u0015\u0010\u0012\u001a\u00020\n*\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0086\u0002\u001a\n\u0010\u0014\u001a\u00020\n*\u00020\n\u001a\u0015\u0010\u0015\u001a\u00020\n*\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0086\u0002\u001a\u0015\u0010\u0016\u001a\u00020\n*\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0086\u0002\u001a\u0015\u0010\u0016\u001a\u00020\n*\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0001H\u0086\u0002\u001a\r\u0010\u0019\u001a\u00020\n*\u00020\nH\u0086\u0002\u001a\n\u0010\u001a\u001a\u00020\n*\u00020\u001b\u001a\u0015\u0010\u001c\u001a\u00020\n*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001H\u0086\u0004\u001a\u0015\u0010\u001c\u001a\u00020\n*\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0004\u00a8\u0006\u001f"}, d2={"expLerp", "", "t", "min", "max", "weight", "lerp", "pointerWithinSquare", "", "pos", "Lcom/badlogic/gdx/math/Vector2;", "size", "uiPointerWithinSquare", "component1", "component2", "copy", "dw", "gfxToWorld", "minus", "v", "perpendicular", "plus", "times", "direction", "scl", "unaryMinus", "v2", "Lcom/badlogic/gdx/math/Vector3;", "x", "y", "", "kgame2"})
public final class Vector2Kt {
    public static final float component1(@NotNull Vector2 $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return $this$component1.x;
    }

    public static final float component2(@NotNull Vector2 $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        return $this$component2.y;
    }

    @NotNull
    public static final Vector2 minus(@NotNull Vector2 $this$minus, @NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Vector2($this$minus.x - v.x, $this$minus.y - v.y);
    }

    @NotNull
    public static final Vector2 plus(@NotNull Vector2 $this$plus, @NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Vector2($this$plus.x + v.x, $this$plus.y + v.y);
    }

    @NotNull
    public static final Vector2 unaryMinus(@NotNull Vector2 $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        return new Vector2(-$this$unaryMinus.x, -$this$unaryMinus.y);
    }

    @NotNull
    public static final Vector2 times(@NotNull Vector2 $this$times, @NotNull Vector2 direction) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Vector2 vector2 = $this$times;
        float x = Vector2Kt.component1(vector2);
        float y = Vector2Kt.component2(vector2);
        Vector2 vector22 = direction;
        float dx = Vector2Kt.component1(vector22);
        float dy = Vector2Kt.component2(vector22);
        return new Vector2(x * dx, y * dy);
    }

    @NotNull
    public static final Vector2 times(@NotNull Vector2 $this$times, float scl) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        Vector2 vector2 = $this$times;
        float x = Vector2Kt.component1(vector2);
        float y = Vector2Kt.component2(vector2);
        return new Vector2(x * scl, y * scl);
    }

    @NotNull
    public static final Vector2 perpendicular(@NotNull Vector2 $this$perpendicular) {
        Intrinsics.checkNotNullParameter((Object)$this$perpendicular, (String)"<this>");
        return new Vector2(-$this$perpendicular.y, $this$perpendicular.x);
    }

    @NotNull
    public static final Vector2 copy(@NotNull Vector2 $this$copy) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        return new Vector2($this$copy.x, $this$copy.y);
    }

    @NotNull
    public static final Vector2 dw(@NotNull Vector2 $this$dw) {
        Intrinsics.checkNotNullParameter((Object)$this$dw, (String)"<this>");
        return new Vector2($this$dw.x * 120.0f, $this$dw.y * 120.0f);
    }

    @NotNull
    public static final Vector2 gfxToWorld(@NotNull Vector2 $this$gfxToWorld) {
        Intrinsics.checkNotNullParameter((Object)$this$gfxToWorld, (String)"<this>");
        return new Vector2($this$gfxToWorld.x / 120.0f, $this$gfxToWorld.y / 120.0f);
    }

    @NotNull
    public static final Vector2 v2(@NotNull Vector3 $this$v2) {
        Intrinsics.checkNotNullParameter((Object)$this$v2, (String)"<this>");
        return new Vector2($this$v2.x, $this$v2.y);
    }

    @NotNull
    public static final Vector2 x(float $this$x, float y) {
        return new Vector2($this$x, y);
    }

    @NotNull
    public static final Vector2 x(int $this$x, int y) {
        return new Vector2((float)$this$x, (float)y);
    }

    public static final boolean pointerWithinSquare(@NotNull Vector2 pos, @NotNull Vector2 size) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Vector2 vector2 = MouseKt.scaledPointer();
        float px = Vector2Kt.component1(vector2);
        float py = Vector2Kt.component2(vector2);
        Vector2 vector22 = pos;
        float x = Vector2Kt.component1(vector22);
        float y = Vector2Kt.component2(vector22);
        Vector2 vector23 = size;
        float sx = Vector2Kt.component1(vector23);
        float sy = Vector2Kt.component2(vector23);
        return x <= px && x + sx >= px && y <= py && y + sy >= py;
    }

    public static final boolean uiPointerWithinSquare(@NotNull Vector2 pos, @NotNull Vector2 size) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Vector2 vector2 = MouseKt.uiPointer();
        float px = Vector2Kt.component1(vector2);
        float py = Vector2Kt.component2(vector2);
        Vector2 vector22 = pos;
        float x = Vector2Kt.component1(vector22);
        float y = Vector2Kt.component2(vector22);
        Vector2 vector23 = size;
        float sx = Vector2Kt.component1(vector23);
        float sy = Vector2Kt.component2(vector23);
        return x <= px && x + sx >= px && y <= py && y + sy >= py;
    }

    public static final float expLerp(float t, float min, float max, float weight) {
        float normal;
        float current = Vector2Kt.lerp(t, min, max);
        float f = normal = (current - min) / (max - min);
        boolean bl = false;
        float exp = (float)Math.pow(f, weight);
        return exp * (max - min) + min;
    }

    public static final float lerp(float t, float min, float max) {
        return min * (1.0f - t) + max * t;
    }
}

