/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.ecs.component.levelselect.GameLevelComponent;
import org.veiset.kgame.engine.math.Hex;
import org.veiset.kgame.engine.math.HexLayout;
import org.veiset.kgame.engine.math.HexagonKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.state.GameStateKt;
import org.veiset.kgame.engine.state.LevelMonsters;
import org.veiset.kgame.engine.world.FireBossTiles;
import org.veiset.kgame.engine.world.WorldMapTileThreshold;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J7\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lorg/veiset/kgame/engine/state/GameState;", "", "seed", "Lkotlin/random/Random;", "hexLayout", "Lorg/veiset/kgame/engine/math/HexLayout;", "levels", "", "Lorg/veiset/kgame/engine/ecs/component/levelselect/GameLevelComponent;", "selectedLevel", "(Lkotlin/random/Random;Lorg/veiset/kgame/engine/math/HexLayout;Ljava/util/List;Lorg/veiset/kgame/engine/ecs/component/levelselect/GameLevelComponent;)V", "getHexLayout", "()Lorg/veiset/kgame/engine/math/HexLayout;", "getLevels", "()Ljava/util/List;", "getSeed", "()Lkotlin/random/Random;", "getSelectedLevel", "()Lorg/veiset/kgame/engine/ecs/component/levelselect/GameLevelComponent;", "setSelectedLevel", "(Lorg/veiset/kgame/engine/ecs/component/levelselect/GameLevelComponent;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kgame2"})
public final class GameState {
    @NotNull
    private final Random seed;
    @NotNull
    private final HexLayout hexLayout;
    @NotNull
    private final List<GameLevelComponent> levels;
    @NotNull
    private GameLevelComponent selectedLevel;

    public GameState(@NotNull Random seed, @NotNull HexLayout hexLayout, @NotNull List<GameLevelComponent> levels, @NotNull GameLevelComponent selectedLevel) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)hexLayout, (String)"hexLayout");
        Intrinsics.checkNotNullParameter(levels, (String)"levels");
        Intrinsics.checkNotNullParameter((Object)selectedLevel, (String)"selectedLevel");
        this.seed = seed;
        this.hexLayout = hexLayout;
        this.levels = levels;
        this.selectedLevel = selectedLevel;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ GameState(Random random, HexLayout hexLayout, List list, GameLevelComponent gameLevelComponent, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        Iterable $this$map$iv;
        if ((n & 1) != 0) {
            random = RandomKt.Random((long)Random.Default.nextLong());
        }
        if ((n & 2) != 0) {
            hexLayout = new HexLayout(HexagonKt.getLayoutPointy(), Vector2Kt.x(0.6f, 0.6f), Vector2Kt.x(3.0f, 3.0f));
        }
        if ((n & 4) != 0) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapTo$iv$iv;
            $this$map$iv = HexagonKt.generateHexCircle(5);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Hex hex = (Hex)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                WorldMapTileThreshold worldMapTileThreshold = GameStateKt.randomTileset$default(null, 1, null);
                LevelMonsters levelMonsters = new LevelMonsters(30 + (int)((float)20 * random.nextFloat()), 1, 0, 4, null);
                long l = random.nextLong();
                GameLevelComponent gameLevelComponent2 = new GameLevelComponent("Description...", (Hex)it, worldMapTileThreshold, false, levelMonsters, 0, l);
                collection.add(gameLevelComponent2);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            bl = false;
            Iterable it = $this$map$iv;
            boolean bl3 = false;
            ((GameLevelComponent)CollectionsKt.random((Collection)((Collection)it), (Random)random)).setRequirement(3);
            $i$f$map = false;
            bl = false;
            it = $this$map$iv;
            boolean bl4 = false;
            int bossIndex = (int)(random.nextFloat() * (float)it.size());
            Iterable $this$mapIndexed$iv = CollectionsKt.shuffled((Iterable)it, (Random)random);
            boolean $i$f$mapIndexed = false;
            Iterable bl2 = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void it2;
                void index;
                int n2 = index$iv$iv++;
                boolean bl5 = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                GameLevelComponent gameLevelComponent3 = (GameLevelComponent)item$iv$iv;
                int n3 = n2;
                Collection collection = destination$iv$iv2;
                boolean bl6 = false;
                void var27_35 = index == bossIndex ? GameLevelComponent.copy$default((GameLevelComponent)it2, null, null, new FireBossTiles(null, null, 3, null), false, new LevelMonsters(0, 0, 1), 0, 0L, 107, null) : it2;
                collection.add(var27_35);
            }
            list = (List)destination$iv$iv2;
        }
        if ((n & 8) != 0) {
            void $this$sortedByDescending$iv;
            $this$map$iv = list;
            boolean $i$f$sortedByDescending = false;
            bl = false;
            gameLevelComponent = (GameLevelComponent)CollectionsKt.random((Collection)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    GameLevelComponent it = (GameLevelComponent)b;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getRequirement());
                    it = (GameLevelComponent)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getRequirement();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            }), (Random)random);
        }
        this(random, hexLayout, list, gameLevelComponent);
    }

    @NotNull
    public final Random getSeed() {
        return this.seed;
    }

    @NotNull
    public final HexLayout getHexLayout() {
        return this.hexLayout;
    }

    @NotNull
    public final List<GameLevelComponent> getLevels() {
        return this.levels;
    }

    @NotNull
    public final GameLevelComponent getSelectedLevel() {
        return this.selectedLevel;
    }

    public final void setSelectedLevel(@NotNull GameLevelComponent gameLevelComponent) {
        Intrinsics.checkNotNullParameter((Object)gameLevelComponent, (String)"<set-?>");
        this.selectedLevel = gameLevelComponent;
    }

    @NotNull
    public final Random component1() {
        return this.seed;
    }

    @NotNull
    public final HexLayout component2() {
        return this.hexLayout;
    }

    @NotNull
    public final List<GameLevelComponent> component3() {
        return this.levels;
    }

    @NotNull
    public final GameLevelComponent component4() {
        return this.selectedLevel;
    }

    @NotNull
    public final GameState copy(@NotNull Random seed, @NotNull HexLayout hexLayout, @NotNull List<GameLevelComponent> levels, @NotNull GameLevelComponent selectedLevel) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)hexLayout, (String)"hexLayout");
        Intrinsics.checkNotNullParameter(levels, (String)"levels");
        Intrinsics.checkNotNullParameter((Object)selectedLevel, (String)"selectedLevel");
        return new GameState(seed, hexLayout, levels, selectedLevel);
    }

    public static /* synthetic */ GameState copy$default(GameState gameState, Random random, HexLayout hexLayout, List list, GameLevelComponent gameLevelComponent, int n, Object object) {
        if ((n & 1) != 0) {
            random = gameState.seed;
        }
        if ((n & 2) != 0) {
            hexLayout = gameState.hexLayout;
        }
        if ((n & 4) != 0) {
            list = gameState.levels;
        }
        if ((n & 8) != 0) {
            gameLevelComponent = gameState.selectedLevel;
        }
        return gameState.copy(random, hexLayout, list, gameLevelComponent);
    }

    @NotNull
    public String toString() {
        return "GameState(seed=" + this.seed + ", hexLayout=" + this.hexLayout + ", levels=" + this.levels + ", selectedLevel=" + this.selectedLevel + ')';
    }

    public int hashCode() {
        int result = this.seed.hashCode();
        result = result * 31 + this.hexLayout.hashCode();
        result = result * 31 + ((Object)this.levels).hashCode();
        result = result * 31 + this.selectedLevel.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GameState)) {
            return false;
        }
        GameState gameState = (GameState)other;
        if (!Intrinsics.areEqual((Object)this.seed, (Object)gameState.seed)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hexLayout, (Object)gameState.hexLayout)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.levels, gameState.levels)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.selectedLevel, (Object)gameState.selectedLevel);
    }

    public GameState() {
        this(null, null, null, null, 15, null);
    }
}

