/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.ashley.core.Engine;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.GameModule;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.editor.area.AreaData;
import org.veiset.kgame.engine.tools.editor.area.AreaEditor;
import org.veiset.kgame.engine.tools.editor.area.AreaFileBrowser;
import org.veiset.kgame.engine.tools.editor.area.AreaResource;
import org.veiset.kgame.engine.tools.editor.area.GraphicEntityData;
import org.veiset.kgame.engine.tools.ui.components.TextSelectList;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u0001H\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006$"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/AreaFileBrowser;", "Lorg/veiset/kgame/engine/GameModule;", "engine", "Lcom/badlogic/ashley/core/Engine;", "editor", "Lorg/veiset/kgame/engine/tools/editor/area/AreaEditor;", "(Lcom/badlogic/ashley/core/Engine;Lorg/veiset/kgame/engine/tools/editor/area/AreaEditor;)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "areaResource", "Lorg/veiset/kgame/engine/tools/editor/area/AreaResource;", "areas", "", "Lorg/veiset/kgame/engine/tools/editor/area/AreaData;", "components", "Lorg/veiset/kgame/engine/tools/ui/components/TextSelectList;", "getComponents", "()Ljava/util/List;", "getEditor", "()Lorg/veiset/kgame/engine/tools/editor/area/AreaEditor;", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "sceneItemsList", "selected", "getSelected", "()Lorg/veiset/kgame/engine/tools/editor/area/AreaData;", "setSelected", "(Lorg/veiset/kgame/engine/tools/editor/area/AreaData;)V", "drawPreview", "", "nextState", "setup", "teardown", "update", "delta", "", "kgame2"})
public final class AreaFileBrowser
implements GameModule {
    @NotNull
    private final Engine engine;
    @Nullable
    private final AreaEditor editor;
    @NotNull
    private final AssetManager am;
    @NotNull
    private final AreaResource areaResource;
    @NotNull
    private final List<AreaData> areas;
    @NotNull
    private final TextSelectList<AreaData> sceneItemsList;
    @Nullable
    private AreaData selected;
    @NotNull
    private final List<TextSelectList<AreaData>> components;

    public AreaFileBrowser(@NotNull Engine engine, @Nullable AreaEditor editor) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        this.engine = engine;
        this.editor = editor;
        this.am = TBEngineKt.getGlobals().getAssetManager();
        this.areaResource = new AreaResource("area");
        this.areas = this.areaResource.all();
        this.sceneItemsList = new TextSelectList<Object>(Vector2Kt.x(0.05f, 0.05f), Vector2Kt.x(15.9f, 8.0f), this.areas, CollectionsKt.firstOrNull(this.areas), sceneItemsList.1.INSTANCE);
        this.selected = (AreaData)CollectionsKt.firstOrNull(this.areas);
        this.components = CollectionsKt.listOf(this.sceneItemsList);
    }

    public /* synthetic */ AreaFileBrowser(Engine engine, AreaEditor areaEditor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            areaEditor = null;
        }
        this(engine, areaEditor);
    }

    @Override
    @NotNull
    public Engine getEngine() {
        return this.engine;
    }

    @Nullable
    public final AreaEditor getEditor() {
        return this.editor;
    }

    @Nullable
    public final AreaData getSelected() {
        return this.selected;
    }

    public final void setSelected(@Nullable AreaData areaData) {
        this.selected = areaData;
    }

    @NotNull
    public final List<TextSelectList<AreaData>> getComponents() {
        return this.components;
    }

    @Override
    public void setup() {
        EngineConfig.Debug.INSTANCE.setPROFILER(false);
    }

    @Override
    public void teardown() {
        EngineConfig.Debug.INSTANCE.setPROFILER(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(float delta) {
        AreaData scene;
        this.selected = this.sceneItemsList.getSelected();
        Iterable $this$forEach$iv = this.components;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            TextSelectList it = (TextSelectList)element$iv;
            boolean bl = false;
            it.draw();
            it.update();
        }
        if (Gdx.input.isKeyJustPressed(19)) {
            this.sceneItemsList.previous();
        }
        if (Gdx.input.isKeyJustPressed(20)) {
            this.sceneItemsList.next();
        }
        if (Gdx.input.isKeyJustPressed(112) && (scene = this.selected) != null && this.areaResource.delete(scene.getName())) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object element$iv;
            Iterable $i$f$forEach2 = this.sceneItemsList.getOptions();
            TextSelectList<AreaData> textSelectList = this.sceneItemsList;
            boolean $i$f$filter = false;
            element$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AreaData it = (AreaData)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)scene))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            textSelectList.setOptions(list);
            this.sceneItemsList.setSelected((AreaData)CollectionsKt.firstOrNull(this.sceneItemsList.getOptions()));
        }
        this.drawPreview();
    }

    /*
     * WARNING - void declaration
     */
    public final void drawPreview() {
        void $this$forEach$iv;
        void $this$filterIsInstanceTo$iv$iv;
        AreaData areaData = this.selected;
        if (areaData == null) {
            return;
        }
        AreaData scene = areaData;
        SpriteBatch sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        ShapeRenderer sr = TBEngineKt.getGlobals().getDrawUi().getShapeRenderer();
        float previewScale = 0.5f;
        float l = 0.53333336f;
        Vector2 vector2 = Vector2Kt.x(15.9f - scene.getSize().x * previewScale, 8.0f - scene.getSize().y * previewScale);
        float xo = Vector2Kt.component1(vector2);
        float yo = Vector2Kt.component2(vector2);
        sb.begin();
        Iterable $this$filterIsInstance$iv = scene.getEntities();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GraphicEntityData)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List gfx = (List)destination$iv$iv;
        if (gfx.isEmpty()) {
            return;
        }
        float diffX = scene.getPosition().x * previewScale;
        float diffY = scene.getPosition().y * previewScale;
        Iterable $this$sortedByDescending$iv = gfx;
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                GraphicEntityData it = (GraphicEntityData)b;
                boolean bl2 = false;
                it = (GraphicEntityData)a;
                Comparable comparable = Float.valueOf(it.getPosition().y);
                bl2 = false;
                Float f = Float.valueOf(it.getPosition().y);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)f);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextureRegion textureRegion;
            GraphicEntityData it = (GraphicEntityData)element$iv;
            boolean bl2 = false;
            Vector2 vector22 = Vector2Kt.copy(it.getPosition()).scl(previewScale);
            Intrinsics.checkNotNullExpressionValue((Object)vector22, (String)"scl(previewScale)");
            float x = Vector2Kt.component1(vector22);
            float y = Vector2Kt.component2(vector22);
            Vector2 vector23 = Vector2Kt.copy(it.getSize()).scl(previewScale);
            Intrinsics.checkNotNullExpressionValue((Object)vector23, (String)"scl(previewScale)");
            float sx = Vector2Kt.component1(vector23);
            float sy = Vector2Kt.component2(vector23);
            float ps = 120.0f;
            AssetManager assetManager = this.am;
            String id$iv = it.getTextureId();
            boolean $i$f$getById = false;
            try {
                void this_$iv;
                Object object = this_$iv.getAssetsIdMap().get(id$iv);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
                }
                textureRegion = (TextureRegion)object;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef id '" + id$iv + "' not loaded");
                throw ex$iv;
            }
            TextureRegion texture = textureRegion;
            sb.draw(texture, (x + xo - diffX) * ps, (y + yo - diffY) * ps, sx * ps, sy * ps);
        }
        sb.end();
        sr.begin(ShapeRenderer.ShapeType.Line);
        sr.setColor(Color.GRAY);
        Vector2 vector24 = Vector2Kt.dw(Vector2Kt.x(xo, yo));
        iterable = Vector2Kt.dw(scene.getSize()).scl(previewScale);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"scene.size.dw().scl(previewScale)");
        ShapeRendererKt.rect((ShapeRenderer)sr, (Vector2)vector24, (Vector2)iterable);
        sr.end();
    }

    @Override
    @NotNull
    public GameModule nextState() {
        if (Gdx.input.isKeyJustPressed(111) && this.editor != null) {
            return this.editor;
        }
        if (Gdx.input.isKeyJustPressed(66) && this.selected != null) {
            Engine engine = new Engine();
            AreaData areaData = this.selected;
            Intrinsics.checkNotNull((Object)areaData);
            return new AreaEditor(engine, areaData, null, 4, null);
        }
        return this;
    }
}

