/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.gdx.math.Vector2;
import java.time.LocalDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.math.MathUtilsKt;
import org.veiset.kgame.engine.tools.editor.area.AreaResourceKt;
import org.veiset.kgame.engine.tools.editor.area.components.SceneContainer;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002\u001a\f\u0010\u000f\u001a\u00020\t*\u00020\u0010H\u0000\u001a\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\tH\u0000\u00a2\u0006\u0002\u0010\u0013\u001a\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\tH\u0000\u00a2\u0006\u0002\u0010\u0016\u001a\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0010*\u00020\tH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\u0018"}, d2={"validFloat", "Lkotlin/text/Regex;", "getValidFloat", "()Lkotlin/text/Regex;", "validInt", "getValidInt", "validVector2Format", "getValidVector2Format", "generateSaveString", "", "scene", "Lorg/veiset/kgame/engine/tools/editor/area/components/SceneContainer;", "name", "tags", "", "toEditStr", "Lcom/badlogic/gdx/math/Vector2;", "toValidFloat", "", "(Ljava/lang/String;)Ljava/lang/Float;", "toValidInt", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "toVector2", "kgame2"})
public final class AreaResourceKt {
    @NotNull
    private static final Regex validVector2Format;
    @NotNull
    private static final Regex validFloat;
    @NotNull
    private static final Regex validInt;

    @NotNull
    public static final Regex getValidVector2Format() {
        return validVector2Format;
    }

    @NotNull
    public static final Regex getValidFloat() {
        return validFloat;
    }

    @NotNull
    public static final Regex getValidInt() {
        return validInt;
    }

    @NotNull
    public static final String toEditStr(@NotNull Vector2 $this$toEditStr) {
        Intrinsics.checkNotNullParameter((Object)$this$toEditStr, (String)"<this>");
        return MathUtilsKt.round($this$toEditStr.x, 3) + ", " + MathUtilsKt.round($this$toEditStr.y, 3);
    }

    @Nullable
    public static final Vector2 toVector2(@NotNull String $this$toVector2) {
        Intrinsics.checkNotNullParameter((Object)$this$toVector2, (String)"<this>");
        MatchResult matchResult = Regex.find$default((Regex)validVector2Format, (CharSequence)$this$toVector2, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        MatchResult matchResult2 = matchResult = match.getDestructured();
        boolean bl = false;
        String x = (String)matchResult2.getMatch().getGroupValues().get(1);
        Object object = matchResult;
        boolean bl2 = false;
        String y = (String)object.getMatch().getGroupValues().get(2);
        object = x;
        bl2 = false;
        float f = Float.parseFloat((String)object);
        object = y;
        bl2 = false;
        return new Vector2(f, Float.parseFloat((String)object));
    }

    @Nullable
    public static final Integer toValidInt(@NotNull String $this$toValidInt) {
        Intrinsics.checkNotNullParameter((Object)$this$toValidInt, (String)"<this>");
        Object object = Regex.find$default((Regex)validInt, (CharSequence)$this$toValidInt, (int)0, (int)2, null);
        if (object == null) {
            return null;
        }
        MatchResult match = object;
        object = (String)match.getGroupValues().get(0);
        boolean bl = false;
        return Integer.parseInt((String)object);
    }

    @Nullable
    public static final Float toValidFloat(@NotNull String $this$toValidFloat) {
        Intrinsics.checkNotNullParameter((Object)$this$toValidFloat, (String)"<this>");
        Object object = Regex.find$default((Regex)validFloat, (CharSequence)$this$toValidFloat, (int)0, (int)2, null);
        if (object == null) {
            return null;
        }
        MatchResult match = object;
        object = (String)match.getGroupValues().get(0);
        boolean bl = false;
        return Float.valueOf(Float.parseFloat((String)object));
    }

    private static final String generateSaveString(SceneContainer scene, String name, List<String> tags) {
        SceneContainer.BoundingBox boundingBox = scene.boundingBox();
        SceneContainer.BoundingBox gridBox = SceneContainer.gridBox$default(scene, 0.0f, 1, null);
        String[] stringArray = new String[]{"\n"};
        String metadata2 = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)StringsKt.trimIndent((String)("\n            meta\n            |engine.gridsize=0.53333336\n            |name=" + name + "\n            |tags=" + CollectionsKt.joinToString$default((Iterable)tags, (CharSequence)",", null, null, (int)0, null, (Function1)generateSaveString.metadata.1.INSTANCE, (int)30, null) + "\n            |position=" + boundingBox.getPos().x + ',' + boundingBox.getPos().y + "\n            |size=" + boundingBox.getSize().x + ',' + boundingBox.getSize().y + "\n            |gridsize=" + gridBox.getSize().x + ',' + gridBox.getSize().y + "\n            |modified=" + LocalDateTime.now() + "\n        ")), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"", null, null, (int)0, null, (Function1)generateSaveString.metadata.2.INSTANCE, (int)30, null);
        String entities2 = CollectionsKt.joinToString$default((Iterable)scene.getItems(), (CharSequence)"\n", null, null, (int)0, null, (Function1)generateSaveString.entities.1.INSTANCE, (int)30, null);
        return metadata2 + '\n' + entities2;
    }

    public static final /* synthetic */ String access$generateSaveString(SceneContainer scene, String name, List tags) {
        return AreaResourceKt.generateSaveString(scene, name, tags);
    }

    static {
        String string = "(-?\\d+(?:\\.\\d+)?),\\s?(-?\\d+(?:\\.\\d+)?)";
        boolean bl = false;
        validVector2Format = new Regex(string);
        string = "(\\d+(?:\\.\\d+)?)";
        bl = false;
        validFloat = new Regex(string);
        string = "(-?\\d+)";
        bl = false;
        validInt = new Regex(string);
    }
}

