/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.physics.box2d.World;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.ecs.component.physics.StaticBodyComponent;
import org.veiset.kgame.engine.tools.editor.area.AreaEntity;
import org.veiset.kgame.engine.tools.editor.area.BaseEntityData;
import org.veiset.kgame.engine.tools.editor.area.CollisionEntity;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0016\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003J\u0013\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u001dH\u00d6\u0001J\b\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/CollisionEntity;", "Lorg/veiset/kgame/engine/tools/editor/area/AreaEntity;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "base", "Lorg/veiset/kgame/engine/tools/editor/area/BaseEntityData;", "(Lcom/badlogic/gdx/physics/box2d/World;Lorg/veiset/kgame/engine/tools/editor/area/BaseEntityData;)V", "getBase", "()Lorg/veiset/kgame/engine/tools/editor/area/BaseEntityData;", "entity", "Lcom/badlogic/ashley/core/Entity;", "getEntity", "()Lcom/badlogic/ashley/core/Entity;", "staticBodyComponent", "Lorg/veiset/kgame/engine/ecs/component/physics/StaticBodyComponent;", "getWorld", "()Lcom/badlogic/gdx/physics/box2d/World;", "component1", "component2", "copy", "deepCopy", "newId", "", "equals", "other", "", "hashCode", "", "save", "", "toString", "update", "", "kgame2"})
public final class CollisionEntity
extends AreaEntity {
    @NotNull
    private final World world;
    @NotNull
    private final BaseEntityData base;
    @NotNull
    private final Entity entity;
    @NotNull
    private StaticBodyComponent staticBodyComponent;

    public CollisionEntity(@NotNull World world, @NotNull BaseEntityData base) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        super(null);
        this.world = world;
        this.base = base;
        this.entity = new Entity();
        this.staticBodyComponent = new StaticBodyComponent(this.world, this.getEntity(), this.getBase().getPosition(), this.getBase().getSize());
        this.getEntity().add((Component)this.staticBodyComponent);
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @Override
    @NotNull
    public BaseEntityData getBase() {
        return this.base;
    }

    @Override
    @NotNull
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public void update() {
        this.world.destroyBody(this.staticBodyComponent.getBody());
        this.staticBodyComponent = new StaticBodyComponent(this.world, this.getEntity(), this.getBase().getPosition(), this.getBase().getSize());
        this.getEntity().removeAll();
        this.getEntity().add((Component)this.staticBodyComponent);
    }

    @Override
    @NotNull
    public String save() {
        String[] stringArray = new String[]{"\n"};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)StringsKt.trimIndent((String)("\n            collision\n            |id=" + this.getBase().getId() + "\n            |position=" + this.getBase().getPosition().x + ',' + this.getBase().getPosition().y + "\n            |size=" + this.getBase().getSize().x + ',' + this.getBase().getSize().y + "\n            |boundingBox=" + this.getBase().getBoundingBox() + "\n        ")), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"", null, null, (int)0, null, (Function1)save.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public final AreaEntity deepCopy(boolean newId, @NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return new CollisionEntity(world, this.getBase().deepCopy(newId));
    }

    @NotNull
    public final World component1() {
        return this.world;
    }

    @NotNull
    public final BaseEntityData component2() {
        return this.getBase();
    }

    @NotNull
    public final CollisionEntity copy(@NotNull World world, @NotNull BaseEntityData base) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        return new CollisionEntity(world, base);
    }

    public static /* synthetic */ CollisionEntity copy$default(CollisionEntity collisionEntity, World world, BaseEntityData baseEntityData, int n, Object object) {
        if ((n & 1) != 0) {
            world = collisionEntity.world;
        }
        if ((n & 2) != 0) {
            baseEntityData = collisionEntity.getBase();
        }
        return collisionEntity.copy(world, baseEntityData);
    }

    @NotNull
    public String toString() {
        return "CollisionEntity(world=" + this.world + ", base=" + this.getBase() + ')';
    }

    public int hashCode() {
        int result = this.world.hashCode();
        result = result * 31 + this.getBase().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CollisionEntity)) {
            return false;
        }
        CollisionEntity collisionEntity = (CollisionEntity)other;
        if (!Intrinsics.areEqual((Object)this.world, (Object)collisionEntity.world)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getBase(), (Object)collisionEntity.getBase());
    }
}

